/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.google.common.collect.Sets;
import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.diffutil.DiffResult;
import com.mongodb.diffutil.OplogTailingDiffTaskResult;
import com.mongodb.diffutil.OplogTailingDiffUtil;
import com.mongodb.model.Namespace;
import com.mongodb.model.OplogSummary;
import com.mongodb.model.ShardTimestamp;
import com.mongodb.oplog.OplogUtil;
import com.mongodb.shardsync.ShardClient;
import com.mongodb.util.DiffUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogTailingDiffTask
implements Callable<OplogTailingDiffTaskResult> {
    protected static final Logger logger = LoggerFactory.getLogger(OplogTailingDiffUtil.class);
    private static final int ONE_MINUTE = 60000;
    private static final Document SORT_ID = new Document("_id", (Object)1);
    private static final int batchSize = 1000;
    private String sourceShardId;
    private String destShardId;
    private ShardClient sourceClient;
    private ShardClient destClient;
    private MongoClient sourceMongoClient;
    private MongoClient destMongoClient;
    List<Future<DiffResult>> futures = Collections.synchronizedList(new LinkedList());
    Map<Namespace, Set<Object>> namespaceBuffers = new HashMap<Namespace, Set<Object>>();

    public OplogTailingDiffTask(String sourceShardId, String destShardId, ShardClient sourceClient, ShardClient destClient, int threads, int queueSize) {
        this.sourceShardId = sourceShardId;
        this.destShardId = destShardId;
        this.sourceClient = sourceClient;
        this.destClient = destClient;
        this.sourceMongoClient = sourceClient.getShardMongoClient(sourceShardId);
        this.destMongoClient = destClient.getShardMongoClient(destShardId);
    }

    private DiffResult diff(Set<Object> buffer, String sourceShardId, Namespace ns, MongoClient sourceClient, MongoClient destClient) throws Exception {
        DiffResult result = new DiffResult(sourceShardId);
        Bson filter = Filters.in((String)"_id", buffer);
        MongoDatabase sourceDb = this.sourceMongoClient.getDatabase(ns.getDatabaseName());
        MongoDatabase destDb = this.destMongoClient.getDatabase(ns.getDatabaseName());
        MongoCollection sourceColl = sourceDb.getCollection(ns.getCollectionName(), RawBsonDocument.class);
        MongoCollection destColl = destDb.getCollection(ns.getCollectionName(), RawBsonDocument.class);
        MongoCursor sourceCursor = sourceColl.find(filter).sort((Bson)SORT_ID).iterator();
        MongoCursor destCursor = destColl.find(filter).sort((Bson)SORT_ID).iterator();
        RawBsonDocument sourceDoc = null;
        RawBsonDocument destDoc = null;
        byte[] sourceBytes = null;
        byte[] destBytes = null;
        HashSet<BsonValue> sourceIds = new HashSet<BsonValue>();
        HashSet<BsonValue> destIds = new HashSet<BsonValue>();
        long lastReport = System.currentTimeMillis();
        while (sourceCursor.hasNext()) {
            sourceDoc = (RawBsonDocument)sourceCursor.next();
            BsonValue sourceId = sourceDoc.get((Object)"_id");
            sourceIds.add(sourceId);
            if (!destCursor.hasNext()) {
                logger.error(String.format("%s - destCursor exhausted, doc %s missing", ns, sourceId));
                result.incrementMissing();
                continue;
            }
            destDoc = (RawBsonDocument)destCursor.next();
            BsonValue destId = destDoc.get((Object)"_id");
            destIds.add(destId);
            sourceBytes = sourceDoc.getByteBuffer().array();
            destBytes = destDoc.getByteBuffer().array();
            if (sourceBytes.length == destBytes.length) {
                if (!DiffUtils.compareHashes(sourceBytes, destBytes)) {
                    BsonValue id = sourceDoc.get((Object)"_id");
                    if (sourceDoc.equals((Object)destDoc)) {
                        logger.error(String.format("%s - docs equal, but hash mismatch, id: %s", ns, id));
                        result.incrementKeysMisordered();
                    } else {
                        logger.error(String.format("%s - doc hash mismatch, id: %s", ns, id));
                        result.incrementHashMismatched();
                    }
                } else {
                    result.incrementMatches();
                }
            } else {
                logger.debug("Doc sizes not equal, id: " + sourceId);
                boolean xx = DiffUtils.compareDocuments(ns.getNamespace(), sourceDoc, destDoc);
                result.incrementHashMismatched();
            }
            result.incrementTotal();
        }
        Sets.SetView diff = null;
        logger.debug(String.format("buffer size: %s, sourceIds: %s", buffer.size(), sourceIds.size()));
        diff = Sets.difference(sourceIds, destIds);
        if (!diff.isEmpty()) {
            logger.debug("xx    - keys do not match: keys missing from source" + diff);
        }
        if (!(diff = Sets.difference(destIds, sourceIds)).isEmpty()) {
            logger.debug("yy    - keys do not match: keys missing from dest" + diff);
        }
        return result;
    }

    @Override
    public OplogTailingDiffTaskResult call() throws Exception {
        long start;
        OplogTailingDiffTaskResult result;
        block7: {
            ShardTimestamp shardTimestamp = this.sourceClient.populateLatestOplogTimestamp(this.sourceShardId, null);
            result = new OplogTailingDiffTaskResult(this.sourceShardId);
            MongoDatabase local = this.sourceClient.getShardMongoClient(this.sourceShardId).getDatabase("local");
            MongoCollection oplog = local.getCollection("oplog.rs", RawBsonDocument.class);
            MongoCursor cursor = null;
            Bson query = Filters.ne((String)"op", (Object)"n");
            start = System.currentTimeMillis();
            long totalCount = 0L;
            long buffersCount = 0L;
            long taskCount = 0L;
            try {
                try {
                    cursor = oplog.find(query).iterator();
                    while (cursor.hasNext()) {
                        RawBsonDocument doc = (RawBsonDocument)cursor.next();
                        ++totalCount;
                        OplogSummary oplogSummary = OplogUtil.getOplogSummaryFromOplogEntry(doc);
                        if (oplogSummary.getId() == null) continue;
                        Set<Object> buffer = this.getBuffer(oplogSummary.getNs());
                        buffer.add(oplogSummary.getId());
                        if (++buffersCount < 1000L) continue;
                        DiffResult diffResult = this.diff(buffer, this.sourceShardId, oplogSummary.getNs(), this.sourceMongoClient, this.destMongoClient);
                        result.addDiffResult(diffResult);
                        ++taskCount;
                        buffersCount = 0L;
                        buffer = new HashSet<Object>(1000);
                    }
                    for (Map.Entry<Namespace, Set<Object>> entry : this.namespaceBuffers.entrySet()) {
                        Namespace ns = entry.getKey();
                        Set<Object> buffer = entry.getValue();
                        DiffResult diffResult = this.diff(buffer, this.sourceShardId, ns, this.sourceMongoClient, this.destMongoClient);
                        result.addDiffResult(diffResult);
                        ++taskCount;
                    }
                }
                catch (MongoException me) {
                    logger.error("oops!", (Throwable)me);
                    cursor.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            cursor.close();
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        return result;
    }

    private Set<Object> getBuffer(Namespace ns) {
        Set<Object> buffer = this.namespaceBuffers.get(ns);
        if (buffer == null) {
            buffer = new HashSet<Object>();
            this.namespaceBuffers.put(ns, buffer);
        }
        return buffer;
    }
}

