/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.diffutil.DiffOptions;
import com.mongodb.diffutil.OplogTailingDiffTask;
import com.mongodb.diffutil.OplogTailingDiffTaskResult;
import com.mongodb.model.Shard;
import com.mongodb.shardsync.ShardClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogTailingDiffUtil {
    protected static final Logger logger = LoggerFactory.getLogger(OplogTailingDiffUtil.class);
    private static CommandLine line;
    private static Options options;
    private static final String SOURCE_URI = "source";
    private static final String DEST_URI = "dest";
    private DiffOptions diffOptions;
    private ShardClient sourceShardClient;
    private ShardClient destShardClient;
    private Map<String, String> sourceToDestShardMap = new HashMap<String, String>();
    private ExecutorService executor;

    private void initialize(DiffOptions options) {
        this.diffOptions = options;
        this.initializeShardMappings();
        this.sourceShardClient.populateShardMongoClients();
        this.destShardClient.populateShardMongoClients();
    }

    public void initializeShardMappings() {
        logger.debug("Start initializeShardMappings()");
        if (this.diffOptions.getShardMap() != null) {
            logger.debug("Custom shard mapping");
            String[] stringArray = this.diffOptions.getShardMap();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                String[] mappings = mapping.split("\\|");
                logger.debug(String.valueOf(mappings[0]) + " ==> " + mappings[1]);
                this.sourceToDestShardMap.put(mappings[0], mappings[1]);
                ++n2;
            }
            this.sourceShardClient = new ShardClient(SOURCE_URI, this.diffOptions.getSourceMongoUri(), this.sourceToDestShardMap.keySet());
            this.destShardClient = new ShardClient(DEST_URI, this.diffOptions.getDestMongoUri(), this.sourceToDestShardMap.values());
            this.sourceShardClient.init();
            this.destShardClient.init();
        } else {
            logger.debug("Default 1:1 shard mapping");
            this.sourceShardClient = new ShardClient(SOURCE_URI, this.diffOptions.getSourceMongoUri());
            this.destShardClient = new ShardClient(DEST_URI, this.diffOptions.getDestMongoUri());
            this.sourceShardClient.init();
            this.destShardClient.init();
            logger.debug("Source shard count: " + this.sourceShardClient.getShardsMap().size());
            int index = 0;
            ArrayList<Shard> destList = new ArrayList<Shard>(this.destShardClient.getShardsMap().values());
            for (Shard sourceShard : this.sourceShardClient.getShardsMap().values()) {
                Shard destShard = (Shard)destList.get(index);
                if (destShard != null) {
                    logger.debug(String.valueOf(sourceShard.getId()) + " ==> " + destShard.getId());
                    this.sourceToDestShardMap.put(sourceShard.getId(), destShard.getId());
                }
                ++index;
            }
        }
    }

    private void diff() throws InterruptedException, ExecutionException {
        ArrayList tasks = new ArrayList();
        ArrayList<Future<OplogTailingDiffTaskResult>> futures = new ArrayList<Future<OplogTailingDiffTaskResult>>();
        this.executor = Executors.newFixedThreadPool(this.sourceShardClient.getShardsMap().size());
        for (String string : this.sourceShardClient.getShardsMap().keySet()) {
            String destShardId = this.sourceToDestShardMap.get(string);
            OplogTailingDiffTask task = new OplogTailingDiffTask(string, destShardId, this.sourceShardClient, this.destShardClient, this.diffOptions.getThreads(), this.diffOptions.getQueueSize());
            futures.add(this.executor.submit(task));
        }
        this.executor.shutdown();
        for (Future future : futures) {
            OplogTailingDiffTaskResult result = (OplogTailingDiffTaskResult)future.get();
            logger.debug("*** " + result.toString());
        }
        logger.debug("Diff complete");
    }

    private void execute() {
        try {
            this.diff();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error collecting latest oplog timestamps", (Throwable)e);
            return;
        }
    }

    private static void printHelpAndExit() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("OplogTailingDiffUtil", options);
        System.exit(-1);
    }

    private static Properties readProperties() {
        Properties prop = new Properties();
        File propsFile = null;
        if (line.hasOption("c")) {
            propsFile = new File(line.getOptionValue("c"));
        } else {
            propsFile = new File("diff-util.properties");
            if (!propsFile.exists()) {
                logger.warn("Default config file diff-util.properties not found, using command line options only");
                return prop;
            }
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream input = new FileInputStream(propsFile);){
                prop.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            logger.error("Error loading properties file: " + propsFile, (Throwable)ioe);
        }
        return prop;
    }

    protected static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"source cluster mongo uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)SOURCE_URI);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"destination cluster mongo uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"destination");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"Configuration properties file");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"c"));
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                OplogTailingDiffUtil.printHelpAndExit();
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            OplogTailingDiffUtil.printHelpAndExit();
        }
        catch (Exception e) {
            e.printStackTrace();
            OplogTailingDiffUtil.printHelpAndExit();
        }
        return line;
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = OplogTailingDiffUtil.initializeAndParseCommandLineOptions(args);
        Properties configFileProps = OplogTailingDiffUtil.readProperties();
        String sourceUri = line.getOptionValue("s", configFileProps.getProperty(SOURCE_URI));
        String destUri = line.getOptionValue("d", configFileProps.getProperty(DEST_URI));
        if (sourceUri == null || destUri == null) {
            System.out.println("source and dest options required");
            OplogTailingDiffUtil.printHelpAndExit();
        }
        OplogTailingDiffUtil sync = new OplogTailingDiffUtil();
        DiffOptions options = new DiffOptions();
        options.setSourceMongoUri(sourceUri);
        options.setDestMongoUri(destUri);
        sync.initialize(options);
        sync.execute();
    }
}

