/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.diffutil.ShardedDupeIdFinderWorker;
import com.mongodb.shardsync.ShardClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedDupeIdFinder {
    private static Logger logger = LoggerFactory.getLogger(ShardedDupeIdFinder.class);
    private static Options options;
    private static CommandLine line;
    private String sourceClusterUri;
    private ShardClient sourceShardClient;
    private Map<String, Document> sourceDbInfoMap = new TreeMap<String, Document>();
    long totalDbs = 0L;
    long missingDbs = 0L;
    long totalCollections = 0L;
    long totalMatches = 0L;
    long totalMissingDocs = 0L;
    long totalKeysMisordered = 0L;
    long totalHashMismatched = 0L;
    private Set<BsonValue> ids;
    private Set<String> databasesBlacklist = new HashSet<String>(Arrays.asList("system", "local", "config", "admin"));
    private Set<String> collectionsBlacklist = new HashSet<String>(Arrays.asList("system.indexes", "system.profile"));
    private ExecutorService executor;

    public ShardedDupeIdFinder(String sourceClusterUri) {
        this.sourceClusterUri = sourceClusterUri;
        this.sourceShardClient = new ShardClient("source", sourceClusterUri);
        this.sourceShardClient.init();
        this.sourceShardClient.populateShardMongoClients();
        Document listDatabases = new Document("listDatabases", (Object)1);
        Document sourceDatabases = this.sourceShardClient.adminCommand(listDatabases);
        List sourceDatabaseInfo = (List)sourceDatabases.get((Object)"databases");
        this.populateDbMap(sourceDatabaseInfo, this.sourceDbInfoMap);
    }

    private void populateDbMap(List<Document> dbInfoList, Map<String, Document> databaseMap) {
        for (Document dbInfo : dbInfoList) {
            databaseMap.put(dbInfo.getString((Object)"name"), dbInfo);
        }
    }

    private Document agg(String dbName, String collectionName) {
        MongoClient mongosClient = this.sourceShardClient.getMongoClient();
        MongoDatabase db = mongosClient.getDatabase(dbName);
        MongoCollection coll = db.getCollection(collectionName);
        Document d = Document.parse((String)"{'$group': {'_id': null, 'max': { '$max': '$_id' }, 'min': { '$min': '$_id' }}}");
        ArrayList<Document> pipeline = new ArrayList<Document>();
        pipeline.add(d);
        Document aggResult = (Document)coll.aggregate(pipeline).first();
        return aggResult;
    }

    public void run() throws InterruptedException {
        this.executor = Executors.newFixedThreadPool(this.sourceShardClient.getShardMongoClients().size());
        for (String dbName : this.sourceDbInfoMap.keySet()) {
            if (this.databasesBlacklist.contains(dbName)) continue;
            MongoDatabase db = this.sourceShardClient.getMongoClient().getDatabase(dbName);
            logger.debug("db " + dbName);
            MongoIterable collectionNames = db.listCollectionNames();
            for (String collectionName : collectionNames) {
                if (this.collectionsBlacklist.contains(collectionName)) continue;
                Document agg = this.agg(dbName, collectionName);
                logger.debug("agg: " + agg);
                ObjectId min = agg.getObjectId((Object)"min");
                Date minDate = min.getDate();
                ObjectId max = agg.getObjectId((Object)"max");
                Date maxDate = max.getDate();
                Calendar myCal = Calendar.getInstance();
                myCal.setTime(minDate);
                while (myCal.getTime().before(maxDate)) {
                    Date d1 = myCal.getTime();
                    myCal.add(2, 1);
                    Date d2 = myCal.getTime();
                    logger.debug(d1 + " - " + d2);
                    ShardedDupeIdFinderWorker worker = new ShardedDupeIdFinderWorker(this.sourceShardClient, dbName, collectionName, d1, d2);
                    this.executor.execute(worker);
                }
            }
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            Thread.sleep(10000L);
        }
        logger.debug("ShardedDupeIdFinder complete");
    }

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"Source cluster connection uri");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"source");
        options.addOption(OptionBuilder.create((String)"s"));
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                ShardedDupeIdFinder.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            ShardedDupeIdFinder.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            ShardedDupeIdFinder.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("logParser", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = ShardedDupeIdFinder.initializeAndParseCommandLineOptions(args);
        ShardedDupeIdFinder finder = new ShardedDupeIdFinder(line.getOptionValue("s"));
        finder.run();
    }
}

