/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.shardsync.ShardClient;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedDupeIdFinderWorker
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(ShardedDupeIdFinderWorker.class);
    private String sourceColl;
    private String dbName;
    Set<BsonValue> idsSet;
    Document sort = new Document("_id", (Object)1);
    private String shardName;
    private Date startDate;
    private Date endDate;
    private ShardClient sourceShardClient;

    public ShardedDupeIdFinderWorker(ShardClient sourceShardClient, String dbName, String sourceColl, Date startDate, Date endDate) {
        this.sourceShardClient = sourceShardClient;
        this.dbName = dbName;
        this.sourceColl = sourceColl;
        this.startDate = startDate;
        this.endDate = endDate;
        this.idsSet = new HashSet<BsonValue>();
    }

    private static int dateToTimestampSeconds(Date time) {
        return (int)(time.getTime() / 1000L);
    }

    private ObjectId getObjectId(Date d) {
        int ts = ShardedDupeIdFinderWorker.dateToTimestampSeconds(d);
        String hex = Integer.toHexString(ts);
        ObjectId id2 = new ObjectId(String.valueOf(hex) + "0000000000000000");
        return id2;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        long count = 0L;
        ObjectId startObj = this.getObjectId(this.startDate);
        ObjectId endObj = this.getObjectId(this.endDate);
        Bson query = Filters.and((Bson[])new Bson[]{Filters.gte((String)"_id", (Object)startObj), Filters.lte((String)"_id", (Object)endObj)});
        for (Map.Entry<String, MongoClient> entry : this.sourceShardClient.getShardMongoClients().entrySet()) {
            MongoClient sourceClient = entry.getValue();
            String shardName = entry.getKey();
            MongoDatabase db = sourceClient.getDatabase(this.dbName);
            MongoCollection collection = db.getCollection(this.sourceColl, RawBsonDocument.class);
            try (MongoCursor sourceCursor = null;){
                sourceCursor = collection.find(query).projection((Bson)this.sort).iterator();
                while (sourceCursor.hasNext()) {
                    ++count;
                    RawBsonDocument doc = (RawBsonDocument)sourceCursor.next();
                    BsonValue id = null;
                    try {
                        id = doc.get((Object)"_id");
                    }
                    catch (Exception e) {
                        logger.debug(String.format("%s: %s - Error reading doc id, count: %s, error: %s", shardName, collection.getNamespace(), count, e));
                        continue;
                    }
                    boolean newEntry = this.idsSet.add(id);
                    if (!newEntry) {
                        logger.warn(String.format("%s: dupe key for %s", shardName, id));
                    }
                    if (count % 1000000L != 0L) continue;
                    logger.debug(String.format("%s: read %s", shardName, count));
                }
            }
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        logger.debug(String.format("Done validating %s, %s documents in %f seconds (%s - %s)", this.sourceColl, count, dur, this.startDate, this.endDate));
    }
}

