/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.model;

import com.mongodb.model.Namespace;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

public class IndexSpec {
    private RawBsonDocument sourceSpec;
    private RawBsonDocument key;
    private String keyJsonString;
    private String name;
    private Namespace namespace;
    private boolean sparse;
    private boolean background;
    private boolean unique;
    private Number expireAfterSeconds;

    private IndexSpec(RawBsonDocument sourceSpec) {
        this.sourceSpec = sourceSpec;
        this.key = (RawBsonDocument)sourceSpec.get((Object)"key");
        this.keyJsonString = this.key.toJson();
        this.name = sourceSpec.getString((Object)"name").getValue();
        this.namespace = new Namespace(sourceSpec.getString((Object)"ns").getValue());
        if (sourceSpec.containsKey((Object)"expireAfterSeconds")) {
            this.expireAfterSeconds = sourceSpec.getNumber((Object)"expireAfterSeconds").doubleValue();
        }
        this.sparse = IndexSpec.getBoolean(sourceSpec, "sparse");
        this.background = IndexSpec.getBoolean(sourceSpec, "background");
        this.unique = IndexSpec.getBoolean(sourceSpec, "unique");
    }

    private static boolean getBoolean(RawBsonDocument sourceSpec, String key) {
        BsonValue value = sourceSpec.get((Object)key);
        if (value != null) {
            BsonType type = value.getBsonType();
            switch (type) {
                case BOOLEAN: {
                    return sourceSpec.getBoolean((Object)key).getValue();
                }
                case DOUBLE: {
                    double d = sourceSpec.getDouble((Object)key).getValue();
                    return d != 0.0;
                }
                case INT32: {
                    int i = sourceSpec.getInt32((Object)key).getValue();
                    return i != 0;
                }
                case INT64: {
                    long l = sourceSpec.getInt64((Object)key).getValue();
                    return l != 0L;
                }
            }
            return false;
        }
        return false;
    }

    public static IndexSpec fromDocument(RawBsonDocument sourceSpec) {
        IndexSpec spec = new IndexSpec(sourceSpec);
        return spec;
    }

    public int hashCode() {
        return this.keyJsonString.hashCode();
    }

    public String toString() {
        return this.sourceSpec.toJson();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexSpec other = (IndexSpec)obj;
        return other.keyJsonString.equals(this.keyJsonString);
    }

    public RawBsonDocument getSourceSpec() {
        return this.sourceSpec;
    }
}

