/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Namespace
implements Comparable<Namespace> {
    private String databaseName;
    private String collectionName;
    private static final Pattern namespacePattern = Pattern.compile("^(.*?)\\.(.*)$");

    public Namespace(String ns) {
        Matcher m = namespacePattern.matcher(ns);
        if (m.find()) {
            this.databaseName = m.group(1);
            this.collectionName = m.group(2);
        }
    }

    public Namespace(String dbName, String collectionName) {
        this.databaseName = dbName;
        this.collectionName = collectionName;
    }

    public boolean hasDatabase(String dbName) {
        return this.databaseName != null && this.databaseName.equals(dbName);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getNamespace() {
        return String.valueOf(this.databaseName) + "." + this.collectionName;
    }

    public String toString() {
        return String.valueOf(this.databaseName) + "." + this.collectionName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collectionName == null ? 0 : this.collectionName.hashCode());
        result = 31 * result + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Namespace other = (Namespace)obj;
        if (this.collectionName == null ? other.collectionName != null : !this.collectionName.equals(other.collectionName)) {
            return false;
        }
        return !(this.databaseName == null ? other.databaseName != null : !this.databaseName.equals(other.databaseName));
    }

    @Override
    public int compareTo(Namespace o) {
        return this.getNamespace().compareTo(o.getNamespace());
    }
}

