/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.model;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum OplogOpType {
    INSERT("insert", "i"),
    UPDATE("update", "u"),
    DELETE("delete", "d"),
    NO_OP("no-op", "n"),
    CREATE("create", "c");

    private String label;
    private String code;
    private static final Map<String, OplogOpType> codeLookup;

    static {
        codeLookup = Maps.uniqueIndex(Arrays.asList(OplogOpType.values()), OplogOpType::getCode);
    }

    private OplogOpType(String label, String code) {
        this.label = label;
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCode() {
        return this.code;
    }

    public static OplogOpType fromCode(String code) {
        return codeLookup.get(code);
    }
}

