/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.model;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.bson.BsonTimestamp;

public class ShardTimestamp {
    private String shardName;
    private BsonTimestamp timestamp;
    private ZonedDateTime date;

    public ShardTimestamp(String shardName, BsonTimestamp timestamp) {
        this.shardName = shardName;
        this.timestamp = timestamp;
        this.date = ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp.getTime()), ZoneOffset.UTC);
    }

    public String getShardName() {
        return this.shardName;
    }

    public BsonTimestamp getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ShardTimestamp [shardName=");
        builder.append(this.shardName);
        builder.append(", timestamp=");
        builder.append(this.timestamp);
        builder.append(", date=");
        builder.append(this.date);
        builder.append("]");
        return builder.toString();
    }
}

