/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongodump;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

public class MongoDump {
    private MongoClient mongoClient;

    public MongoDump(String mongoUri) {
        ConnectionString connectionString = new ConnectionString(mongoUri);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
        mongoClient.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
    }

    private void dump(String databaseName, String collectionName) throws IOException {
        File outputFile = new File(String.valueOf(databaseName) + "." + collectionName + ".bson");
        FileOutputStream fos = null;
        MongoCursor cursor = null;
        long start = System.currentTimeMillis();
        long count = 0L;
        try {
            fos = new FileOutputStream(outputFile);
            FileChannel channel = fos.getChannel();
            MongoDatabase db = this.mongoClient.getDatabase(databaseName);
            MongoCollection mongoCollection = db.getCollection(collectionName, RawBsonDocument.class);
            long totalDocs = mongoCollection.countDocuments();
            for (RawBsonDocument doc : mongoCollection.find()) {
                ByteBuffer buffer = doc.getByteBuffer().asNIO();
                channel.write(buffer);
                if (++count % 100000L != 0L) continue;
                double complete = (double)(count / totalDocs) * 100.0;
                System.out.println(String.format("%s / %s  (%f)", count, totalDocs, (double)(count / totalDocs) * 100.0));
            }
        }
        finally {
            cursor.close();
            fos.close();
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        System.out.println(String.format("\nDone dumping %s.%s, %s documents in %f seconds", databaseName, collectionName, count, dur));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            throw new IllegalArgumentException("Expected <database> <collection> <mongoUri> arguments");
        }
        String databaseName = args[0];
        String collectionName = args[1];
        String mongoUri = args[2];
        MongoDump mongoDump = new MongoDump(mongoUri);
        mongoDump.dump(databaseName, collectionName);
    }
}

