/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongomirror;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mongodb.model.Namespace;
import com.mongodb.mongomirror.model.InitialSyncDetails;
import com.mongodb.mongomirror.model.MongoMirrorStatus;
import com.mongodb.mongomirror.model.MongoMirrorStatusInitialSync;
import com.mongodb.mongomirror.model.MongoMirrorStatusOplogSync;
import com.mongodb.util.HttpUtils;
import com.mongodb.util.MaskUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoMirrorRunner {
    public static final String[] PASSWORD_KEYS = new String[]{"--password", "--destinationPassword"};
    private File mongomirrorBinary;
    private CommandLine cmdLine;
    private ExecuteResultHandler executeResultHandler;
    private String sourceHost;
    private String sourceUsername;
    private String sourcePassword;
    private String sourceAuthenticationDatabase;
    private String sourceAuthenticationMechanism;
    private Boolean sourceSsl;
    private String destinationHost;
    private String destinationUsername;
    private String destinationPassword;
    private String destinationAuthenticationDatabase;
    private String destinationAuthenticationMechanism;
    private String readPreference;
    private Boolean drop;
    private Boolean preserveUUIDs;
    private String bookmarkFile;
    private String compressors;
    private Integer httpStatusPort;
    private String oplogPath;
    private Integer collStatsThreshold;
    private String numParallelCollections;
    private String writeConcern;
    private Boolean destinationNoSSL;
    private Boolean skipBuildIndexes;
    private Set<Namespace> includeNamespaces = new HashSet<Namespace>();
    private Set<String> includeDatabases = new HashSet<String>();
    private String id;
    private Logger logger;
    private HttpUtils httpUtils;

    public MongoMirrorRunner(String id) {
        this.id = id;
        this.logger = LoggerFactory.getLogger((String)(String.valueOf(this.getClass().getName()) + "." + id));
        this.httpUtils = new HttpUtils();
    }

    public void execute(boolean dryRun) throws ExecuteException, IOException {
        this.logger.debug("execute() start id: " + this.id);
        this.executeResultHandler = new DefaultExecuteResultHandler();
        this.cmdLine = new CommandLine(this.mongomirrorBinary);
        this.addArg("host", this.sourceHost);
        this.addArg("username", this.sourceUsername);
        this.addArg("password", this.sourcePassword);
        this.addArg("authenticationDatabase", this.sourceAuthenticationDatabase);
        this.addArg("authenticationMechanism", this.sourceAuthenticationMechanism);
        this.addArg("ssl", this.sourceSsl);
        this.addArg("destination", this.destinationHost);
        this.addArg("destinationUsername", this.destinationUsername);
        this.addArg("destinationPassword", this.destinationPassword);
        this.addArg("destinationAuthenticationDatabase", this.destinationAuthenticationDatabase);
        this.addArg("destinationAuthenticationMechanism", this.destinationAuthenticationMechanism);
        this.addArg("readPreference", this.readPreference);
        this.addArg("destinationNoSSL", this.destinationNoSSL);
        this.addArg("preserveUUIDs", this.preserveUUIDs);
        this.addArg("drop", this.drop);
        this.addArg("bookmarkFile", this.bookmarkFile);
        this.addArg("numParallelCollections", this.numParallelCollections);
        this.addArg("compressors", this.compressors);
        this.addArg("writeConcern", this.writeConcern);
        this.addArg("httpStatusPort", this.httpStatusPort);
        this.addArg("oplogPath", this.oplogPath);
        this.addArg("skipBuildIndexes", this.skipBuildIndexes);
        this.addArg("collStatsThreshold", this.collStatsThreshold);
        for (Namespace ns : this.includeNamespaces) {
            this.addArg("includeNamespace", ns.getNamespace());
        }
        for (String dbName : this.includeDatabases) {
            this.addArg("includeDB", dbName);
        }
        if (dryRun) {
            this.logger.debug("dry run: " + this.id + " cmdLine: " + this.cmdLine);
            return;
        }
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)((Object)new ExecBasicLogHandler(this.id)));
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(1);
        executor.setStreamHandler((ExecuteStreamHandler)psh);
        this.logger.debug("mongomirror execute id: " + this.id + " cmdLine: " + MaskUtil.maskCommandLine(this.cmdLine, PASSWORD_KEYS));
        executor.execute(this.cmdLine, this.executeResultHandler);
    }

    public MongoMirrorStatus checkStatus() {
        String statusStr = null;
        try {
            statusStr = this.httpUtils.doGetAsString(String.format("http://localhost:%s", this.httpStatusPort));
            return this.parseStatus(statusStr);
        }
        catch (IOException e) {
            this.logger.error(statusStr);
            this.logger.error("Error checking mongomirror status: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.error(statusStr);
            this.logger.error("Error checking mongomirror status", (Throwable)e);
        }
        return null;
    }

    public MongoMirrorStatus parseStatus(String statusStr) {
        Gson gson = new GsonBuilder().create();
        JsonObject statusJson = new JsonParser().parse(statusStr).getAsJsonObject();
        String stage = null;
        String phase = null;
        String errorMessage = null;
        if (statusJson.has("stage")) {
            stage = statusJson.get("stage").getAsString();
        }
        if (statusJson.has("phase")) {
            phase = statusJson.get("phase").getAsString();
        }
        if (statusJson.has("errorMessage")) {
            errorMessage = statusJson.get("errorMessage").getAsString();
        }
        if ("initial sync".equals(stage)) {
            MongoMirrorStatusInitialSync status = new MongoMirrorStatusInitialSync(stage, phase, errorMessage);
            if (statusJson.has("details")) {
                JsonObject statusDetails = statusJson.get("details").getAsJsonObject();
                if (statusDetails.has("copiedBytesAllColl")) {
                    InitialSyncDetails details = new InitialSyncDetails();
                    status.setTopLevelDetails(details);
                    details.setCopiedBytes(statusDetails.get("copiedBytesAllColl").getAsLong());
                    details.setTotalBytes(statusDetails.get("totalBytesAllColl").getAsLong());
                } else {
                    status = (MongoMirrorStatusInitialSync)gson.fromJson((JsonElement)statusJson, MongoMirrorStatusInitialSync.class);
                }
            } else {
                this.logger.warn("InitialSyncDetails was missing from http status output");
            }
            return status;
        }
        if ("applying oplog entries".equals(phase) || "oplog sync".equals(phase)) {
            MongoMirrorStatusOplogSync status = (MongoMirrorStatusOplogSync)gson.fromJson((JsonElement)statusJson, MongoMirrorStatusOplogSync.class);
            return status;
        }
        MongoMirrorStatus status = new MongoMirrorStatus(stage, phase, errorMessage);
        return status;
    }

    private void addArg(String argName) {
        this.cmdLine.addArgument("--" + argName);
    }

    private void addArg(String argName, Integer argValue) {
        if (argValue != null) {
            this.cmdLine.addArgument("--" + argName + "=" + argValue);
        }
    }

    private void addArg(String argName, String argValue) {
        if (argValue != null) {
            this.cmdLine.addArgument("--" + argName + "=" + argValue);
        }
    }

    private void addArg(String argName, Boolean argValue) {
        if (argValue != null && argValue.booleanValue()) {
            this.cmdLine.addArgument("--" + argName);
        }
    }

    public void setMongomirrorBinary(File mongomirrorBinary) {
        this.mongomirrorBinary = mongomirrorBinary;
    }

    public File getMongomirrorBinary() {
        return this.mongomirrorBinary;
    }

    public void setExecuteResultHandler(ExecuteResultHandler executeResultHandler) {
        this.executeResultHandler = executeResultHandler;
    }

    public void setSourceHost(String sourceHost) {
        this.sourceHost = sourceHost;
    }

    public void setSourceUsername(String sourceUsername) {
        this.sourceUsername = sourceUsername;
    }

    public void setSourcePassword(String sourcePassword) {
        this.sourcePassword = sourcePassword;
    }

    public void setSourceAuthenticationDatabase(String sourceAuthenticationDatabase) {
        this.sourceAuthenticationDatabase = sourceAuthenticationDatabase;
    }

    public void setSourceAuthenticationMechanism(String sourceAuthenticationMechanism) {
        this.sourceAuthenticationMechanism = sourceAuthenticationMechanism;
    }

    public void setDestinationHost(String destinationHost) {
        this.destinationHost = destinationHost;
    }

    public void setDestinationUsername(String destinationUsername) {
        this.destinationUsername = destinationUsername;
    }

    public void setDestinationPassword(String destinationPassword) {
        this.destinationPassword = destinationPassword;
    }

    public void setDestinationAuthenticationDatabase(String destinationAuthenticationDatabase) {
        this.destinationAuthenticationDatabase = destinationAuthenticationDatabase;
    }

    public void setDestinationAuthenticationMechanism(String destinationAuthenticationMechanism) {
        this.destinationAuthenticationMechanism = destinationAuthenticationMechanism;
    }

    public void setReadPreference(String readPreference) {
        this.readPreference = readPreference;
    }

    public void setDrop(Boolean drop) {
        this.drop = drop;
    }

    public void setDestinationNoSSL(Boolean destinationNoSSL) {
        this.destinationNoSSL = destinationNoSSL;
    }

    public void setBookmarkFile(String bookmarkFile) {
        this.bookmarkFile = bookmarkFile;
    }

    public void setSourceSsl(Boolean sourceSsl) {
        this.sourceSsl = sourceSsl;
    }

    public void setNumParallelCollections(String numParallelCollections) {
        this.numParallelCollections = numParallelCollections;
    }

    public Boolean getPreserveUUIDs() {
        return this.preserveUUIDs;
    }

    public void setPreserveUUIDs(Boolean preserveUUIDs) {
        this.preserveUUIDs = preserveUUIDs;
    }

    public void addIncludeNamespace(Namespace ns) {
        this.includeNamespaces.add(ns);
    }

    public void addIncludeDatabase(String dbName) {
        this.includeDatabases.add(dbName);
    }

    public void setCompressors(String compressors) {
        this.compressors = compressors;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setHttpStatusPort(Integer httpStatusPort) {
        this.httpStatusPort = httpStatusPort;
    }

    public String getId() {
        return this.id;
    }

    public void setOplogPath(String oplogPath) {
        this.oplogPath = oplogPath;
    }

    public void setSkipBuildIndexes(Boolean skipBuildIndexes) {
        this.skipBuildIndexes = skipBuildIndexes;
    }

    public void setCollStatsThreshold(Integer collStatsThreshold) {
        this.collStatsThreshold = collStatsThreshold;
    }

    class ExecBasicLogHandler
    extends LogOutputStream {
        private PrintWriter writer;

        public ExecBasicLogHandler(String id) throws IOException {
            this.writer = new PrintWriter(new FileWriter(new File(String.valueOf(id) + ".log")));
        }

        protected void processLine(String line) {
            this.writer.println(line);
            this.writer.flush();
        }

        protected void processLine(String line, int logLevel) {
            this.writer.println(line);
            this.writer.flush();
        }
    }

    class ExecLogHandler
    extends LogOutputStream {
        private Logger log;

        public ExecLogHandler(Logger log) {
            this.log = log;
        }

        protected void processLine(String line) {
            this.log.debug(line);
        }

        protected void processLine(String line, int logLevel) {
            this.log.debug(line);
        }
    }
}

