/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongomirror.model;

import com.mongodb.mongomirror.model.InitialSyncDetails;
import com.mongodb.mongomirror.model.MongoMirrorStatus;
import java.util.Map;
import java.util.TreeMap;

public class MongoMirrorStatusInitialSync
extends MongoMirrorStatus {
    public static final String INITIAL_SYNC = "initial sync";
    public static final String PHASE_COPYING_INDEXES = "copying indexes";
    private InitialSyncDetails topLevelDetails;
    private Map<String, InitialSyncDetails> details = new TreeMap<String, InitialSyncDetails>();

    public MongoMirrorStatusInitialSync(String stage, String phase, String errorMessage) {
        super(stage, phase, errorMessage);
    }

    public Map<String, InitialSyncDetails> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, InitialSyncDetails> details) {
        this.details = details;
    }

    public long getCopiedBytes() {
        long total = 0L;
        for (InitialSyncDetails d : this.details.values()) {
            if (d == null || d.getCopiedBytes() == null) continue;
            total += d.getCopiedBytes().longValue();
        }
        return total;
    }

    public long getTotalBytes() {
        long total = 0L;
        for (InitialSyncDetails d : this.details.values()) {
            if (d == null || d.getTotalBytes() == null) continue;
            total += d.getTotalBytes().longValue();
        }
        return total;
    }

    public boolean isCopyingIndexes() {
        return this.phase.equals(PHASE_COPYING_INDEXES);
    }

    public double getCompletionPercent() {
        double totalBytes;
        double copiedBytes;
        if (this.topLevelDetails != null) {
            copiedBytes = this.topLevelDetails.getCopiedBytes().longValue();
            totalBytes = this.topLevelDetails.getTotalBytes().longValue();
        } else {
            totalBytes = this.getTotalBytes();
            copiedBytes = this.getCopiedBytes();
        }
        if (totalBytes > 0.0) {
            return copiedBytes / totalBytes * 100.0;
        }
        return 0.0;
    }

    public InitialSyncDetails getTopLevelDetails() {
        return this.topLevelDetails;
    }

    public void setTopLevelDetails(InitialSyncDetails topLevelDetails) {
        this.topLevelDetails = topLevelDetails;
    }
}

