/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.internal.MongoClientImpl;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.mongoreplay.Monitor;
import com.mongodb.mongoreplay.RawReplayTask;
import com.mongodb.mongoreplay.ReplayMode;
import com.mongodb.mongoreplay.ReplayOptions;
import com.mongodb.mongoreplay.Replayer;
import com.mongodb.mongoreplay.SplitModeReplayTask;
import com.mongodb.util.CallerBlocksPolicy;
import com.mongodb.util.PausableThreadPoolExecutor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoReplayUtil {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMongoReplayUtil.class);
    private static final String DB_NAME_MAP = "dbNameMap";
    private static final String READ_ONLY = "readOnly";
    private static final long unixToInternal = 62135596800L;
    private static final long internalToUnix = -62135596800L;
    private final BasicBSONEncoder encoder;
    protected String[] fileNames;
    protected boolean splitFilesMode = false;
    protected static String[] removeUpdateFields;
    private static Set<String> ignoredCollections;
    private int threads = 8;
    private int queueSize = 250000;
    private static final int ONE_MINUTE = 60000;
    private static Monitor monitor;
    protected PausableThreadPoolExecutor pool = null;
    private BlockingQueue<Runnable> workQueue;
    List<Future<?>> futures = new LinkedList();
    private String mongoUriStr;
    private static MongoClient mongoClient;
    ClusterType clusterType;
    private int limit = Integer.MAX_VALUE;
    int count = 0;
    int written = 0;
    int ignored = 0;
    int getMoreCount = 0;
    private BSONObject firstSeen;
    private BSONObject lastSeen;
    private Set<Integer> opcodeWhitelist = new HashSet<Integer>();
    private ReplayOptions replayOptions;
    private Replayer replayer;

    static {
        ignoredCollections = new HashSet<String>();
    }

    public AbstractMongoReplayUtil() {
        this.encoder = new BasicBSONEncoder();
        this.opcodeWhitelist.addAll(Arrays.asList(2004, 2010, 2013));
    }

    public void init() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int seedListSize;
        ReadConcern readConcern;
        logger.debug("mongoUriStr: " + this.mongoUriStr);
        ConnectionString connectionString = new ConnectionString(this.mongoUriStr);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
        this.replayOptions.setReadPreference(connectionString.getReadPreference());
        WriteConcern wc = connectionString.getWriteConcern();
        if (wc != null && wc.getWObject() != null) {
            this.replayOptions.setWriteConcern(wc.asDocument());
        }
        if ((readConcern = connectionString.getReadConcern()) != null && readConcern.getLevel() != null) {
            this.replayOptions.setReadConcernLevel(readConcern.getLevel());
        }
        if ((seedListSize = connectionString.getHosts().size()) == 1) {
            logger.warn("Only 1 host specified in seedlist");
        }
        mongoClient.getDatabase("admin").runCommand((Bson)new Document("ismaster", (Object)1));
        Method method = MongoClientImpl.class.getDeclaredMethod("getClusterDescription", new Class[0]);
        method.setAccessible(true);
        ClusterDescription cd = (ClusterDescription)method.invoke((Object)mongoClient, new Object[0]);
        this.clusterType = cd.getType();
        logger.debug("Connected: " + this.clusterType);
        this.workQueue = new LinkedBlockingQueue<Runnable>(this.queueSize);
        this.pool = new PausableThreadPoolExecutor(this.threads, this.threads, 30L, TimeUnit.SECONDS, this.workQueue, new CallerBlocksPolicy(300000L));
        this.pool.pause();
        monitor = new Monitor(Thread.currentThread());
        monitor.setPool(this.pool);
        monitor.start();
        this.replayer = new Replayer(monitor, mongoClient, this.replayOptions);
    }

    public void close() {
        this.pool.shutdown();
        while (!this.pool.isTerminated()) {
            Thread.yield();
            try {
                Thread.sleep(5000L);
                logger.debug("Waiting for executor");
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        try {
            this.pool.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            if (monitor != null && monitor.isAlive()) {
                logger.error("interrupted error", (Throwable)e);
            }
            logger.warn("interrupted while waiting for executor termination");
        }
        this.halt();
        mongoClient.close();
        logger.debug("close() complete");
    }

    private void halt() {
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
        while (monitor != null && monitor.isAlive()) {
            try {
                monitor.halt();
                monitor.join();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            logger.debug("resetting thread status");
            Thread.interrupted();
        }
    }

    public void replayFileSplitMode(String filename) throws FileNotFoundException, DataFormatException {
        File file = new File(filename);
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        SplitModeReplayTask rawTask = new SplitModeReplayTask(this.replayer, inputStream);
        this.futures.add(this.pool.submit(rawTask));
        ++this.count;
    }

    public void replayFile(String filename) throws FileNotFoundException, DataFormatException {
        block15: {
            File file = new File(filename);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            BasicBSONDecoder decoder = new BasicBSONDecoder();
            try {
                try {
                    while (((InputStream)inputStream).available() > 0) {
                        BSONObject obj;
                        if (this.count < this.limit && (obj = decoder.readObject((InputStream)inputStream)) != null) {
                            BSONObject raw = (BSONObject)obj.get("rawop");
                            if (raw == null) continue;
                            BSONObject header = (BSONObject)raw.get("header");
                            int opcode = (Integer)header.get("opcode");
                            if (!this.opcodeWhitelist.contains(opcode)) {
                                ++this.ignored;
                                continue;
                            }
                            Long seenconnectionnum = (Long)obj.get("seenconnectionnum");
                            this.lastSeen = (BSONObject)obj.get("seen");
                            if (this.count == 0) {
                                this.firstSeen = this.lastSeen;
                            }
                            RawReplayTask rawTask = new RawReplayTask(this.replayer, raw);
                            this.futures.add(this.pool.submit(rawTask));
                            ++this.count;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.debug(String.format("%s objects read, %s filtered objects written, %s ignored", this.count, this.written, this.ignored));
        logger.debug(String.format("%s getMore", this.getMoreCount));
        logger.debug(String.format("first event: %s", AbstractMongoReplayUtil.convertSeen(this.firstSeen)));
        logger.debug(String.format("last event: %s", AbstractMongoReplayUtil.convertSeen(this.lastSeen)));
    }

    protected static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        Options options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"input mongoreplay bson file(s)");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"files");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"input files (split)");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"splitFiles");
        options.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withArgName((String)"remove update fields");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"removeUpdateFields");
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)"limit # operations");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"limit");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withArgName((String)"play back target mongo uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"host");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withArgName((String)"# threads");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"threads");
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withArgName((String)"sleep millis");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"sleep");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"queue size");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"queue");
        options.addOption(OptionBuilder.create((String)"q"));
        OptionBuilder.withArgName((String)"ignore collection");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"ingoreColl");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"db name map");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)DB_NAME_MAP);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"read only mode");
        OptionBuilder.withLongOpt((String)READ_ONLY);
        options.addOption(OptionBuilder.create());
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                AbstractMongoReplayUtil.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            AbstractMongoReplayUtil.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractMongoReplayUtil.printHelpAndExit(options);
        }
        return line;
    }

    protected void parseArgs(String[] args) {
        String qStr;
        String threadsStr;
        CommandLine line = AbstractMongoReplayUtil.initializeAndParseCommandLineOptions(args);
        this.replayOptions = new ReplayOptions();
        this.replayOptions.addIgnoredCollections(ignoredCollections);
        if (line.hasOption('F')) {
            this.splitFilesMode = true;
            String[] vals = line.getOptionValues("F");
            this.fileNames = line.getOptionValues("F");
        } else {
            this.fileNames = line.getOptionValues("f");
        }
        String[] x = line.getOptionValues("u");
        this.replayOptions.setRemoveUpdateFields(x);
        String limitStr = line.getOptionValue("l");
        String mongoUriStr = line.getOptionValue("h");
        this.setMongoUriStr(mongoUriStr);
        String sleepStr = line.getOptionValue("s");
        if (sleepStr != null) {
            Long sleep = Long.parseLong(sleepStr);
            this.replayOptions.setSleepMillis(sleep);
        }
        if ((threadsStr = line.getOptionValue("t")) != null) {
            int threads = Integer.parseInt(threadsStr);
            this.setThreads(threads);
        }
        if (limitStr != null) {
            int limit = Integer.parseInt(limitStr);
            this.setLimit(limit);
        }
        if (line.hasOption("c")) {
            ignoredCollections.addAll(Arrays.asList(line.getOptionValues("c")));
        }
        if ((qStr = line.getOptionValue("q")) != null) {
            int q = Integer.parseInt(qStr);
            this.setQueueSize(q);
        }
        if (line.hasOption(DB_NAME_MAP)) {
            this.replayOptions.setDbNameMapString(line.getOptionValue(DB_NAME_MAP));
        }
        if (line.hasOption(READ_ONLY)) {
            this.replayOptions.setReplayMode(ReplayMode.READ_ONLY);
        } else {
            this.replayOptions.setReplayMode(ReplayMode.READ_WRITE);
        }
    }

    private void setQueueSize(int q) {
        this.queueSize = q;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("replayUtil", options);
        System.exit(-1);
    }

    protected void setThreads(int threads) {
        this.threads = threads;
    }

    public String[] getRemoveUpdateFields() {
        return removeUpdateFields;
    }

    public void setRemoveUpdateFields(String[] removeUpdateFields) {
        AbstractMongoReplayUtil.removeUpdateFields = removeUpdateFields;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setMongoUriStr(String mongoUriStr) {
        this.mongoUriStr = mongoUriStr;
    }

    private static ZonedDateTime convertSeen(BSONObject seen) {
        Long sec = (Long)seen.get("sec");
        Long t = (sec + -62135596800L) * 1000L;
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.of("UTC"));
    }

    public boolean isSplitFilesMode() {
        return this.splitFilesMode;
    }
}

