/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import org.bson.AbstractBsonWriter;
import org.bson.BSONCallback;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriterSettings;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class BSONCallbackAdapter
extends AbstractBsonWriter {
    private BSONCallback bsonCallback;

    protected BSONCallbackAdapter(BsonWriterSettings settings, BSONCallback bsonCallback) {
        super(settings);
        this.bsonCallback = bsonCallback;
    }

    public void flush() {
    }

    public void doWriteStartDocument() {
        BsonContextType contextType;
        BsonContextType bsonContextType = contextType = this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
        if (this.getContext() == null || contextType == BsonContextType.SCOPE_DOCUMENT) {
            this.bsonCallback.objectStart();
        } else {
            this.bsonCallback.objectStart(this.getName());
        }
        this.setContext(new Context(this.getContext(), contextType));
    }

    protected void doWriteEndDocument() {
        BsonContextType contextType = this.getContext().getContextType();
        this.setContext(this.getContext().getParentContext());
        this.bsonCallback.objectDone();
        if (contextType == BsonContextType.SCOPE_DOCUMENT) {
            Object scope = this.bsonCallback.get();
            this.bsonCallback = this.getContext().callback;
            this.bsonCallback.gotCodeWScope(this.getContext().name, this.getContext().code, scope);
        }
    }

    public void doWriteStartArray() {
        this.bsonCallback.arrayStart(this.getName());
        this.setContext(new Context(this.getContext(), BsonContextType.ARRAY));
    }

    protected void doWriteEndArray() {
        this.setContext(this.getContext().getParentContext());
        this.bsonCallback.arrayDone();
    }

    protected void doWriteBinaryData(BsonBinary value) {
        if (value.getType() == BsonBinarySubType.UUID_LEGACY.getValue()) {
            this.bsonCallback.gotUUID(this.getName(), BSONCallbackAdapter.readLong(value.getData(), 0), BSONCallbackAdapter.readLong(value.getData(), 8));
        } else {
            this.bsonCallback.gotBinary(this.getName(), value.getType(), value.getData());
        }
    }

    public void doWriteBoolean(boolean value) {
        this.bsonCallback.gotBoolean(this.getName(), value);
        this.setState(this.getNextState());
    }

    protected void doWriteDateTime(long value) {
        this.bsonCallback.gotDate(this.getName(), value);
    }

    protected void doWriteDBPointer(BsonDbPointer value) {
        this.bsonCallback.gotDBRef(this.getName(), value.getNamespace(), value.getId());
    }

    protected void doWriteDouble(double value) {
        this.bsonCallback.gotDouble(this.getName(), value);
    }

    protected void doWriteInt32(int value) {
        this.bsonCallback.gotInt(this.getName(), value);
    }

    protected void doWriteInt64(long value) {
        this.bsonCallback.gotLong(this.getName(), value);
    }

    protected void doWriteDecimal128(Decimal128 value) {
        this.bsonCallback.gotDecimal128(this.getName(), value);
    }

    protected void doWriteJavaScript(String value) {
        this.bsonCallback.gotCode(this.getName(), value);
    }

    protected void doWriteJavaScriptWithScope(String value) {
        this.getContext().callback = this.bsonCallback;
        this.getContext().code = value;
        this.getContext().name = this.getName();
        this.bsonCallback = this.bsonCallback.createBSONCallback();
    }

    protected void doWriteMaxKey() {
        this.bsonCallback.gotMaxKey(this.getName());
    }

    protected void doWriteMinKey() {
        this.bsonCallback.gotMinKey(this.getName());
    }

    public void doWriteNull() {
        this.bsonCallback.gotNull(this.getName());
    }

    public void doWriteObjectId(ObjectId value) {
        this.bsonCallback.gotObjectId(this.getName(), value);
    }

    public void doWriteRegularExpression(BsonRegularExpression value) {
        this.bsonCallback.gotRegex(this.getName(), value.getPattern(), value.getOptions());
    }

    public void doWriteString(String value) {
        this.bsonCallback.gotString(this.getName(), value);
    }

    public void doWriteSymbol(String value) {
        this.bsonCallback.gotSymbol(this.getName(), value);
    }

    public void doWriteTimestamp(BsonTimestamp value) {
        this.bsonCallback.gotTimestamp(this.getName(), value.getTime(), value.getInc());
    }

    public void doWriteUndefined() {
        this.bsonCallback.gotUndefined(this.getName());
    }

    protected Context getContext() {
        return (Context)super.getContext();
    }

    protected String getName() {
        if (this.getContext().getContextType() == BsonContextType.ARRAY) {
            return Integer.toString(this.getContext().index++);
        }
        return super.getName();
    }

    static long readLong(byte[] buffer, int offset) {
        long x = 0L;
        x |= (0xFFL & (long)buffer[offset + 0]) << 0;
        x |= (0xFFL & (long)buffer[offset + 1]) << 8;
        x |= (0xFFL & (long)buffer[offset + 2]) << 16;
        x |= (0xFFL & (long)buffer[offset + 3]) << 24;
        x |= (0xFFL & (long)buffer[offset + 4]) << 32;
        x |= (0xFFL & (long)buffer[offset + 5]) << 40;
        x |= (0xFFL & (long)buffer[offset + 6]) << 48;
        return x |= (0xFFL & (long)buffer[offset + 7]) << 56;
    }

    public class Context
    extends AbstractBsonWriter.Context {
        private int index;
        private BSONCallback callback;
        private String code;
        private String name;

        Context(Context parentContext, BsonContextType contextType) {
            super((AbstractBsonWriter)BSONCallbackAdapter.this, (AbstractBsonWriter.Context)parentContext, contextType);
        }

        public Context getParentContext() {
            return (Context)super.getParentContext();
        }
    }
}

