/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import com.mongodb.mongoreplay.AbstractMongoReplayUtil;
import com.mongodb.mongoreplay.AccumulatorKey;
import com.mongodb.mongoreplay.ReplayResult;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.zip.DataFormatException;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class MongoReplay
extends AbstractMongoReplayUtil {
    private Map<AccumulatorKey, DescriptiveStatistics> accumulators = new HashMap<AccumulatorKey, DescriptiveStatistics>();
    private int NANOS_TO_MILLIS = 1000000;

    public void executeSplitMode() throws FileNotFoundException, DataFormatException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.init();
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            this.replayFileSplitMode(filename);
            ++n2;
        }
        this.processResults();
    }

    public void execute() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, FileNotFoundException, DataFormatException {
        this.init();
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            this.replayFile(filename);
            ++n2;
        }
        this.processResults();
    }

    private void accumulateResult(ReplayResult result) {
        AccumulatorKey key;
        DescriptiveStatistics stats;
        if (result == null || result.getCollectionName() == null) {
            System.out.println("xxx");
        }
        if ((stats = this.accumulators.get(key = new AccumulatorKey(result.getDbName(), result.getCollectionName(), result.getCommand(), result.getQueryShape()))) == null) {
            stats = new DescriptiveStatistics();
            this.accumulators.put(key, stats);
        }
        stats.addValue(result.getDuration());
    }

    private void processResults() {
        logger.debug("Processing results");
        boolean count = false;
        for (Future future : this.futures) {
            Object res = null;
            try {
                res = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("Error getting future", (Throwable)e);
            }
            if (res == null) continue;
            if (res instanceof ReplayResult) {
                ReplayResult result = res;
                this.accumulateResult(result);
                continue;
            }
            if (res instanceof String) {
                logger.debug("String result: " + res);
                continue;
            }
            if (res instanceof List) {
                List results = res;
                Iterator<Object> iterator = results.iterator();
                while (iterator.hasNext()) {
                    ReplayResult replayResult = (ReplayResult)iterator.next();
                    this.accumulateResult(replayResult);
                }
                continue;
            }
            logger.debug("Unk result: " + res);
        }
        logger.debug("DONE processing results");
        if (this.pool.isPaused()) {
            logger.debug("executor is paused, resuming");
            this.pool.resume();
        }
        this.close();
        int maxNamespaceLen = 0;
        int maxShapeLen = 0;
        for (AccumulatorKey key : this.accumulators.keySet()) {
            int shapeLen;
            int n = key.getNamespace().length();
            if (n > maxNamespaceLen) {
                maxNamespaceLen = n;
            }
            if (key.getShape() == null || (shapeLen = key.getShape().length()) <= maxShapeLen) continue;
            maxShapeLen = shapeLen;
        }
        ++maxNamespaceLen;
        if (++maxShapeLen < 14) {
            maxShapeLen = 14;
        }
        String formatString = "%-" + maxNamespaceLen + "s %-" + maxShapeLen + "s %-16s %-10d %-10.0f %-10.0f %-10.0f %-10.0f";
        String headerFormatString = "%-" + maxNamespaceLen + "s %-" + maxShapeLen + "s %-16s %-10s %-10s %-10s %-10s %-10s";
        System.out.println(String.format(headerFormatString, "namespace", "query shape", "cmd", "count", "min", "max", "avg", "95p"));
        for (Map.Entry entry : this.accumulators.entrySet()) {
            AccumulatorKey key = (AccumulatorKey)entry.getKey();
            DescriptiveStatistics stats = (DescriptiveStatistics)entry.getValue();
            System.out.println(String.format(formatString, key.getNamespace(), key.getShape(), key.getCommand().name(), stats.getN(), stats.getMin() / (double)this.NANOS_TO_MILLIS, stats.getMax() / (double)this.NANOS_TO_MILLIS, stats.getMean() / (double)this.NANOS_TO_MILLIS, stats.getPercentile(0.95) / (double)this.NANOS_TO_MILLIS));
        }
    }

    public static void main(String[] args) throws Exception {
        MongoReplay replay = new MongoReplay();
        replay.parseArgs(args);
        if (replay.isSplitFilesMode()) {
            replay.executeSplitMode();
        } else {
            replay.execute();
        }
    }
}

