/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import com.mongodb.MongoClientSettings;
import com.mongodb.mongoreplay.BSONCallbackAdapter;
import com.mongodb.mongoreplay.opcodes.MessageHeader;
import com.mongodb.mongoreplay.opcodes.Section;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.DataFormatException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.BsonSerializationException;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.UuidCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;
import org.bson.io.ByteBufferBsonInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoReplayFilter {
    protected static final Logger logger = LoggerFactory.getLogger(MongoReplayFilter.class);
    private final BasicBSONEncoder encoder;
    private final BSONDecoder decoder;
    private static final EncoderContext encoderContext = EncoderContext.builder().build();
    CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new UuidCodecProvider(UuidRepresentation.STANDARD), PojoCodecProvider.builder().automatic(true).build()})});
    DocumentCodec documentCodec = new DocumentCodec(this.registry);
    private String[] removeUpdateFields;
    private int limit = Integer.MAX_VALUE;
    private int splits = 1;
    private Map<Integer, Integer> opcodeSeenCounters = new TreeMap<Integer, Integer>();
    private int systemDatabasesSkippedCount = 0;
    int count = 0;
    int written = 0;
    BSONObject obj;
    BSONObject raw;
    BSONObject header;
    MessageHeader parsedHeader;
    private List<FileChannel> fileChannels;
    private FileChannel channel;
    LinkedList<Document> documents = new LinkedList();

    public MongoReplayFilter() {
        this.encoder = new BasicBSONEncoder();
        this.decoder = new BasicBSONDecoder();
    }

    private void createOutputFiles(String filename) throws FileNotFoundException {
        this.fileChannels = new ArrayList<FileChannel>(this.splits);
        int i = 1;
        while (i <= this.splits) {
            File outputFile = new File(String.format("%s.%s.FILTERED", filename, i));
            FileOutputStream fos = new FileOutputStream(outputFile);
            this.fileChannels.add(fos.getChannel());
            ++i;
        }
    }

    private void setOutputFileChannel(Long seenNum) {
        int index = 0;
        if (seenNum != null) {
            index = seenNum.intValue() % this.splits;
        }
        this.channel = this.fileChannels.get(index);
    }

    /*
     * Exception decompiling
     */
    public void filterFile(String filename) throws FileNotFoundException, DataFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[WHILELOOP]], but top level block is 33[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void transcode2013(Document commandDoc, String collectionName) throws IOException {
        BasicOutputBuffer tmpBuff = new BasicOutputBuffer();
        BsonBinaryWriter tmpWriter = new BsonBinaryWriter((BsonOutput)tmpBuff);
        this.documentCodec.encode((BsonWriter)tmpWriter, commandDoc, encoderContext);
        int commandDocSize = tmpBuff.getSize();
        BasicOutputBuffer rawOut = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)rawOut);
        int totalLen = commandDocSize + 28 + collectionName.length();
        rawOut.writeInt(totalLen);
        rawOut.writeInt(this.parsedHeader.getRequestId());
        rawOut.writeInt(this.parsedHeader.getResponseTo());
        rawOut.writeInt(2004);
        rawOut.writeInt(0);
        rawOut.writeCString(collectionName);
        rawOut.writeInt(0);
        rawOut.writeInt(-1);
        this.documentCodec.encode((BsonWriter)writer, commandDoc, encoderContext);
        int size1 = writer.getBsonOutput().getPosition();
        this.header.put("messagelength", (Object)size1);
        this.header.put("opcode", (Object)2004);
        this.raw.put("body", (Object)rawOut.toByteArray());
        ByteBuffer buffer = ByteBuffer.wrap(this.encoder.encode(this.obj));
        this.channel.write(buffer);
        ++this.written;
    }

    private void process2013(ByteBufferBsonInput bsonInput, BsonBinaryReader reader, FileChannel channel, int messageLength) throws IOException {
        this.documents.clear();
        int kindZeroCount = 0;
        int count = 0;
        int flags = bsonInput.readInt32();
        boolean moreSections = true;
        String databaseName = null;
        Document commandDoc = null;
        Section currentSection = null;
        while (moreSections) {
            byte kindByte = bsonInput.readByte();
            currentSection = new Section(kindByte);
            ++count;
            if (kindByte == 0) {
                ++kindZeroCount;
                commandDoc = this.documentCodec.decode((BsonReader)reader, DecoderContext.builder().build());
                moreSections = messageLength > bsonInput.getPosition();
                databaseName = commandDoc.getString((Object)"$db");
                if (databaseName == null || databaseName.equals("local") || databaseName.equals("admin") || commandDoc.containsKey((Object)"getMore") || commandDoc.containsKey((Object)"ping")) {
                    return;
                }
                commandDoc.remove((Object)"lsid");
                commandDoc.remove((Object)"$db");
                commandDoc.remove((Object)"$readPreference");
                commandDoc.remove((Object)"txnNumber");
                currentSection.setDocument(commandDoc);
                this.documents.addFirst(commandDoc);
                continue;
            }
            if (kindByte == 1) {
                int x0 = bsonInput.getPosition();
                try {
                    int currentSize;
                    int size = bsonInput.readInt32();
                    String messageIdentifier = bsonInput.readCString();
                    int x1 = bsonInput.getPosition();
                    int remaining = size - (x1 - x0);
                    if (messageIdentifier == null) {
                        logger.warn("null messageIdentifier");
                        return;
                    }
                    currentSection.setSize(size);
                    currentSection.setMessageIdentifier(messageIdentifier);
                    int docCount = 0;
                    do {
                        int p0 = bsonInput.getPosition();
                        byte[] mb = new byte[remaining];
                        bsonInput.readBytes(mb);
                        BsonBinaryReader r2 = new BsonBinaryReader(ByteBuffer.wrap(mb));
                        Document d = this.documentCodec.decode((BsonReader)r2, DecoderContext.builder().build());
                        this.documents.add(d);
                        currentSection.addDocument(d);
                        int p1 = bsonInput.getPosition();
                        currentSize = p1 - p0;
                        ++docCount;
                    } while (currentSize < remaining);
                    if (docCount > 1) {
                        logger.debug("***** docCount: " + docCount);
                    }
                    moreSections = messageLength > bsonInput.getPosition();
                }
                catch (BsonSerializationException bse) {
                    Integer req = (Integer)this.header.get("requestid");
                    System.out.println("*** req: " + req + ",  pos: " + bsonInput.getPosition() + ", len: " + this.parsedHeader.getMessageLength());
                    bse.printStackTrace();
                }
                continue;
            }
            moreSections = false;
        }
        if (kindZeroCount != 1) {
            logger.error("Invalid kindZeroCount {}", (Object)kindZeroCount);
            return;
        }
        BasicOutputBuffer rawOut = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)rawOut);
        rawOut.writeInt(0);
        rawOut.writeInt(this.parsedHeader.getRequestId());
        rawOut.writeInt(this.parsedHeader.getResponseTo());
        rawOut.writeInt(2013);
        rawOut.writeInt(0);
        boolean position = false;
        for (Document document : this.documents) {
            if (!position) {
                rawOut.writeByte(0);
            } else {
                rawOut.writeByte(1);
            }
            int beforeSize = rawOut.getSize();
            this.documentCodec.encode((BsonWriter)writer, document, encoderContext);
            int afterSize = rawOut.getSize();
            int n = afterSize - beforeSize;
        }
        int size1 = writer.getBsonOutput().getPosition();
        this.header.put("messagelength", (Object)size1);
        this.header.put("opcode", (Object)2013);
        this.raw.put("body", (Object)rawOut.toByteArray());
        ByteBuffer buffer = ByteBuffer.wrap(this.encoder.encode(this.obj));
        channel.write(buffer);
        ++this.written;
        if (commandDoc.containsKey((Object)"insert")) {
            String collName = commandDoc.getString((Object)"insert");
            this.transcode2013(commandDoc, collName);
        } else if (!commandDoc.containsKey((Object)"update")) {
            if (commandDoc.containsKey((Object)"find")) {
                String collName = commandDoc.getString((Object)"find");
                this.transcode2013(commandDoc, collName);
            } else if (commandDoc.containsKey((Object)"aggregate")) {
                String collName = commandDoc.getString((Object)"aggregate");
                this.transcode2013(commandDoc, collName);
            } else if (commandDoc.containsKey((Object)"count")) {
                String collName = commandDoc.getString((Object)"count");
                this.transcode2013(commandDoc, collName);
            } else if (commandDoc.containsKey((Object)"delete")) {
                String collName = commandDoc.getString((Object)"delete");
                this.transcode2013(commandDoc, collName);
            } else {
                if (commandDoc.containsKey((Object)"getMore") || commandDoc.containsKey((Object)"ping")) {
                    return;
                }
                logger.warn("ignored command: " + commandDoc);
            }
        }
    }

    public BSONObject readObject(byte[] bytes) {
        BasicBSONCallback bsonCallback = new BasicBSONCallback();
        this.decode(bytes, (BSONCallback)bsonCallback);
        return (BSONObject)bsonCallback.get();
    }

    private void decode(byte[] bytes, BSONCallback callback) {
        try (BsonBinaryReader reader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput((ByteBuf)new ByteBufNIO(ByteBuffer.wrap(bytes))));){
            BSONCallbackAdapter writer = new BSONCallbackAdapter(new BsonWriterSettings(), callback);
            writer.pipe((BsonReader)reader);
        }
    }

    private void logCounts() {
        for (Map.Entry<Integer, Integer> entry : this.opcodeSeenCounters.entrySet()) {
            logger.debug(String.format("opcode: %4s count: %,10d", entry.getKey(), entry.getValue()));
        }
        logger.debug(String.format("systemDatabasesSkippedCount: : %,10d", this.systemDatabasesSkippedCount));
    }

    private void incrementOpcodeSeenCount(int opcode) {
        Integer count = this.opcodeSeenCounters.getOrDefault(opcode, 0);
        count = count + 1;
        this.opcodeSeenCounters.put(opcode, count);
    }

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        String[] fileNames;
        Options options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"input mongoreplay bson file(s)");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"files");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"number of output files split");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"split");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"remove update fields");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"removeUpdateFields");
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)"limit # operations");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"limit");
        options.addOption(OptionBuilder.create((String)"l"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                MongoReplayFilter.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            MongoReplayFilter.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            MongoReplayFilter.printHelpAndExit(options);
        }
        if ((fileNames = line.getOptionValues("f")) == null) {
            MongoReplayFilter.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("logParser", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String splitStr;
        CommandLine line = MongoReplayFilter.initializeAndParseCommandLineOptions(args);
        String[] fileNames = line.getOptionValues("f");
        String[] removeUpdateFields = line.getOptionValues("u");
        String limitStr = line.getOptionValue("l");
        MongoReplayFilter filter = new MongoReplayFilter();
        filter.setRemoveUpdateFields(removeUpdateFields);
        if (limitStr != null) {
            int limit = Integer.parseInt(limitStr);
            filter.setLimit(limit);
        }
        if ((splitStr = line.getOptionValue("s")) != null) {
            int splits = Integer.parseInt(splitStr);
            filter.setSplits(splits);
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            filter.filterFile(filename);
            ++n2;
        }
    }

    public String[] getRemoveUpdateFields() {
        return this.removeUpdateFields;
    }

    public void setRemoveUpdateFields(String[] removeUpdateFields) {
        this.removeUpdateFields = removeUpdateFields;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setSplits(int splits) {
        this.splits = splits;
    }
}

