/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;

public class MongoReplayStats {
    private final BasicBSONEncoder encoder = new BasicBSONEncoder();

    public void filterFile(String filename) throws FileNotFoundException {
        int written;
        int count;
        HashMap<Integer, AtomicInteger> atomicCounter;
        block17: {
            File file = new File(filename);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            atomicCounter = new HashMap<Integer, AtomicInteger>();
            BasicBSONDecoder decoder = new BasicBSONDecoder();
            count = 0;
            written = 0;
            try {
                try {
                    while (((InputStream)inputStream).available() > 0) {
                        BSONObject obj = decoder.readObject((InputStream)inputStream);
                        if (obj != null) {
                            BSONObject raw = (BSONObject)obj.get("rawop");
                            BSONObject header = (BSONObject)raw.get("header");
                            if (header != null) {
                                Integer opcode = (Integer)header.get("opcode");
                                AtomicInteger frequency = (AtomicInteger)atomicCounter.get(opcode);
                                if (frequency != null) {
                                    frequency.incrementAndGet();
                                } else {
                                    atomicCounter.put(opcode, new AtomicInteger(1));
                                }
                            }
                            ++count;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.err.println(String.format("%s objects read, %s filtered objects written", count, written));
        for (Map.Entry pair : atomicCounter.entrySet()) {
            System.out.println(pair.getKey() + " = " + pair.getValue());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Expected <bson filename> argument");
        }
        String filename = args[0];
        MongoReplayStats filter = new MongoReplayStats();
        filter.filterFile(filename);
    }
}

