/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import com.mongodb.ReadConcernLevel;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.mongoreplay.ReplayMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class ReplayOptions {
    private Set<String> ignoredCollections = new HashSet<String>();
    protected String[] removeUpdateFields;
    private Map<String, String> dbNamesMap;
    private ReplayMode replayMode;
    private BsonDocument writeConcern = WriteConcern.ACKNOWLEDGED.asDocument();
    private Long sleepMillis;
    private BsonDocument readConcernDocument;
    private ReadPreference readPreference;

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public ReplayOptions() {
        this.ignoredCollections.add("system.sessions");
    }

    public Set<String> getIgnoredCollections() {
        return this.ignoredCollections;
    }

    public void addIgnoredCollections(Set<String> ignoredCollections) {
        this.ignoredCollections.addAll(ignoredCollections);
    }

    public String[] getRemoveUpdateFields() {
        return this.removeUpdateFields;
    }

    public void setRemoveUpdateFields(String[] removeUpdateFields) {
        this.removeUpdateFields = removeUpdateFields;
    }

    public BsonDocument getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(BsonDocument writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setReadConcernLevel(ReadConcernLevel level) {
        this.readConcernDocument = new BsonDocument();
        this.readConcernDocument.put("level", (BsonValue)new BsonString(level.getValue()));
    }

    public BsonDocument getReadConcern() {
        return this.readConcernDocument;
    }

    public Long getSleepMillis() {
        return this.sleepMillis;
    }

    public void setSleepMillis(Long sleepMillis) {
        this.sleepMillis = sleepMillis;
    }

    public void setDbNameMapString(String dbNamesMapString) {
        String[] mappings;
        this.dbNamesMap = new HashMap<String, String>();
        String[] stringArray = mappings = dbNamesMapString.split(",");
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String mapping = stringArray[n2];
            String[] dbMapping = mapping.split("\\|");
            this.dbNamesMap.put(dbMapping[0], dbMapping[1]);
            ++n2;
        }
    }

    public Map<String, String> getDbNamesMap() {
        return this.dbNamesMap;
    }

    public ReplayMode getReplayMode() {
        return this.replayMode;
    }

    public void setReplayMode(ReplayMode replayMode) {
        this.replayMode = replayMode;
    }
}

