/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import com.mongodb.mongoreplay.Command;
import java.util.Set;

public class ReplayResult {
    private String dbName;
    private String collectionName;
    private Command command;
    private boolean success;
    private double duration;
    private String queryShape;

    public ReplayResult(String queryShape, String dbName, String collectionName, Command command, long duration, boolean success) {
        this.queryShape = queryShape;
        assert (dbName != null);
        assert (collectionName != null);
        this.dbName = dbName;
        this.collectionName = collectionName;
        this.command = command;
        this.success = success;
        this.duration = duration;
    }

    public ReplayResult(Set<String> shape, String dbName, String collectionName, Command command, long duration, boolean success) {
        if (shape != null) {
            this.queryShape = shape.toString();
        }
        assert (dbName != null);
        assert (collectionName != null);
        this.dbName = dbName;
        this.collectionName = collectionName;
        this.command = command;
        this.success = success;
        this.duration = duration;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getQueryShape() {
        return this.queryShape;
    }

    public String getCollectionName() {
        return this.collectionName;
    }
}

