/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import com.mongodb.MongoCommandException;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.mongoreplay.Command;
import com.mongodb.mongoreplay.Monitor;
import com.mongodb.mongoreplay.ReplayMode;
import com.mongodb.mongoreplay.ReplayOptions;
import com.mongodb.mongoreplay.ReplayResult;
import com.mongodb.util.ShapeUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bson.BSONObject;
import org.bson.BsonArray;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.conversions.Bson;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replayer {
    private Monitor monitor;
    private MongoClient mongoClient;
    private ReplayOptions replayOptions;
    private static final DocumentCodec documentCodec = new DocumentCodec();
    private static final DecoderContext decoderContext = DecoderContext.builder().build();
    protected static final Logger logger = LoggerFactory.getLogger(Replayer.class);
    private static final BsonDocument DEFAULT_WRITE_CONCERN = WriteConcern.W1.asDocument();

    public Replayer(Monitor monitor, MongoClient mongoClient, ReplayOptions replayOptions) {
        this.monitor = monitor;
        this.mongoClient = mongoClient;
        this.replayOptions = replayOptions;
    }

    private void sleep() {
        Long sleep = this.replayOptions.getSleepMillis();
        if (sleep != null) {
            try {
                Thread.currentThread();
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private CommandResult processCommand(String databaseName, Document commandDoc) {
        CommandResult commandResult = new CommandResult();
        if (commandDoc.containsKey((Object)"$query")) {
            Document queryDoc;
            commandDoc = queryDoc = (Document)commandDoc.get((Object)"$query");
        }
        commandDoc.remove((Object)"shardVersion");
        commandDoc.remove((Object)"$clusterTime");
        commandDoc.remove((Object)"$configServerState");
        if (commandDoc.containsKey((Object)"find")) {
            commandResult.command = Command.FIND;
            commandResult.collectionName = commandDoc.getString((Object)"find");
            Document predicates = (Document)commandDoc.get((Object)"filter");
            commandResult.shape = ShapeUtil.getShape(predicates);
        } else if (commandDoc.containsKey((Object)"insert")) {
            commandResult.command = Command.INSERT;
            commandResult.collectionName = commandDoc.getString((Object)"insert");
        } else if (commandDoc.containsKey((Object)"findAndModify")) {
            commandResult.command = Command.FIND_AND_MODIFY;
            commandResult.collectionName = commandDoc.getString((Object)"findAndModify");
        } else if (commandDoc.containsKey((Object)"findandmodify")) {
            commandResult.command = Command.FIND_AND_MODIFY;
            commandResult.collectionName = commandDoc.getString((Object)"findandmodify");
        } else if (commandDoc.containsKey((Object)"update")) {
            commandResult.command = Command.UPDATE;
            Object update = commandDoc.get((Object)"update");
            if (update instanceof Document) {
                Document doc = (Document)update;
                System.out.println(doc);
                commandResult.collectionName = commandDoc.getString((Object)"update");
            } else if (update instanceof String) {
                commandResult.collectionName = (String)update;
            } else {
                logger.debug("Unexepcted update value: " + update);
            }
            List updates = (List)commandDoc.get((Object)"updates");
            if (updates == null) {
                System.out.println("wtf");
                return null;
            }
            for (Document updateDoc : updates) {
                Document query = (Document)updateDoc.get((Object)"q");
                commandResult.shape = ShapeUtil.getShape(query);
                if (this.replayOptions.getRemoveUpdateFields() == null) continue;
                String[] stringArray = this.replayOptions.getRemoveUpdateFields();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fieldName = stringArray[n2];
                    query.remove((Object)fieldName);
                    ++n2;
                }
            }
        } else {
            if (commandDoc.containsKey((Object)"getMore")) {
                commandResult.command = Command.GETMORE;
                commandResult.ignore = true;
                return null;
            }
            if (commandDoc.containsKey((Object)"aggregate")) {
                commandResult.command = Command.AGGREGATE;
                List stages = (List)commandDoc.get((Object)"pipeline");
                if (stages != null) {
                    for (Document stage : stages) {
                        if (!stage.containsKey((Object)"$mergeCursors")) continue;
                        commandResult.ignore = true;
                        return null;
                    }
                }
                commandDoc.remove((Object)"fromRouter");
            } else if (commandDoc.containsKey((Object)"delete")) {
                commandResult.command = Command.DELETE;
                commandResult.collectionName = commandDoc.getString((Object)"delete");
            } else if (commandDoc.containsKey((Object)"count")) {
                commandResult.command = Command.COUNT;
                commandResult.collectionName = commandDoc.getString((Object)"count");
            } else {
                logger.warn("ignored command: " + commandDoc);
                ++commandResult.ignored;
                commandResult.ignore = true;
                return null;
            }
        }
        if (this.replayOptions.getIgnoredCollections().contains(commandResult.collectionName)) {
            ++commandResult.ignored;
            commandResult.ignore = true;
            return null;
        }
        if (this.replayOptions.getReplayMode() == ReplayMode.READ_ONLY && !commandResult.command.isRead()) {
            commandResult.ignore = true;
            return null;
        }
        return commandResult;
    }

    public Document adminCommand(Document command) {
        return this.mongoClient.getDatabase("admin").runCommand((Bson)command);
    }

    private BsonDocument getKillCursorsCommandDocument(String collectionName, long cursorId) {
        return new BsonDocument("killCursors", (BsonValue)new BsonString(collectionName)).append("cursors", (BsonValue)new BsonArray(Collections.singletonList(new BsonInt64(cursorId))));
    }

    public ReplayResult replay(BSONObject raw) {
        Document commandDoc = null;
        CommandResult commandResult = null;
        String databaseName = null;
        byte[] bytes = (byte[])raw.get("body");
        if (bytes.length == 0) {
            return null;
        }
        BSONObject header = (BSONObject)raw.get("header");
        if (header != null) {
            int opcode = (Integer)header.get("opcode");
            ByteBufferBsonInput bsonInput = new ByteBufferBsonInput((ByteBuf)new ByteBufNIO(ByteBuffer.wrap(bytes)));
            BsonBinaryReader reader = new BsonBinaryReader((BsonInput)bsonInput);
            int messageLength = bsonInput.readInt32();
            int requestId = bsonInput.readInt32();
            int responseTo = bsonInput.readInt32();
            int headerOpcode = bsonInput.readInt32();
            if (opcode == 2004) {
                flags = bsonInput.readInt32();
                String collectionName = bsonInput.readCString();
                databaseName = StringUtils.substringBefore((String)collectionName, (String)".$cmd");
                if (databaseName.equals("local") || databaseName.equals("admin")) {
                    return null;
                }
                if (this.replayOptions.getIgnoredCollections().contains(collectionName)) {
                    return null;
                }
                int nskip = bsonInput.readInt32();
                int nreturn = bsonInput.readInt32();
                commandDoc = documentCodec.decode((BsonReader)reader, decoderContext);
                commandResult = this.processCommand(databaseName, commandDoc);
            } else if (opcode == 2010) {
                int p1 = bsonInput.getPosition();
                databaseName = bsonInput.readCString();
                if (databaseName.equals("local") || databaseName.equals("admin")) {
                    return null;
                }
                String command = bsonInput.readCString();
                commandDoc = documentCodec.decode((BsonReader)reader, decoderContext);
                commandDoc.remove((Object)"shardVersion");
                commandResult = this.processCommand(databaseName, commandDoc);
            } else if (opcode == 2013) {
                flags = bsonInput.readInt32();
                boolean moreSections = true;
                Document k0 = null;
                Document d1 = null;
                int count = 0;
                while (moreSections) {
                    byte kindByte = bsonInput.readByte();
                    ++count;
                    if (kindByte == 0) {
                        k0 = commandDoc = documentCodec.decode((BsonReader)reader, decoderContext);
                        moreSections = messageLength > bsonInput.getPosition();
                        databaseName = commandDoc.getString((Object)"$db");
                        if (databaseName == null || databaseName.equals("local") || databaseName.equals("admin")) continue;
                        commandDoc.remove((Object)"lsid");
                        commandDoc.remove((Object)"$db");
                        commandDoc.remove((Object)"$readPreference");
                        continue;
                    }
                    int p0 = bsonInput.getPosition();
                    int size = bsonInput.readInt32();
                    String seq = bsonInput.readCString();
                    int p1 = bsonInput.getPosition();
                    int remaining = size - (p1 - p0);
                    byte[] mb = new byte[remaining];
                    bsonInput.readBytes(mb);
                    BsonBinaryReader r2 = new BsonBinaryReader(ByteBuffer.wrap(mb));
                    d1 = documentCodec.decode((BsonReader)r2, decoderContext);
                    if (seq == null) {
                        logger.warn("null seq");
                        return null;
                    }
                    boolean bl = moreSections = messageLength > bsonInput.getPosition();
                }
                if (k0 != null && d1 != null) {
                    if (k0.containsKey((Object)"insert")) {
                        String collName = k0.getString((Object)"insert");
                        commandDoc.put("documents", Arrays.asList(d1));
                        commandResult = this.processCommand(databaseName, commandDoc);
                    } else if (k0.containsKey((Object)"update")) {
                        commandDoc.put("updates", Arrays.asList(d1));
                        commandResult = this.processCommand(databaseName, commandDoc);
                    }
                } else if (commandDoc.containsKey((Object)"find")) {
                    commandResult = this.processCommand(databaseName, commandDoc);
                }
            } else {
                logger.warn("ignored opcode: " + opcode);
                commandResult.ignore = true;
            }
        }
        if (commandResult == null || commandResult.command == null || commandResult.ignore) {
            return null;
        }
        long start = System.nanoTime();
        ReplayResult replayResult = null;
        String db = null;
        if (this.replayOptions.getDbNamesMap() != null) {
            db = this.replayOptions.getDbNamesMap().get(databaseName);
            if (db == null) {
                db = databaseName;
            }
        } else {
            db = databaseName;
        }
        try {
            long cid;
            Document executeResult = null;
            if (commandResult.command.isRead()) {
                if (this.replayOptions.getReadConcern() != null) {
                    commandDoc.put("readConcern", (Object)this.replayOptions.getReadConcern());
                }
                executeResult = this.mongoClient.getDatabase(db).runCommand(commandDoc, this.replayOptions.getReadPreference());
            } else {
                BsonDocument wc = this.replayOptions.getWriteConcern();
                if (wc != null && wc.containsKey((Object)"w")) {
                    commandDoc.put("writeConcern", (Object)wc);
                } else {
                    commandDoc.put("writeConcern", (Object)DEFAULT_WRITE_CONCERN);
                }
                executeResult = this.mongoClient.getDatabase(db).runCommand(commandDoc);
            }
            long duration = System.nanoTime() - start;
            Number ok = (Number)executeResult.get((Object)"ok");
            Document cursorDoc = (Document)executeResult.get((Object)"cursor");
            if (cursorDoc != null && (cid = cursorDoc.getLong((Object)"id").longValue()) != 0L) {
                BsonDocument killCursor = this.getKillCursorsCommandDocument(commandResult.collectionName, cid);
                try {
                    Document document = this.mongoClient.getDatabase(db).runCommand((Bson)killCursor);
                }
                catch (MongoCommandException mongoCommandException) {
                    // empty catch block
                }
            }
            if (ok.equals(1.0)) {
                this.monitor.incrementEventCount();
                replayResult = new ReplayResult(commandResult.shape, db, commandResult.collectionName, commandResult.command, duration, true);
            } else {
                replayResult = new ReplayResult(commandResult.shape, db, commandResult.collectionName, commandResult.command, duration, false);
                this.monitor.incrementErrorCount();
            }
        }
        catch (MongoCommandException e) {
            if (e.getCode() != 11000) {
                logger.error(String.format("Error executing command: %s", commandDoc), (Throwable)e);
            }
            this.monitor.incrementErrorCount();
        }
        catch (Exception e) {
            logger.error(String.format("Unexcpected error executing command: %s", commandDoc), (Throwable)e);
            this.monitor.incrementErrorCount();
        }
        return replayResult;
    }

    class CommandResult {
        Set<String> shape = null;
        Command command = null;
        String collectionName = null;
        int ignored = 0;
        boolean ignore = false;

        CommandResult() {
        }
    }
}

