/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongoreplay;

import com.mongodb.mongoreplay.Command;
import com.mongodb.mongoreplay.ReplayOptions;
import com.mongodb.mongoreplay.ReplayResult;
import com.mongodb.mongoreplay.Replayer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitModeReplayTask
implements Callable<List<ReplayResult>> {
    private Document commandDoc;
    private String databaseName;
    private String collectionName;
    private Command command;
    private String queryShape;
    private ReplayOptions replayOptions;
    private InputStream inputStream;
    private BSONObject raw;
    private boolean ignore = false;
    private int limit = Integer.MAX_VALUE;
    int count = 0;
    int written = 0;
    int ignored = 0;
    int getMoreCount = 0;
    private BSONObject firstSeen;
    private BSONObject lastSeen;
    private Set<Integer> opcodeWhitelist = new HashSet<Integer>();
    private static final DocumentCodec documentCodec = new DocumentCodec();
    private static final DecoderContext decoderContext = DecoderContext.builder().build();
    protected static final Logger logger = LoggerFactory.getLogger(SplitModeReplayTask.class);
    Replayer replayer;
    List<ReplayResult> replayResults = new LinkedList<ReplayResult>();

    public SplitModeReplayTask(Replayer replayer, InputStream inputStream) {
        this.replayer = replayer;
        this.inputStream = inputStream;
        this.opcodeWhitelist.addAll(Arrays.asList(2004, 2010, 2013));
    }

    private void process() {
        block16: {
            BasicBSONDecoder decoder = new BasicBSONDecoder();
            try {
                try {
                    while (this.inputStream.available() > 0) {
                        BSONObject obj;
                        if (this.count < this.limit && (obj = decoder.readObject(this.inputStream)) != null) {
                            ReplayResult result;
                            BSONObject raw = (BSONObject)obj.get("rawop");
                            if (raw == null) continue;
                            BSONObject header = (BSONObject)raw.get("header");
                            int opcode = (Integer)header.get("opcode");
                            if (!this.opcodeWhitelist.contains(opcode)) {
                                ++this.ignored;
                                continue;
                            }
                            Long seenconnectionnum = (Long)obj.get("seenconnectionnum");
                            this.lastSeen = (BSONObject)obj.get("seen");
                            if (this.count == 0) {
                                this.firstSeen = this.lastSeen;
                            }
                            if ((result = this.replayer.replay(raw)) != null) {
                                this.replayResults.add(result);
                            }
                            ++this.count;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.debug(String.format("%s objects read, %s filtered objects written, %s ignored", this.count, this.written, this.ignored));
        logger.debug(String.format("%s getMore", this.getMoreCount));
    }

    @Override
    public List<ReplayResult> call() {
        this.process();
        return this.replayResults;
    }
}

