/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongostat;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.mongostat.ServerStatus;
import com.mongodb.shardsync.ShardClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStat {
    private static Logger logger = LoggerFactory.getLogger(MongoStat.class);
    private List<MongoClient> mongoClients = new ArrayList<MongoClient>();
    private List<ServerStatus> serverStatuses = new ArrayList<ServerStatus>();
    private String[] uris;

    public void setUris(String[] uris) {
        this.uris = uris;
    }

    public void init() {
        String[] stringArray = this.uris;
        int n = this.uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            logger.debug("Connecting to " + uri);
            ConnectionString connectionString = new ConnectionString(uri);
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
            MongoClient client = MongoClients.create((MongoClientSettings)mongoClientSettings);
            Document isMaster = client.getDatabase("admin").runCommand((Bson)new Document("isMaster", (Object)1));
            logger.debug("isMaster: " + isMaster);
            boolean isMongos = false;
            try {
                Document isDbGridResponse = client.getDatabase("admin").runCommand((Bson)new Document("isdbgrid", (Object)1));
                Object isDbGrid = isDbGridResponse.get((Object)"isdbgrid");
                if (isDbGrid != null) {
                    isMongos = true;
                }
            }
            catch (MongoCommandException isDbGridResponse) {
                // empty catch block
            }
            if (isMongos) {
                ShardClient sourceShardClient = new ShardClient("source", uri);
                sourceShardClient.init();
                sourceShardClient.populateShardMongoClients();
                Collection<MongoClient> clients = sourceShardClient.getShardMongoClients().values();
                for (MongoClient c : clients) {
                    this.mongoClients.add(c);
                }
            } else {
                this.mongoClients.add(client);
            }
            ServerStatus status = new ServerStatus();
            this.serverStatuses.add(status);
            ++n2;
        }
    }

    public void run() {
        while (true) {
            int index = 0;
            System.out.printf("%-15s%8s%8s%8s%8s %13s%13s%13s%13s %n", "replicaSet", "insert", "query", "update", "delete", "totInserts", "totQueries", "totUpdates", "totDeletes");
            for (MongoClient client : this.mongoClients) {
                Document serverStatus = client.getDatabase("admin").runCommand((Bson)new Document("serverStatus", (Object)1));
                ServerStatus status = null;
                if (this.serverStatuses.size() >= index + 1) {
                    status = this.serverStatuses.get(index);
                } else {
                    status = new ServerStatus();
                    this.serverStatuses.add(index, status);
                }
                status.updateServerStatus(serverStatus);
                status.report();
                ++index;
            }
            System.out.println();
            this.sleep(1500L);
        }
    }

    private void sleep(long sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

