/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongostat;

import com.mongodb.mongostat.MongoStat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MongoStatApp {
    private static Options options;

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"Connection uri(s)");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"uri");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"u"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                MongoStatApp.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            MongoStatApp.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            MongoStatApp.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("logParser", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = MongoStatApp.initializeAndParseCommandLineOptions(args);
        MongoStat mongoStat = new MongoStat();
        String[] uris = line.getOptionValues("u");
        mongoStat.setUris(uris);
        mongoStat.init();
        mongoStat.run();
    }
}

