/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongostat;

import org.bson.Document;

public class ServerStatus {
    private String rsName;
    private Document databases;
    private int totalInserts = 0;
    private Integer currentInserts;
    private int totalQueries = 0;
    private Integer currentQueries;
    private int totalUpdates = 0;
    private Integer currentUpdates;
    private int totalDeletes = 0;
    private Integer currentDeletes;
    private Double totalCacheBytesRead = null;
    private Double lastCacheBytesRead = null;

    public void updateServerStatus(Document serverStatus) {
        Document ops = (Document)serverStatus.get((Object)"opcounters");
        if (this.rsName == null) {
            Document repl = (Document)serverStatus.get((Object)"repl");
            this.rsName = repl != null ? repl.getString((Object)"setName") : serverStatus.getString((Object)"host");
        }
        int inserts = ops.getInteger((Object)"insert");
        this.currentInserts = this.currentInserts == null ? Integer.valueOf(0) : Integer.valueOf(inserts - this.totalInserts);
        this.totalInserts = inserts;
        int updates = ops.getInteger((Object)"update");
        this.currentUpdates = this.currentUpdates == null ? Integer.valueOf(0) : Integer.valueOf(updates - this.totalUpdates);
        this.totalUpdates = updates;
        int queries = ops.getInteger((Object)"query");
        this.currentQueries = this.currentQueries == null ? Integer.valueOf(0) : Integer.valueOf(queries - this.totalQueries);
        this.totalQueries = queries;
        int deletes = ops.getInteger((Object)"delete");
        this.currentDeletes = this.currentDeletes == null ? Integer.valueOf(0) : Integer.valueOf(deletes - this.totalDeletes);
        this.totalDeletes = deletes;
        Document wiredTiger = (Document)serverStatus.get((Object)"wiredTiger");
        if (wiredTiger != null) {
            Document cache = (Document)wiredTiger.get((Object)"cache");
            Number cacheBytesNum = (Number)cache.get((Object)"bytes read into cache");
            Double cacheBytes = cacheBytesNum.doubleValue();
            if (this.lastCacheBytesRead != null) {
                Double current = cacheBytes - this.lastCacheBytesRead;
                this.totalCacheBytesRead = this.totalCacheBytesRead + current;
            } else {
                this.totalCacheBytesRead = 0.0;
            }
            this.lastCacheBytesRead = cacheBytes;
        }
    }

    public void report() {
        System.out.printf("%-15s%8s%8s%8s%8s %13s%13s%13s%13s %,8.0f %n", this.rsName, this.currentInserts, this.currentQueries, this.currentUpdates, this.currentDeletes, this.totalInserts, this.totalQueries, this.totalUpdates, this.totalDeletes, this.totalCacheBytesRead / 1024.0 / 1024.0);
    }
}

