/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.model.Namespace;
import com.mongodb.mongosync.BulkWriteOutput;
import com.mongodb.mongosync.OplogBatch;
import com.mongodb.mongosync.OplogTailMonitor;
import com.mongodb.shardsync.ShardClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyOperationsHelper {
    protected static final Logger logger = LoggerFactory.getLogger(ApplyOperationsHelper.class);
    private OplogTailMonitor oplogTailMonitor;
    private ShardClient destShardClient;
    private String shardId;
    private static final UpdateOptions upsertOptions = new UpdateOptions().upsert(true);
    private static final BulkWriteOptions orderedBulkWriteOptions = new BulkWriteOptions();
    private static final BulkWriteOptions unorderedBulkWriteOptions = new BulkWriteOptions().ordered(false);

    public ApplyOperationsHelper(String shardId, OplogTailMonitor oplogTailMonitor, ShardClient destShardClient) {
        this.shardId = shardId;
        this.oplogTailMonitor = oplogTailMonitor;
        this.destShardClient = destShardClient;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyBulkWriteModelsOnCollection(Namespace namespace, OplogBatch batch, List<WriteModel<BsonDocument>> writeModels, boolean useOrdered, BulkWriteOutput output) throws MongoException {
        collection = this.destShardClient.getCollectionRaw(namespace);
        bulkWriteResult = null;
        try {
            bulkWriteResult = useOrdered != false ? collection.bulkWrite(writeModels, ApplyOperationsHelper.orderedBulkWriteOptions) : collection.bulkWrite(writeModels, ApplyOperationsHelper.unorderedBulkWriteOptions);
            output.increment(bulkWriteResult);
            return;
        }
        catch (MongoBulkWriteException err) {
            errors = err.getWriteErrors();
            bulkWriteResult = err.getWriteResult();
            output.increment(bulkWriteResult, errors.size());
            if (errors.size() == writeModels.size() || !useOrdered) return;
            ** for (bwe : errors)
        }
lbl-1000:
        // 1 sources

        {
            index = bwe.getIndex();
            batch.removeWriteModel(writeModels.get(index), true);
            continue;
        }
lbl16:
        // 1 sources

        batch.clearUnordered();
        this.applyBulkWriteModelsOnCollection(namespace, batch, output);
        return;
        catch (Exception ex) {
            ApplyOperationsHelper.logger.error("{} unknown error: {}", new Object[]{this.shardId, ex.getMessage(), ex});
        }
    }

    public BulkWriteOutput applyBulkWriteModelsOnCollection(Namespace namespace, OplogBatch oplogBatch) {
        BulkWriteOutput output = new BulkWriteOutput();
        this.applyBulkWriteModelsOnCollection(namespace, oplogBatch, output);
        return output;
    }

    private void applyBulkWriteModelsOnCollection(Namespace namespace, OplogBatch oplogBatch, BulkWriteOutput output) throws MongoException {
        List<WriteModel<BsonDocument>> unorderedWriteModels;
        List<WriteModel<BsonDocument>> orderedWriteModels = oplogBatch.getOrderedWriteModels();
        if (!orderedWriteModels.isEmpty()) {
            this.applyBulkWriteModelsOnCollection(namespace, oplogBatch, orderedWriteModels, true, output);
        }
        if (!(unorderedWriteModels = oplogBatch.getUnorderedWriteModels()).isEmpty()) {
            this.applyBulkWriteModelsOnCollection(namespace, oplogBatch, unorderedWriteModels, false, output);
        }
    }

    private BulkWriteOutput applySoloBulkWriteModelsOnCollection(List<WriteModel<BsonDocument>> operations, MongoCollection<BsonDocument> collection, BulkWriteOutput output) {
        BulkWriteResult soloResult = null;
        int i = 1;
        for (WriteModel<BsonDocument> op : operations) {
            ArrayList<WriteModel<BsonDocument>> soloBulkOp = new ArrayList<WriteModel<BsonDocument>>();
            soloBulkOp.add(op);
            try {
                soloResult = collection.bulkWrite(operations, orderedBulkWriteOptions);
                logger.debug("{}: retry {} of {} - {}", new Object[]{this.shardId, i, operations.size(), output});
                output.incDeleted(soloResult.getDeletedCount());
                output.incInserted(soloResult.getInsertedCount());
                output.incModified(soloResult.getModifiedCount());
                output.incUpserted(soloResult.getUpserts().size());
            }
            catch (MongoBulkWriteException bwe) {
                output.incDuplicateKeyExceptionCount(1);
            }
            catch (Exception soloErr) {
                output.incDuplicateKeyExceptionCount(1);
                logger.error("[BULK-WRITE-RETRY] unknown exception occurred while applying solo op {} on collection: {}; error {}", new Object[]{op.toString(), collection.getNamespace().getFullName(), soloErr.toString()});
            }
            ++i;
        }
        return output;
    }

    public static WriteModel<BsonDocument> getWriteModelForOperation(BsonDocument operation) throws MongoException {
        return ApplyOperationsHelper.getWriteModelForOperation(operation, false);
    }

    public static WriteModel<BsonDocument> getWriteModelForOperation(BsonDocument operation, boolean upsert) throws MongoException {
        WriteModel<BsonDocument> model = null;
        switch (operation.getString((Object)"op").getValue()) {
            case "i": {
                model = ApplyOperationsHelper.getInsertWriteModel(operation);
                break;
            }
            case "u": {
                model = ApplyOperationsHelper.getUpdateWriteModel(operation, upsert);
                break;
            }
            case "d": {
                model = ApplyOperationsHelper.getDeleteWriteModel(operation);
                break;
            }
            default: {
                String message = String.format("unsupported operation %s; op: %s", operation.getString((Object)"op"), operation.toJson());
                logger.error(message);
            }
            case "n": 
        }
        return model;
    }

    private void performRunCommand(BsonDocument operation) {
        try {
            BsonDocument document = operation.getDocument((Object)"o");
            logger.debug("{}: performRunCommand, op: {}", (Object)this.shardId, (Object)operation);
            MongoDatabase database = this.destShardClient.getMongoClient().getDatabase("admin");
            database.runCommand((Bson)document);
            logger.debug("{}: completed performRunCommand, op: {}", (Object)this.shardId, (Object)operation);
        }
        catch (MongoException me) {
            logger.debug("{}: performRunCommand error, op: {}, error: {}", new Object[]{this.shardId, operation, me.getMessage()});
        }
    }

    private static WriteModel<BsonDocument> getInsertWriteModel(BsonDocument operation) {
        String ns = operation.getString((Object)"ns").getValue();
        BsonDocument document = operation.getDocument((Object)"o");
        return new InsertOneModel((Object)document);
    }

    private static WriteModel<BsonDocument> getUpdateWriteModel(BsonDocument operation, boolean upsert) {
        Set docKeys;
        BsonDocument find = operation.getDocument((Object)"o2");
        BsonDocument update = operation.getDocument((Object)"o");
        if (update.containsKey((Object)"$v")) {
            update.remove((Object)"$v");
        }
        if (((String)(docKeys = update.keySet()).iterator().next()).startsWith("$")) {
            if (upsert) {
                return new UpdateOneModel((Bson)find, (Bson)update, upsertOptions);
            }
            return new UpdateOneModel((Bson)find, (Bson)update);
        }
        return new ReplaceOneModel((Bson)find, (Object)update);
    }

    private static WriteModel<BsonDocument> getDeleteWriteModel(BsonDocument operation) throws MongoException {
        BsonDocument find = operation.getDocument((Object)"o");
        return new DeleteOneModel((Bson)find);
    }
}

