/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.bulk.BulkWriteResult;

public class BulkWriteOutput {
    private int duplicateKeyExceptionCount = 0;
    private int deletedCount = 0;
    private int modifiedCount = 0;
    private int insertedCount = 0;
    private int upsertedCount = 0;

    public BulkWriteOutput() {
    }

    public BulkWriteOutput(int deletedCount, int modifiedCount, int insertedCount, int upsertedCount, int duplicateKeyExceptionCount) {
        this.deletedCount = deletedCount;
        this.modifiedCount = modifiedCount;
        this.insertedCount = insertedCount;
        this.upsertedCount = upsertedCount;
        this.duplicateKeyExceptionCount = duplicateKeyExceptionCount;
    }

    public void incDeleted(int d) {
        this.deletedCount += d;
    }

    public void incModified(int m) {
        this.modifiedCount += m;
    }

    public void incInserted(int i) {
        this.insertedCount += i;
    }

    public void incUpserted(int u) {
        this.upsertedCount += u;
    }

    public void incDuplicateKeyExceptionCount(int d) {
        this.duplicateKeyExceptionCount += d;
    }

    public int getSuccessfulWritesCount() {
        return this.deletedCount + this.modifiedCount + this.insertedCount + this.upsertedCount + this.duplicateKeyExceptionCount;
    }

    public String toString() {
        return String.format("deletedCount: %d, modifiedCount: %d, insertedCount: %d, upsertedCount: %d, duplicateKeyExceptionCount: %d", this.deletedCount, this.modifiedCount, this.insertedCount, this.upsertedCount, this.duplicateKeyExceptionCount);
    }

    public int getDuplicateKeyExceptionCount() {
        return this.duplicateKeyExceptionCount;
    }

    public int getDeletedCount() {
        return this.deletedCount;
    }

    public int getModifiedCount() {
        return this.modifiedCount;
    }

    public int getInsertedCount() {
        return this.insertedCount;
    }

    public int getUpsertedCount() {
        return this.upsertedCount;
    }

    public void increment(BulkWriteResult result) {
        this.incDeleted(result.getDeletedCount());
        this.incModified(result.getModifiedCount());
        this.incInserted(result.getInsertedCount());
        this.incUpserted(result.getUpserts().size());
    }

    public void increment(BulkWriteResult result, int errorCount) {
        this.increment(result);
        this.incDuplicateKeyExceptionCount(errorCount);
    }
}

