/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.model.Namespace;
import com.mongodb.mongosync.ChunkCloneResult;
import com.mongodb.mongosync.MongoSyncOptions;
import com.mongodb.shardsync.ShardClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.bson.BsonSerializationException;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkCloneTask
implements Callable<ChunkCloneResult> {
    protected static final Logger logger = LoggerFactory.getLogger(ChunkCloneTask.class);
    protected Namespace ns;
    protected ShardClient sourceShardClient;
    protected ShardClient destShardClient;
    protected MongoSyncOptions options;
    protected MongoDatabase sourceDb;
    protected MongoDatabase destDb;
    protected MongoCollection<RawBsonDocument> sourceCollection;
    protected MongoCollection<RawBsonDocument> destCollection;
    protected Bson chunkQuery;
    private static final InsertManyOptions insertManyOptions = new InsertManyOptions().ordered(false);

    public ChunkCloneTask(Namespace ns, ShardClient sourceShardClient, ShardClient destShardClient, Bson chunkQuery, MongoSyncOptions options) {
        this.ns = ns;
        this.sourceShardClient = sourceShardClient;
        this.destShardClient = destShardClient;
        this.options = options;
        this.chunkQuery = chunkQuery;
        this.sourceDb = sourceShardClient.getMongoClient().getDatabase(ns.getDatabaseName());
        this.sourceCollection = this.sourceDb.getCollection(ns.getCollectionName(), RawBsonDocument.class);
        this.destDb = destShardClient.getMongoClient().getDatabase(ns.getDatabaseName());
        this.destCollection = this.destDb.getCollection(ns.getCollectionName(), RawBsonDocument.class);
    }

    @Override
    public ChunkCloneResult call() throws Exception {
        ChunkCloneResult result = this.cloneChunk();
        if (result == null) {
            logger.warn("problem cloning chunk, retrying, ns: {}, query: {}", (Object)this.ns, (Object)this.chunkQuery);
            result = this.cloneChunk();
            if (result != null) {
                logger.debug("chunk clone retry success, ns: {}, query: {}", (Object)this.ns, (Object)this.chunkQuery);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private ChunkCloneResult cloneChunk() {
        result = new ChunkCloneResult(this.ns, this.chunkQuery);
        cursor = null;
        try {
            block28: {
                docsBuffer = new ArrayList<RawBsonDocument>(this.options.getBatchSize());
                if (this.chunkQuery != null) break block28;
                sourceTotal = this.sourceCollection.countDocuments();
                cursor = this.sourceCollection.find().sort(Filters.eq((String)"$natural", (Object)1)).noCursorTimeout(true).iterator();
                ** GOTO lbl23
            }
            sourceTotal = this.sourceCollection.countDocuments(this.chunkQuery);
            if (this.options.isSkipChunkSyncIfMatchingCounts()) {
                if (sourceTotal > 0L) {
                    destCount = this.destCollection.countDocuments(this.chunkQuery);
                    if (sourceTotal == destCount) {
                        result.skippedCount = sourceTotal;
                        var18_7 = result;
                        return var18_7;
                    }
                } else {
                    var18_8 = result;
                    return var18_8;
                }
            }
            try {
                cursor = this.sourceCollection.find(this.chunkQuery).noCursorTimeout(true).iterator();
lbl23:
                // 2 sources

                last = start = System.currentTimeMillis();
                count = 0;
                while (cursor.hasNext()) {
                    doc = (RawBsonDocument)cursor.next();
                    ++result.sourceCount;
                    docsBuffer.add(doc);
                    if (docsBuffer.size() >= this.options.getBatchSize()) {
                        this.doInsert(docsBuffer, result);
                        docsBuffer.clear();
                        current = System.currentTimeMillis();
                        delta = (current - last) / 1000L;
                        if (delta >= 30L) {
                            percent = null;
                            if (sourceTotal > 0L) {
                                percent = result.sourceCount / sourceTotal;
                            }
                            ChunkCloneTask.logger.debug("{} - cloned {} / {} documents, {} %", new Object[]{this.ns, result.sourceCount, sourceTotal, percent});
                            last = current;
                        }
                    }
                    if (++count <= 1 || count % 1000000 != 0) continue;
                    ChunkCloneTask.logger.debug("{}: read {} docs for chunk clone, query: {}", new Object[]{this.ns, count, this.chunkQuery});
                }
                if (docsBuffer.size() > 0) {
                    this.doInsert(docsBuffer, result);
                    docsBuffer.clear();
                }
            }
            catch (MongoException me) {
                ChunkCloneTask.logger.error("fatal error cloning chunk, ns: {}", (Object)this.ns, (Object)me);
                result = null;
            }
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Exception var19_9) {}
        }
        return result;
    }

    protected void doInsert(List<RawBsonDocument> docsBuffer, ChunkCloneResult result) {
        boolean retry = false;
        try {
            this.destCollection.insertMany(docsBuffer, insertManyOptions);
            result.successCount += (long)docsBuffer.size();
        }
        catch (MongoBulkWriteException bwe) {
            logger.warn(String.format("%s - insertMany() error : %s", this.ns, bwe.getMessage()));
            List errors = bwe.getWriteErrors();
            int batchDuplicateKeyCount = this.getDuplicateKeyErrorCount(errors);
            int batchErrorCount = bwe.getWriteErrors().size() - batchDuplicateKeyCount;
            result.errorCount += (long)batchErrorCount;
            result.duplicateKeyCount += (long)batchDuplicateKeyCount;
            BulkWriteResult bulkWriteResult = bwe.getWriteResult();
            result.successCount += (long)bulkWriteResult.getInsertedCount();
        }
        catch (MongoException e) {
            logger.warn(String.format("%s - insertMany() unexpected error: %s", this.ns, e.getMessage()));
            retry = true;
        }
        if (retry) {
            int pos = 0;
            BsonValue prevId = null;
            BsonValue id = null;
            for (RawBsonDocument doc : docsBuffer) {
                try {
                    id = ChunkCloneTask.getId(doc);
                    this.destCollection.insertOne((Object)doc);
                    ++result.successCount;
                    prevId = id;
                }
                catch (MongoException me) {
                    logger.warn(String.format("%s - {_id: %s, prevId: %s, pos: %s} retry using insertOne() unexpected error: %s", this.ns, id, prevId, pos, me.getMessage()));
                    ++result.errorCount;
                }
                ++pos;
            }
        }
    }

    protected static BsonValue getId(RawBsonDocument doc) {
        BsonValue lastId = null;
        try {
            lastId = doc.get((Object)"_id");
        }
        catch (BsonSerializationException bsonSerializationException) {
            // empty catch block
        }
        return lastId;
    }

    private int getDuplicateKeyErrorCount(List<BulkWriteError> errors) {
        int count = 0;
        for (BulkWriteError bwe : errors) {
            if (bwe.getCode() == 11000) {
                ++count;
                continue;
            }
            logger.warn(String.format("%s - insertMany() error : %s", this.ns, bwe.getMessage()));
        }
        return count;
    }
}

