/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.model.Namespace;
import com.mongodb.mongosync.AbstractCollectionCloneWorker;
import com.mongodb.mongosync.MongoSyncOptions;
import com.mongodb.shardsync.ShardClient;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

public class CollectionCloneWorker
extends AbstractCollectionCloneWorker
implements Runnable {
    public CollectionCloneWorker(Namespace ns, ShardClient sourceShardClient, ShardClient destShardClient, MongoSyncOptions options) {
        super(ns, sourceShardClient, destShardClient, options);
    }

    @Override
    public void run() {
        long start;
        block14: {
            MongoCursor cursor = null;
            long last = start = System.currentTimeMillis();
            this.successCount = 0L;
            this.errorCount = 0L;
            try {
                try {
                    cursor = this.sourceCollection.find().sort(Filters.eq((String)"$natural", (Object)1)).noCursorTimeout(true).iterator();
                    Number total = this.getCount();
                    while (cursor.hasNext()) {
                        RawBsonDocument doc = (RawBsonDocument)cursor.next();
                        BsonValue id = CollectionCloneWorker.getId(doc);
                        if (id != null) {
                            this.writesBuffer.add(new InsertOneModel((Object)doc));
                            this.docsBuffer.add(doc);
                        } else {
                            logger.warn(String.format("%s - skipping insert, no _id could be read, lastId: %s", this.ns, this.lastId));
                            ++this.errorCount;
                        }
                        if (this.docsBuffer.size() >= this.options.getBatchSize()) {
                            this.doInsert();
                            this.writesBuffer.clear();
                            this.docsBuffer.clear();
                            long current = System.currentTimeMillis();
                            long delta = (current - last) / 1000L;
                            if (delta >= 30L) {
                                logger.debug(String.format("%s - cloned %s / %s documents, errorCount: %s, duplicateKeyCount: %s", this.ns, this.successCount, total, this.errorCount, this.duplicateKeyCount));
                                last = current;
                            }
                        }
                        this.lastId = id;
                    }
                    if (this.docsBuffer.size() > 0) {
                        this.doInsert();
                        this.writesBuffer.clear();
                        this.docsBuffer.clear();
                    }
                }
                catch (MongoException me) {
                    logger.error("fatal error cloning collection, ns: {}", (Object)this.ns, (Object)me);
                    if (cursor != null) {
                        cursor.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    cursor.close();
                }
                throw throwable;
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        logger.debug(String.format("%s - cloned %s documents, errorCount: %s, duplicateKeyCount: %s", this.ns, this.successCount, this.errorCount, this.duplicateKeyCount));
        logger.debug(String.format("Done cloning %s, %s documents in %f seconds", this.ns, this.successCount, dur));
    }

    @Override
    public void shutdown() {
    }
}

