/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.client.MongoCursor;
import com.mongodb.model.Namespace;
import com.mongodb.mongosync.AbstractCollectionCloneWorker;
import com.mongodb.mongosync.MongoSyncOptions;
import com.mongodb.shardsync.ShardClient;
import org.bson.BsonSerializationException;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.conversions.Bson;

public class DummyCloneWorker
extends AbstractCollectionCloneWorker
implements Runnable {
    private DocumentCodec codec = new DocumentCodec();

    public DummyCloneWorker(Namespace ns, ShardClient sourceShardClient, ShardClient destShardClient, MongoSyncOptions options) {
        super(ns, sourceShardClient, destShardClient, options);
    }

    @Override
    public void run() {
        long start;
        MongoCursor cursor = null;
        long last = start = System.currentTimeMillis();
        this.successCount = 0L;
        this.errorCount = 0L;
        try {
            cursor = this.sourceCollection.find().noCursorTimeout(true).hint((Bson)new Document("_id", (Object)1)).iterator();
            logger.debug(String.format("%s - starting", this.ns));
            while (cursor.hasNext()) {
                RawBsonDocument doc = (RawBsonDocument)cursor.next();
                BsonValue id = DummyCloneWorker.getId(doc);
                if (id != null) {
                    try {
                        Document document = (Document)doc.decode((Codec)this.codec);
                    }
                    catch (BsonSerializationException bse) {
                        logger.warn(String.format("%s - skipping corrupt doc, _id: %s", this.ns, id));
                        ++this.errorCount;
                    }
                    ++this.successCount;
                } else {
                    logger.warn(String.format("%s - skipping corrupt doc, no _id could be read, lastId: %s", this.ns, this.lastId));
                    ++this.errorCount;
                }
                this.lastId = id;
                if (this.successCount % 500000L != 0L) continue;
                long current = System.currentTimeMillis();
                long delta = (current - last) / 1000L;
                logger.debug(String.format("%s - checked %s documents, errorCount: %s", this.ns, this.successCount, this.errorCount));
                last = current;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        logger.debug(String.format("Done cloning %s, %s documents in %f seconds. errorCount: %s", this.ns, this.successCount, dur, this.errorCount));
    }

    @Override
    public void shutdown() {
    }
}

