/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.concurrent.ExecutionException;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

public class LookupTransformer {
    private MongoCollection<BsonDocument> coll;
    private String lookupValueKey;
    LoadingCache<ObjectId, BsonValue> cache;

    public LookupTransformer(MongoClient client, String dbName, String collName, String lookupValueKey) {
        this.lookupValueKey = lookupValueKey;
        MongoDatabase db = client.getDatabase(dbName);
        this.coll = db.getCollection(collName, BsonDocument.class);
        this.cache = CacheBuilder.newBuilder().maximumSize(1000000L).build((CacheLoader)new DbCacheLoader());
    }

    public BsonValue lookup(ObjectId id) throws ExecutionException {
        return (BsonValue)this.cache.get((Object)id);
    }

    public String getLookupValueKey() {
        return this.lookupValueKey;
    }

    public class DbCacheLoader
    extends CacheLoader<ObjectId, BsonValue> {
        public BsonValue load(ObjectId key) throws Exception {
            BsonDocument doc = (BsonDocument)LookupTransformer.this.coll.find(Filters.eq((String)"_id", (Object)key)).projection(Filters.eq((String)LookupTransformer.this.lookupValueKey, (Object)1)).first();
            if (doc != null) {
                return doc.get((Object)LookupTransformer.this.lookupValueKey);
            }
            return null;
        }
    }
}

