/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.model.Namespace;
import com.mongodb.shardsync.ShardClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MongoSyncOptions {
    private int threads = 4;
    private int batchSize = 5000;
    private int oplogBatchSize = 5000;
    private String sourceMongoUri;
    private String destMongoUri;
    private boolean dropDestDbs;
    private boolean cleanTimestampFiles;
    private boolean useMultiThreadedOplogTailWorkers = false;
    private boolean skipChunkSyncIfMatchingCounts = false;
    private boolean initialSyncOnly;
    private int oplogThreads = 4;
    private int oplogQueueSize = 50;
    private ShardClient sourceShardClient;
    private ShardClient destShardClient;
    private Set<Namespace> includedNamespaces = new HashSet<Namespace>();
    private Set<String> includedNamespaceStrings = new HashSet<String>();
    private Set<String> includedDatabases = new HashSet<String>();
    private Map<String, Set<String>> includedCollections = new HashMap<String, Set<String>>();
    private Set<Namespace> excludedNamespaces = new HashSet<Namespace>();
    private Set<String> excludedNamespaceStrings = new HashSet<String>();
    private Set<String> excludedDatabases = new HashSet<String>();
    private Set<String> shardList;
    private Map<String, String> transformersMap = new HashMap<String, String>();

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public String getSourceMongoUri() {
        return this.sourceMongoUri;
    }

    public void setSourceMongoUri(String sourceMongoUri) {
        this.sourceMongoUri = sourceMongoUri;
    }

    public String getDestMongoUri() {
        return this.destMongoUri;
    }

    public void setDestMongoUri(String destMongoUri) {
        this.destMongoUri = destMongoUri;
    }

    public boolean includeNamespace(String namespace) {
        boolean filtered;
        boolean bl = filtered = !this.includedNamespaceStrings.isEmpty();
        if (filtered) {
            return this.includedNamespaceStrings.contains(namespace);
        }
        return true;
    }

    public boolean includeCollection(String dbName, String collectionName) {
        boolean filtered;
        boolean bl = filtered = !this.includedCollections.isEmpty();
        if (filtered) {
            Set<String> colls = this.includedCollections.get(dbName);
            return colls.contains(collectionName);
        }
        return true;
    }

    public boolean includeDatabase(String dbName) {
        boolean filtered;
        boolean bl = filtered = !this.includedCollections.isEmpty();
        if (filtered) {
            return this.includedCollections.containsKey(dbName);
        }
        return true;
    }

    public void setIncludesExcludes(String[] includes, String[] excludes) {
        Namespace ns;
        String nsStr;
        int n;
        int n2;
        String[] stringArray;
        if (includes != null) {
            Collections.addAll(this.includedNamespaceStrings, includes);
            stringArray = includes;
            n2 = includes.length;
            n = 0;
            while (n < n2) {
                nsStr = stringArray[n];
                if (nsStr.contains(".")) {
                    ns = new Namespace(nsStr);
                    this.includedNamespaces.add(ns);
                    this.includedDatabases.add(ns.getDatabaseName());
                    Set<String> colls = this.includedCollections.get(ns.getDatabaseName());
                    if (colls == null) {
                        colls = new HashSet<String>();
                        this.includedCollections.put(ns.getDatabaseName(), colls);
                    }
                    colls.add(ns.getCollectionName());
                } else {
                    this.includedDatabases.add(nsStr);
                }
                ++n;
            }
        }
        if (excludes != null) {
            Collections.addAll(this.excludedNamespaceStrings, excludes);
            stringArray = excludes;
            n2 = excludes.length;
            n = 0;
            while (n < n2) {
                nsStr = stringArray[n];
                if (nsStr.contains(".")) {
                    ns = new Namespace(nsStr);
                    this.excludedNamespaces.add(ns);
                } else {
                    this.excludedDatabases.add(nsStr);
                }
                ++n;
            }
        }
    }

    public boolean excludeDb(String dbName) {
        return this.excludedDatabases.contains(dbName);
    }

    public boolean excludeNamespace(Namespace ns) {
        return this.excludedNamespaces.contains(ns);
    }

    public void setDropDestDbs(boolean dropDestDbs) {
        this.dropDestDbs = dropDestDbs;
    }

    public boolean isDropDestDbs() {
        return this.dropDestDbs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isCleanTimestampFiles() {
        return this.cleanTimestampFiles;
    }

    public void setCleanTimestampFiles(boolean cleanTimestampFiles) {
        this.cleanTimestampFiles = cleanTimestampFiles;
    }

    public boolean isUseMultiThreadedOplogTailWorkers() {
        return this.useMultiThreadedOplogTailWorkers;
    }

    public void setUseMultiThreadedOplogTailWorkers(boolean useMultiThreadedOplogTailWorkers) {
        this.useMultiThreadedOplogTailWorkers = useMultiThreadedOplogTailWorkers;
    }

    public int getOplogThreads() {
        return this.oplogThreads;
    }

    public void setOplogThreads(int oplogThreads) {
        this.oplogThreads = oplogThreads;
    }

    public int getOplogQueueSize() {
        return this.oplogQueueSize;
    }

    public void setOplogQueueSize(int oplogQueueSize) {
        this.oplogQueueSize = oplogQueueSize;
    }

    public Set<String> getIncludedNamespaceStrings() {
        return this.includedNamespaceStrings;
    }

    public Set<Namespace> getIncludedNamespaces() {
        return this.includedNamespaces;
    }

    public Set<Namespace> getExcludedNamespaces() {
        return this.excludedNamespaces;
    }

    public Set<String> getExcludedNamespaceStrings() {
        return this.excludedNamespaceStrings;
    }

    public Map<String, Set<String>> getIncludedCollections() {
        return this.includedCollections;
    }

    public void setOplogTransformers(String transformersStr) {
        if (transformersStr == null) {
            return;
        }
        String[] transformers = transformersStr.split(",");
        if (transformers != null) {
            String[] stringArray = transformers;
            int n = transformers.length;
            int n2 = 0;
            while (n2 < n) {
                String tranConfig = stringArray[n2];
                String[] parts = tranConfig.split("\\|");
                String namespace = parts[0];
                String lookupValueKey = parts[1];
                this.transformersMap.put(namespace, lookupValueKey);
                ++n2;
            }
        }
    }

    public Map<String, String> getTransformersMap() {
        return this.transformersMap;
    }

    public ShardClient getSourceShardClient() {
        return this.sourceShardClient;
    }

    public void setSourceShardClient(ShardClient sourceShardClient) {
        this.sourceShardClient = sourceShardClient;
    }

    public ShardClient getDestShardClient() {
        return this.destShardClient;
    }

    public void setDestShardClient(ShardClient destShardClient) {
        this.destShardClient = destShardClient;
    }

    public int getOplogBatchSize() {
        return this.oplogBatchSize;
    }

    public void setOplogBatchSize(int oplogBatchSize) {
        this.oplogBatchSize = oplogBatchSize;
    }

    public boolean isInitialSyncOnly() {
        return this.initialSyncOnly;
    }

    public void setInitialSyncOnly(boolean initialSyncOnly) {
        this.initialSyncOnly = initialSyncOnly;
    }

    public boolean isSkipChunkSyncIfMatchingCounts() {
        return this.skipChunkSyncIfMatchingCounts;
    }

    public void setSkipChunkSyncIfMatchingCounts(boolean skipChunkSyncIfMatchingCounts) {
        this.skipChunkSyncIfMatchingCounts = skipChunkSyncIfMatchingCounts;
    }

    public void setShardList(String shardListStr) {
        if (shardListStr != null) {
            String[] shardListArray = shardListStr.split(",");
            this.shardList = new HashSet<String>(Arrays.asList(shardListArray));
        }
    }

    public Set<String> getShardList() {
        return this.shardList;
    }
}

