/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class OplogBatch {
    private List<WriteModel<BsonDocument>> orderedWriteModels;
    private List<WriteModel<BsonDocument>> unorderedWriteModels;
    private Map<BsonValue, WriteModel<BsonDocument>> idsMap;

    public OplogBatch(int batchSize) {
        this.orderedWriteModels = new ArrayList<WriteModel<BsonDocument>>(batchSize);
        this.unorderedWriteModels = new ArrayList<WriteModel<BsonDocument>>(batchSize);
        this.idsMap = new HashMap<BsonValue, WriteModel<BsonDocument>>(batchSize);
    }

    public int size() {
        return this.orderedWriteModels.size() + this.unorderedWriteModels.size();
    }

    public void addWriteModel(WriteModel<BsonDocument> model, BsonValue id) {
        boolean existing = this.idsMap.containsKey(id);
        if (existing) {
            WriteModel<BsonDocument> lastElement = this.idsMap.get(id);
            if (lastElement != null) {
                this.unorderedWriteModels.remove(lastElement);
                this.orderedWriteModels.add(lastElement);
                this.idsMap.put(id, null);
            }
            this.orderedWriteModels.add(model);
            int index = this.orderedWriteModels.size() - 1;
        } else {
            this.unorderedWriteModels.add(model);
            int index = this.unorderedWriteModels.size() - 1;
            this.idsMap.put(id, model);
        }
    }

    public void removeWriteModel(WriteModel<BsonDocument> model, boolean ordered) {
        Object id = null;
        if (ordered) {
            this.orderedWriteModels.remove(model);
        } else {
            this.unorderedWriteModels.remove(model);
        }
    }

    public void clearUnordered() {
        this.unorderedWriteModels.clear();
    }

    public void clear() {
        this.unorderedWriteModels.clear();
        this.orderedWriteModels.clear();
        this.idsMap.clear();
    }

    public List<WriteModel<BsonDocument>> getOrderedWriteModels() {
        return this.orderedWriteModels;
    }

    public List<WriteModel<BsonDocument>> getUnorderedWriteModels() {
        return this.unorderedWriteModels;
    }
}

