/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.mongosync.BulkWriteOutput;
import com.mongodb.mongosync.OplogQueueEntry;
import com.mongodb.mongosync.TimestampFile;
import com.mongodb.shardsync.ShardClient;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogTailMonitor
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(OplogTailMonitor.class);
    private long duplicateKeyExceptionCount;
    private long deletedCount;
    private long modifiedCount;
    private long insertedCount;
    private long upsertedCount;
    BsonTimestamp latestTimestamp;
    private TimestampFile timestampFile;
    private ShardClient sourceShardClient;
    private String shardId;
    private Map<Integer, BlockingQueue<OplogQueueEntry>> childQueues;

    public OplogTailMonitor(TimestampFile timestampFile, ShardClient sourceShardClient, Map<Integer, BlockingQueue<OplogQueueEntry>> childQueues) {
        this.timestampFile = timestampFile;
        this.sourceShardClient = sourceShardClient;
        this.shardId = timestampFile.getShardId();
        this.childQueues = childQueues;
    }

    protected synchronized void setLatestTimestamp(BsonTimestamp ts) {
        this.latestTimestamp = ts;
    }

    protected synchronized void setLatestTimestamp(BsonDocument document) {
        this.latestTimestamp = document.getTimestamp((Object)"ts");
    }

    private void processLoop() {
        try {
            this.timestampFile.update(this.latestTimestamp);
        }
        catch (IOException e) {
            logger.error("error updating timestamp file", (Throwable)e);
        }
        BsonTimestamp sourceTs = this.sourceShardClient.getLatestOplogTimestamp(this.shardId);
        Integer lagSeconds = null;
        if (this.latestTimestamp != null) {
            lagSeconds = sourceTs.getTime() - this.latestTimestamp.getTime();
        }
        int queuedTasks = 0;
        if (this.childQueues != null) {
            for (Map.Entry<Integer, BlockingQueue<OplogQueueEntry>> entry : this.childQueues.entrySet()) {
                BlockingQueue<OplogQueueEntry> queue = entry.getValue();
                int queueSize = queue.size();
                logger.debug("{} - executor {} - queue size: {}", new Object[]{this.shardId, entry.getKey(), queueSize});
                queuedTasks += queueSize;
            }
            logger.debug("{} - lagSeconds: {}, inserted: {}, modified: {}, upserted: {}, deleted: {}, dupeKey: {}, queuedTasks: {}", new Object[]{this.shardId, lagSeconds, this.insertedCount, this.modifiedCount, this.upsertedCount, this.deletedCount, this.duplicateKeyExceptionCount, queuedTasks});
        } else {
            logger.debug("{} - lagSeconds: {}, inserted: {}, modified: {}, upserted: {}, deleted: {}, dupeKey: {}", new Object[]{this.shardId, lagSeconds, this.insertedCount, this.modifiedCount, this.upsertedCount, this.deletedCount, this.duplicateKeyExceptionCount});
        }
    }

    @Override
    public void run() {
        try {
            this.processLoop();
        }
        catch (Exception e) {
            logger.error("monitor error", (Throwable)e);
        }
    }

    public synchronized void updateStatus(BulkWriteOutput output) {
        this.duplicateKeyExceptionCount += (long)output.getDuplicateKeyExceptionCount();
        this.deletedCount += (long)output.getDeletedCount();
        this.modifiedCount += (long)output.getModifiedCount();
        this.insertedCount += (long)output.getInsertedCount();
        this.upsertedCount += (long)output.getUpsertedCount();
    }
}

