/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.model.Namespace;
import com.mongodb.mongosync.AbstractCollectionCloneWorker;
import com.mongodb.mongosync.ChunkCloneResult;
import com.mongodb.mongosync.ChunkCloneTask;
import com.mongodb.mongosync.MongoSyncOptions;
import com.mongodb.shardsync.ShardClient;
import com.mongodb.util.BlockWhenQueueFull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ShardedCollectionCloneWorker
extends AbstractCollectionCloneWorker
implements Runnable {
    protected ThreadPoolExecutor executor = null;
    private BlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(1000000);
    List<Future<ChunkCloneResult>> chunkCloneResults;

    public ShardedCollectionCloneWorker(ShardClient sourceShardClient, ShardClient destShardClient, MongoSyncOptions options) {
        super(null, sourceShardClient, destShardClient, options);
        this.executor = new ThreadPoolExecutor(options.getThreads(), options.getThreads(), 30L, TimeUnit.SECONDS, this.workQueue, new BlockWhenQueueFull());
    }

    private boolean excludeDbCheck(String dbName) {
        return ShardClient.excludedSystemDbs.contains(dbName) || this.options.excludeDb(dbName);
    }

    @Override
    public void shutdown() {
        logger.debug("ShardedCollectionCloneWorker starting shutdown");
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(999L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            logger.warn("ShardedCollectionCloneWorker interrupted");
            Thread.currentThread().interrupt();
        }
        logger.debug("ShardedCollectionCloneWorker shutdown complete");
    }

    @Override
    public void run() {
        MongoCollection<Document> chunksColl = this.destShardClient.getChunksCollection();
        Set<String> includedNamespaces = this.options.getIncludedNamespaceStrings();
        Set<String> excludedNamespaces = this.options.getExcludedNamespaceStrings();
        this.chunkCloneResults = new ArrayList<Future<ChunkCloneResult>>();
        MongoIterable<String> dbNames = this.sourceShardClient.listDatabaseNames();
        for (String dbName : dbNames) {
            if (this.excludeDbCheck(dbName) || !this.options.includeDatabase(dbName)) continue;
            if (this.options.isDropDestDbs()) {
                this.destShardClient.dropDatabase(dbName);
            }
            ArrayList collectionNames = new ArrayList();
            this.sourceShardClient.listCollectionNames(dbName).into(collectionNames);
            logger.debug("{}: collection count (before filtering): {}", (Object)dbName, (Object)collectionNames.size());
            for (String collectionName : collectionNames) {
                Namespace ns;
                if (collectionName.equals("system.profile") || collectionName.equals("system.indexes") || !this.options.includeCollection(dbName, collectionName) || this.options.excludeNamespace(ns = new Namespace(dbName, collectionName))) continue;
                this.cloneCollection(ns);
            }
        }
        boolean i = false;
        for (Future<ChunkCloneResult> future : this.chunkCloneResults) {
            try {
                ChunkCloneResult chunkCloneResult = future.get();
                logger.debug("chunk clone complete: {}", (Object)chunkCloneResult);
            }
            catch (InterruptedException e) {
                logger.error("interruped getting chunk clone result", (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.error("error getting chunk clone result", (Throwable)e);
            }
        }
        this.shutdown();
        logger.debug("ShardedCollectionCloneWorker complete!");
    }

    private void cloneCollection(Namespace ns) {
        this.shardCollection = this.sourceShardClient.getCollectionsMap().get(ns.getNamespace());
        if (this.shardCollection == null) {
            ChunkCloneTask task = new ChunkCloneTask(ns, this.sourceShardClient, this.destShardClient, null, this.options);
            this.chunkCloneResults.add(this.executor.submit(task));
        } else {
            Document shardKeysDoc = (Document)this.shardCollection.get((Object)"key");
            Set shardKeys = shardKeysDoc.keySet();
            MongoCollection<Document> chunksCollection = this.sourceShardClient.getChunksCollection();
            FindIterable sourceChunks = chunksCollection.find(Filters.eq((String)"ns", (Object)ns.getNamespace())).sort(Sorts.ascending((String[])new String[]{"min"}));
            int i = 0;
            for (Document sourceChunk : sourceChunks) {
                String id = sourceChunk.getString((Object)"_id");
                Document min = (Document)sourceChunk.get((Object)"min");
                Document max = (Document)sourceChunk.get((Object)"max");
                Bson chunkQuery = null;
                if (shardKeys.size() > 1) {
                    ArrayList<Bson> filters = new ArrayList<Bson>(shardKeys.size());
                    for (String key : shardKeys) {
                        filters.add(Filters.and((Bson[])new Bson[]{Filters.gte((String)key, (Object)min.get((Object)key)), Filters.lt((String)key, (Object)max.get((Object)key))}));
                    }
                    chunkQuery = Filters.and(filters);
                } else {
                    String key = (String)shardKeys.iterator().next();
                    chunkQuery = Filters.and((Bson[])new Bson[]{Filters.gte((String)key, (Object)min.get((Object)key)), Filters.lt((String)key, (Object)max.get((Object)key))});
                }
                ChunkCloneTask task = new ChunkCloneTask(ns, this.sourceShardClient, this.destShardClient, chunkQuery, this.options);
                this.chunkCloneResults.add(this.executor.submit(task));
                ++i;
            }
            logger.debug("{}: {} chunks processed / tasks submitted for chunk clone", (Object)ns, (Object)i);
        }
    }
}

