/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosync;

import com.mongodb.model.ShardTimestamp;
import com.mongodb.util.AtomicFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bson.BsonTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampFile {
    protected static final Logger logger = LoggerFactory.getLogger(TimestampFile.class);
    private String shardId;
    private File tsFile;
    BsonTimestamp lastTs;

    public TimestampFile(String shardId) {
        this.shardId = shardId;
        String fileName = String.valueOf(shardId) + ".timestamp";
        this.tsFile = new File(fileName);
    }

    public ShardTimestamp getShardTimestamp() throws IOException {
        BufferedReader br = null;
        String shardName = null;
        String tsStr = null;
        try {
            br = new BufferedReader(new FileReader(this.tsFile));
            shardName = br.readLine();
            tsStr = br.readLine();
        }
        finally {
            br.close();
        }
        if (shardName == null || tsStr == null) {
            throw new IOException("Invalid or empty timestamp file");
        }
        long tsLong = Long.parseLong(tsStr);
        BsonTimestamp ts = new BsonTimestamp(tsLong);
        return new ShardTimestamp(shardName, ts);
    }

    public boolean exists() {
        return this.tsFile.exists();
    }

    public String toString() {
        return this.tsFile.getName();
    }

    public void update(ShardTimestamp shardTimestamp) throws IOException {
        this.update(shardTimestamp.getTimestamp());
    }

    public void update(BsonTimestamp ts) throws IOException {
        if (ts == null) {
            return;
        }
        if (!this.tsFile.exists()) {
            boolean bl = this.tsFile.createNewFile();
        }
        Path tsFilePath = Paths.get(this.tsFile.getAbsolutePath(), new String[0]);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (AtomicFileWriter cw = new AtomicFileWriter(tsFilePath);){
                try {
                    cw.write(this.shardId);
                    cw.write(10);
                    cw.write(String.valueOf(ts.getValue()));
                    cw.commit();
                }
                finally {
                    cw.abort();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            logger.error(String.format("timestamp file update error: %s", this.tsFile), (Throwable)ioe);
        }
        this.lastTs = ts;
    }

    public String getShardId() {
        return this.shardId;
    }
}

