/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.okhttp.digest.fromhttpclient;

import com.mongodb.okhttp.digest.fromhttpclient.NameValuePair;

public class BasicHeaderValueFormatter {
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();

    public StringBuilder formatNameValuePair(StringBuilder charBuffer, NameValuePair nvp, boolean quote) {
        charBuffer.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            charBuffer.append('=');
            this.doFormatValue(charBuffer, value, quote);
        }
        return charBuffer;
    }

    protected void doFormatValue(StringBuilder buffer, String value, boolean quote) {
        int i;
        boolean quoteFlag = quote;
        if (!quote) {
            i = 0;
            while (i < value.length() && !quoteFlag) {
                quoteFlag = this.isSeparator(value.charAt(i));
                ++i;
            }
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
        i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
            ++i;
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
    }

    protected boolean isSeparator(char ch) {
        return " ;,:@()<>\\\"/[]?={}\t".indexOf(ch) >= 0;
    }

    protected boolean isUnsafe(char ch) {
        return "\"\\".indexOf(ch) >= 0;
    }
}

