/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.oplog;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.shardsync.ShardClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogApplier {
    private static Logger logger = LoggerFactory.getLogger(OplogApplier.class);
    private static Options options;
    private static CommandLine line;
    private static final String SOURCE_URI = "source";
    private static final String DEST_URI = "dest";
    private static final String SOURCE_SHARD = "sourceShard";
    private static final String DEST_SHARD = "destShard";
    private static final String TIMESTAMP = "ts";
    private String sourceClusterUri;
    private String destClusterUri;
    private String sourceShardId;
    private String destShardId;
    private File sourceFile;
    private BsonTimestamp timestamp;
    private ShardClient sourceShardClient;
    private ShardClient destShardClient;
    private Map<String, String> sourceToDestShardMap = new HashMap<String, String>();

    public void run() {
        logger.debug("OplogApplier starting");
        this.sourceToDestShardMap.put(this.sourceShardId, this.destShardId);
        this.sourceShardClient = new ShardClient(SOURCE_URI, this.sourceClusterUri, this.sourceToDestShardMap.keySet());
        this.destShardClient = new ShardClient(DEST_URI, this.destClusterUri, this.sourceToDestShardMap.values());
        this.sourceShardClient.init();
        this.destShardClient.init();
        this.sourceShardClient.populateShardMongoClients();
        this.destShardClient.populateShardMongoClients();
        MongoClient sourceClient = this.sourceShardClient.getShardMongoClient(this.sourceShardId);
        MongoClient destClient = this.destShardClient.getShardMongoClient(this.destShardId);
        MongoDatabase local = sourceClient.getDatabase("local");
        MongoCollection oplog = local.getCollection("oplog.rs", Document.class);
        ArrayList<Document> opsList = new ArrayList<Document>(1);
        MongoCursor cursor = null;
        Bson query = Filters.and((Bson[])new Bson[]{Filters.gte((String)TIMESTAMP, (Object)this.timestamp), Filters.ne((String)"op", (Object)"n")});
        long start = System.currentTimeMillis();
        long count = 0L;
        long errorCount = 0L;
        try {
            for (Document doc : oplog.find(query).sort((Bson)new Document("$natural", (Object)1)).noCursorTimeout(true)) {
                String ns = doc.getString((Object)"ns");
                if (ns.startsWith("config.")) continue;
                String dbName = StringUtils.substringBefore((String)ns, (String)".");
                doc.remove((Object)"ui");
                opsList.clear();
                opsList.add(doc);
                Document applyOps = new Document("applyOps", opsList);
                try {
                    Document document = destClient.getDatabase(dbName).runCommand((Bson)applyOps);
                }
                catch (MongoCommandException mce) {
                    ++errorCount;
                    logger.error("error applying: " + mce.getMessage());
                    logger.debug("op: " + doc);
                }
                if (++count % 100L != 0L) continue;
                logger.debug(String.format("Executed %s applyOps, errorCount: %s", count, errorCount));
            }
        }
        finally {
            cursor.close();
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        logger.debug(String.format("Executed %s applyOps in %f seconds, errorCount: %s", count, dur, errorCount));
    }

    public void runFile() throws FileNotFoundException {
        long errorCount;
        long count;
        long start;
        block14: {
            logger.debug("OplogApplier starting");
            this.destShardClient = new ShardClient(DEST_URI, this.destClusterUri, this.sourceToDestShardMap.values());
            this.destShardClient.init();
            this.destShardClient.populateShardMongoClients();
            MongoClient destClient = this.destShardClient.getShardMongoClient(this.destShardId);
            start = System.currentTimeMillis();
            count = 0L;
            errorCount = 0L;
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.sourceFile));
            ArrayList<BSONObject> opsList = new ArrayList<BSONObject>(1);
            BasicBSONDecoder decoder = new BasicBSONDecoder();
            try {
                try {
                    while (((InputStream)inputStream).available() > 0) {
                        BSONObject obj = decoder.readObject((InputStream)inputStream);
                        if (obj == null) break;
                        String ns = (String)obj.get("ns");
                        if (ns.startsWith("config.") || ns.contains(".tmp.")) continue;
                        String dbName = StringUtils.substringBefore((String)ns, (String)".");
                        obj.removeField("ui");
                        opsList.clear();
                        opsList.add(obj);
                        Document applyOps = new Document("applyOps", opsList);
                        try {
                            Document result = destClient.getDatabase(dbName).runCommand((Bson)applyOps);
                            logger.debug("result: " + result);
                        }
                        catch (MongoCommandException mce) {
                            ++errorCount;
                            logger.error("error applying: " + mce.getMessage());
                            logger.debug("op: " + obj);
                        }
                        if (++count % 100L != 0L) continue;
                        logger.debug(String.format("Executed %s applyOps, errorCount: %s", count, errorCount));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.err.println(String.format("%s objects read", count));
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        logger.debug(String.format("Executed %s applyOps in %f seconds, errorCount: %s", count, dur, errorCount));
    }

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"Configuration properties file");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"source shard id");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)SOURCE_SHARD);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"dest shard id");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)DEST_SHARD);
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"oplog timestamp <time>,<increment>");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)TIMESTAMP);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"source file");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"sourceFile");
        options.addOption(OptionBuilder.create((String)"f"));
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                OplogApplier.printHelpAndExit();
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            OplogApplier.printHelpAndExit();
        }
        catch (Exception e) {
            e.printStackTrace();
            OplogApplier.printHelpAndExit();
        }
        return line;
    }

    private static Properties readProperties() {
        Properties prop = new Properties();
        File propsFile = null;
        if (line.hasOption("c")) {
            propsFile = new File(line.getOptionValue("c"));
        } else {
            propsFile = new File("shard-sync.properties");
            if (!propsFile.exists()) {
                logger.warn("Default config file shard-sync.properties not found, using command line options only");
                return prop;
            }
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream input = new FileInputStream(propsFile);){
                prop.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            logger.error("Error loading properties file: " + propsFile, (Throwable)ioe);
        }
        return prop;
    }

    private static void printHelpAndExit() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("logParser", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String sourceFileName;
        CommandLine line = OplogApplier.initializeAndParseCommandLineOptions(args);
        Properties configFileProps = OplogApplier.readProperties();
        OplogApplier oplog = new OplogApplier();
        oplog.setSourceClusterUri(configFileProps.getProperty(SOURCE_URI));
        oplog.setDestClusterUri(configFileProps.getProperty(DEST_URI));
        oplog.setSourceShardId(line.getOptionValue(SOURCE_SHARD));
        oplog.setDestShardId(line.getOptionValue(DEST_SHARD));
        String timestamp = line.getOptionValue(TIMESTAMP);
        if (timestamp != null) {
            String[] tsParts = timestamp.split(",");
            int time = Integer.parseInt(tsParts[0]);
            int inc = Integer.parseInt(tsParts[1]);
            oplog.setTimestamp(new BsonTimestamp(time, inc));
        }
        if ((sourceFileName = line.getOptionValue("sourceFile")) != null) {
            oplog.setSourceFile(new File(sourceFileName));
            oplog.runFile();
        } else {
            oplog.run();
        }
    }

    public String getSourceClusterUri() {
        return this.sourceClusterUri;
    }

    public void setSourceClusterUri(String sourceClusterUri) {
        this.sourceClusterUri = sourceClusterUri;
    }

    public String getDestClusterUri() {
        return this.destClusterUri;
    }

    public void setDestClusterUri(String destClusterUri) {
        this.destClusterUri = destClusterUri;
    }

    public void setSourceShardId(String sourceShardId) {
        this.sourceShardId = sourceShardId;
    }

    public void setDestShardId(String destShardId) {
        this.destShardId = destShardId;
    }

    public void setTimestamp(BsonTimestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }
}

