/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.oplog;

import com.mongodb.ConnectionString;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.WriteModel;
import com.mongodb.model.Namespace;
import com.mongodb.mongosync.ApplyOperationsHelper;
import com.mongodb.mongosync.BulkWriteOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bson.BsonDocument;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogReaderWriter {
    private static Logger logger = LoggerFactory.getLogger(OplogReaderWriter.class);
    private static final BulkWriteOptions orderedBulkWriteOptions = new BulkWriteOptions();
    private static Options options;
    private static final int BATCH_SIZE = 1000;
    private static final String SOURCE_URI = "source";
    private static final String DEST_URI = "dest";
    private String sourceUri;
    private String destUri;
    private MongoClient sourceClient;
    private MongoClient destClient;
    BulkWriteOutput results = new BulkWriteOutput();

    public OplogReaderWriter(String sourceUri, String destUri) {
        this.sourceUri = sourceUri;
        this.destUri = destUri;
    }

    public void run() {
        ConnectionString sourceCs = new ConnectionString(this.sourceUri);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(sourceCs).uuidRepresentation(UuidRepresentation.STANDARD).build();
        this.sourceClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
        ConnectionString destCs = new ConnectionString(this.destUri);
        MongoClientSettings destMongoClientSettings = MongoClientSettings.builder().applyConnectionString(destCs).uuidRepresentation(UuidRepresentation.STANDARD).build();
        this.destClient = MongoClients.create((MongoClientSettings)destMongoClientSettings);
        MongoDatabase db = this.sourceClient.getDatabase("urban");
        MongoCollection oplog = db.getCollection("oplog", BsonDocument.class);
        MongoCursor cursor = null;
        Bson query = Filters.and((Bson[])new Bson[]{Filters.ne((String)"op", (Object)"n")});
        HashMap<Namespace, ArrayList<WriteModel<BsonDocument>>> writeModelsMap = new HashMap<Namespace, ArrayList<WriteModel<BsonDocument>>>();
        try {
            for (BsonDocument doc : oplog.find(query).noCursorTimeout(true)) {
                WriteModel<BsonDocument> model;
                String nsString;
                Namespace ns;
                String op = doc.getString((Object)"op").getValue();
                if (op.equals("n") || op.equals("c") || (ns = new Namespace(nsString = doc.getString((Object)"ns").getValue())).getDatabaseName().equals("config") || ns.getDatabaseName().equals("admin")) continue;
                ArrayList<WriteModel<BsonDocument>> writeModels = (ArrayList<WriteModel<BsonDocument>>)writeModelsMap.get(ns);
                if (writeModels == null) {
                    writeModels = new ArrayList<WriteModel<BsonDocument>>(1000);
                    writeModelsMap.put(ns, writeModels);
                }
                if ((model = ApplyOperationsHelper.getWriteModelForOperation(doc, false)) != null) {
                    writeModels.add(model);
                    if (writeModels.size() < 1000) continue;
                    this.flush(ns, writeModels);
                    continue;
                }
                logger.warn("ignoring oplog entry. could not convert the document to model. Given document is {}", (Object)doc.toJson());
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void flush(Namespace ns, List<WriteModel<BsonDocument>> writeModels) {
        block5: {
            collection = this.destClient.getDatabase(ns.getDatabaseName()).getCollection(ns.getCollectionName(), BsonDocument.class);
            bulkWriteResult = null;
            try {
                bulkWriteResult = collection.bulkWrite(writeModels, OplogReaderWriter.orderedBulkWriteOptions);
                writeModels.clear();
                this.results.increment(bulkWriteResult);
                OplogReaderWriter.logger.debug(this.results.toString());
            }
            catch (MongoBulkWriteException err) {
                errors = err.getWriteErrors();
                bulkWriteResult = err.getWriteResult();
                if (errors.size() == writeModels.size()) {
                    OplogReaderWriter.logger.error("{} bulk write errors, all {} operations failed: {}", (Throwable)err);
                }
                ** for (bwe : errors)
            }
lbl-1000:
            // 1 sources

            {
                index = bwe.getIndex();
                writeModels.remove(index);
                continue;
            }
lbl20:
            // 1 sources

            this.flush(ns, writeModels);
            break block5;
            catch (Exception ex) {
                OplogReaderWriter.logger.error("{} unknown error: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"source cluster mongo uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)SOURCE_URI);
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"destination cluster mongo uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)DEST_URI);
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"d"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                OplogReaderWriter.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            OplogReaderWriter.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            OplogReaderWriter.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("logParser", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = OplogReaderWriter.initializeAndParseCommandLineOptions(args);
        String sourceUri = line.getOptionValue("s");
        String destUri = line.getOptionValue("d");
        OplogReaderWriter op = new OplogReaderWriter(sourceUri, destUri);
        op.run();
    }
}

