/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.oplog;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.concurrent.ThreadPoolExecutor;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogTailThread {
    protected static final Logger logger = LoggerFactory.getLogger(OplogTailThread.class);
    private Object lastTimestamp;
    protected long reportInterval = 1000L;
    private boolean killMe;
    private MongoClient mongoClient;
    private MongoDatabase local;
    private MongoCollection<Document> oplog;
    ThreadPoolExecutor pool;

    public OplogTailThread() {
        ConnectionString connectionString = new ConnectionString("mongodb://localhost:27017/test?minPoolSize=10");
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
        this.local = mongoClient.getDatabase("local");
        this.oplog = this.local.getCollection("oplog.rs");
    }

    private void getLastOplogTimestamp() {
        System.out.println("start");
        Document d = (Document)this.oplog.find().projection(Filters.eq((String)"ts", (Object)1)).sort(Filters.eq((String)"$natural", (Object)-1)).first();
        System.out.println(d);
        System.out.println("done");
    }

    public void run() {
        this.getLastOplogTimestamp();
        long lastWrite = 0L;
        long startTime = System.currentTimeMillis();
        long lastOutput = System.currentTimeMillis();
        try {
            while (true) {
                Thread.yield();
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    void report(String collectionName, long count, long skips, long duration) {
        double brate = (double)count / ((double)duration / 1000.0);
        logger.debug(String.valueOf(collectionName) + ": " + count + " records, " + brate + " req/sec, " + skips + " skips, " + this.pool + " tasks");
    }
}

