/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.oplog;

import com.mongodb.model.Namespace;
import com.mongodb.model.OplogOpType;
import com.mongodb.model.OplogSummary;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bson.RawBsonDocument;

public class OplogUtil {
    private static final Set<String> databasesBlacklist = new HashSet<String>(Arrays.asList("system", "local", "config", "admin"));

    public static OplogSummary getOplogSummaryFromOplogEntry(RawBsonDocument oplogEntry) {
        String opTypeCode = oplogEntry.getString((Object)"op").getValue();
        OplogOpType opType = OplogOpType.fromCode(opTypeCode);
        String nsStr = oplogEntry.getString((Object)"ns").getValue();
        Namespace ns = new Namespace(nsStr);
        if (databasesBlacklist.contains(ns.getDatabaseName())) {
            return new OplogSummary(ns, null, opType);
        }
        Object id = null;
        switch (opType) {
            case INSERT: 
            case DELETE: {
                id = OplogUtil.getIdFromInsertOrDeleteOplogEntry(oplogEntry);
                return new OplogSummary(ns, id, opType);
            }
            case UPDATE: {
                id = OplogUtil.getIdFromUpdateOplogEntry(oplogEntry);
                return new OplogSummary(ns, id, opType);
            }
        }
        return new OplogSummary(ns, null, opType);
    }

    public static Object getIdFromInsertOrDeleteOplogEntry(RawBsonDocument oplogEntry) {
        RawBsonDocument o = (RawBsonDocument)oplogEntry.get((Object)"o");
        return o.get((Object)"_id");
    }

    public static Object getIdFromUpdateOplogEntry(RawBsonDocument oplogEntry) {
        RawBsonDocument o2 = (RawBsonDocument)oplogEntry.get((Object)"o2");
        return o2.get((Object)"_id");
    }
}

