/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rollback;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;

public class RollbackMerge {
    private final BasicBSONEncoder encoder = new BasicBSONEncoder();

    public void filterFile(String filename) throws FileNotFoundException {
        int written;
        int count;
        block16: {
            File file = new File(filename);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            File outputFile = new File(String.valueOf(filename) + ".FILTERED");
            FileOutputStream fos = null;
            BasicBSONDecoder decoder = new BasicBSONDecoder();
            count = 0;
            written = 0;
            try {
                try {
                    fos = new FileOutputStream(outputFile);
                    FileChannel channel = fos.getChannel();
                    while (((InputStream)inputStream).available() > 0) {
                        BSONObject obj = decoder.readObject((InputStream)inputStream);
                        if (obj != null) {
                            BSONObject raw = (BSONObject)obj.get("rawop");
                            BSONObject header = (BSONObject)raw.get("header");
                            if (header != null) {
                                Integer opcode = (Integer)header.get("opcode");
                                if (opcode.equals(2004)) {
                                    ByteBuffer buffer = ByteBuffer.wrap(this.encoder.encode(obj));
                                    channel.write(buffer);
                                    ++written;
                                } else {
                                    System.out.println(opcode);
                                }
                            }
                            ++count;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.err.println(String.format("%s objects read, %s filtered objects written", count, written));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Expected <bson filename> argument");
        }
        String filename = args[0];
        RollbackMerge filter = new RollbackMerge();
        filter.filterFile(filename);
    }
}

