/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.schema;

import com.mongodb.schema.SchemaAnalyzer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.BsonType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpClassWriter {
    private static Logger logger = LoggerFactory.getLogger(SchemaAnalyzer.class);
    private File outputFile;
    private PrintWriter writer;
    private String className;

    public CSharpClassWriter(String collectionName) throws IOException {
        this.className = String.valueOf(collectionName.substring(0, 1).toUpperCase()) + collectionName.substring(1);
        this.outputFile = new File(String.valueOf(this.className) + ".cs");
        this.writer = new PrintWriter(new FileWriter(this.outputFile));
    }

    public void writeClass(LinkedHashMap<String, BsonType> keyTypeMap) {
        this.writer.println(String.format("public class %s {", this.className));
        for (Map.Entry<String, BsonType> entry : keyTypeMap.entrySet()) {
            String fieldName = entry.getKey();
            String csharpType = this.getType(entry.getValue());
            this.writer.println(String.format("    public %s %s { get; set; }", csharpType, fieldName));
        }
        this.writer.println("}");
        this.writer.flush();
        this.writer.close();
        logger.debug(String.format("Write class file %s", this.outputFile.getAbsolutePath()));
    }

    private String getType(BsonType value) {
        switch (value) {
            case OBJECT_ID: {
                return "ObjectId";
            }
            case STRING: {
                return "string";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE_TIME: {
                return "DateTime";
            }
            case BOOLEAN: {
                return "bool";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "long";
            }
            case BINARY: {
                return "byte[]";
            }
        }
        return "string";
    }
}

