/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.schema;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.schema.CSharpClassWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="schemaAnalyzer", mixinStandardHelpOptions=true, version={"schemaAnalyzer 0.1"})
public class SchemaAnalyzer
implements Callable<Integer> {
    private static Logger logger = LoggerFactory.getLogger(SchemaAnalyzer.class);
    private Set<String> dbIgnoreList = new HashSet<String>(Arrays.asList("system", "local", "config", "admin"));
    @CommandLine.Option(names={"--uri"}, description={"mongodb uri connection string"}, required=true)
    private String uri;
    @CommandLine.Option(names={"--list"}, description={"list dbs/collections and counts"}, required=false)
    private boolean list;
    @CommandLine.Option(names={"--ns"}, description={"namespace (e.g. <db_name>.<collection_name> )"}, required=false)
    private String namespace;
    @CommandLine.Option(names={"--limit"}, description={"limit number of documents to analyze (default all documents)"}, required=false)
    private Integer limit;
    LinkedHashMap<String, BsonType> keyTypeMap = null;
    MongoClient mongoClient;

    private void connect() {
        ConnectionString connectionString = new ConnectionString(this.uri);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        this.mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    private void list() {
        Document listDatabases = new Document("listDatabases", (Object)1);
        Document dbListResult = this.mongoClient.getDatabase("admin").runCommand((Bson)listDatabases);
        List databasesList = dbListResult.getList((Object)"databases", Document.class);
        System.out.println(String.format("%-40s %-20s", "Namespace", "Count"));
        System.out.println(String.format("%-40s %-20s", "----------------------------------------", "--------------------"));
        for (Document dbInfo : databasesList) {
            String dbName = dbInfo.getString((Object)"name");
            if (this.dbIgnoreList.contains(dbName)) continue;
            MongoDatabase db = this.mongoClient.getDatabase(dbName);
            for (Document collectionInfo : db.listCollections()) {
                String collectionName = collectionInfo.getString((Object)"name");
                String ns = String.valueOf(dbName) + "." + collectionName;
                MongoCollection coll = db.getCollection(collectionName);
                long count = coll.estimatedDocumentCount();
                System.out.println(String.format("%-40s %,20d", ns, count));
            }
        }
    }

    private void analyze() throws IOException {
        String dbName = StringUtils.substringBefore((String)this.namespace, (String)".");
        String collectionName = StringUtils.substringAfter((String)this.namespace, (String)".");
        MongoDatabase db = this.mongoClient.getDatabase(dbName);
        this.mongoClient.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
        MongoCursor cursor = null;
        long start = System.currentTimeMillis();
        long count = 0L;
        try {
            MongoCollection mongoCollection = db.getCollection(collectionName, BsonDocument.class);
            long totalDocs = mongoCollection.estimatedDocumentCount();
            logger.debug(String.format("Total documents for %s: %s", this.namespace, totalDocs));
            cursor = this.limit != null ? mongoCollection.find().limit(this.limit.intValue()).iterator() : mongoCollection.find().iterator();
            this.keyTypeMap = new LinkedHashMap();
            Set keys = null;
            Object lastKeys = null;
            BsonDocument doc = null;
            while (cursor.hasNext()) {
                doc = (BsonDocument)cursor.next();
                keys = doc.keySet();
                boolean sameKeysAsLast = keys.equals(lastKeys);
                if (!sameKeysAsLast) {
                    for (String key : keys) {
                        BsonValue val = doc.get((Object)key);
                        BsonType type = val.getBsonType();
                        this.keyTypeMap.put(key, type);
                    }
                }
                if (++count % 100000L != 0L) continue;
                double complete = (double)(count / totalDocs) * 100.0;
                logger.debug(String.format("%s / %s  (%f)", count, totalDocs, complete));
            }
        }
        finally {
            cursor.close();
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        logger.debug(String.format("\nDone dumping %s.%s, %s documents in %f seconds", dbName, collectionName, count, dur));
        CSharpClassWriter classWriter = new CSharpClassWriter(collectionName);
        classWriter.writeClass(this.keyTypeMap);
    }

    @Override
    public Integer call() throws Exception {
        this.connect();
        if (this.list) {
            this.list();
        } else {
            this.analyze();
        }
        return 0;
    }

    public static void main(String ... args) {
        int exitCode = new CommandLine((Object)new SchemaAnalyzer()).execute(args);
        System.exit(exitCode);
    }
}

