/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.shardsync;

import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.model.Namespace;
import com.mongodb.shardsync.ShardClient;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupOrphaned {
    private static Logger logger = LoggerFactory.getLogger(CleanupOrphaned.class);
    private ShardClient shardClient;
    private Set<Namespace> includeNamespaces;

    public CleanupOrphaned(ShardClient shardClient, Set<Namespace> includeNamespaces) {
        this.shardClient = shardClient;
        this.includeNamespaces = includeNamespaces;
    }

    public void cleanupOrphans(Long cleanupOrphansSleepMillis) {
        for (Map.Entry<String, MongoClient> entry : this.shardClient.getShardMongoClients().entrySet()) {
            MongoClient client = entry.getValue();
            this.cleanupOrphans(client, entry.getKey(), cleanupOrphansSleepMillis);
        }
        logger.debug("cleanupOrphans complete");
    }

    private void cleanupOrphans(MongoClient client, String name, Long cleanupOrphansSleepMillis) {
        try {
            MongoDatabase db = client.getDatabase("admin");
            for (Document coll : this.shardClient.getCollectionsMap().values()) {
                if (coll.get((Object)"_id").equals("config.system.sessions")) continue;
                String nsStr = (String)coll.get((Object)"_id");
                Namespace ns = new Namespace(nsStr);
                if (!this.includeNamespaces.isEmpty() && !this.includeNamespaces.contains(ns)) continue;
                Document command = new Document("cleanupOrphaned", (Object)ns.getNamespace());
                Document result = null;
                Document nextKey = null;
                logger.debug(String.format("cleanupOrphans: %s - %s", name, coll.get((Object)"_id")));
                do {
                    Double ok;
                    if (nextKey != null) {
                        command.append("startingFromKey", nextKey);
                    }
                    if (!(ok = (result = db.runCommand((Bson)command)).getDouble((Object)"ok")).equals(1.0)) {
                        logger.warn("Cleanup failed: " + result);
                    }
                    nextKey = (Document)result.get((Object)"stoppedAtKey");
                    if (cleanupOrphansSleepMillis == null) continue;
                    try {
                        Thread.sleep(cleanupOrphansSleepMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (nextKey != null);
            }
        }
        catch (MongoException me) {
            logger.error("cleanup orphaned error", (Throwable)me);
        }
    }
}

