/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.shardsync;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.dns.DefaultDnsResolver;
import com.mongodb.model.IndexSpec;
import com.mongodb.model.Mongos;
import com.mongodb.model.Namespace;
import com.mongodb.model.Shard;
import com.mongodb.model.ShardTimestamp;
import com.mongodb.util.MaskUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonDocument;
import org.bson.BsonMaxKey;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.bson.types.MaxKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardClient {
    private static Logger logger = LoggerFactory.getLogger(ShardClient.class);
    private static final int ONE_GIGABYTE = 0x40000000;
    private static final int ONE_MEGABYTE = 0x100000;
    private DocumentCodec codec = new DocumentCodec();
    private static final String MONGODB_SRV_PREFIX = "mongodb+srv://";
    private static final List<Document> countPipeline = new ArrayList<Document>();
    public static final Set<String> excludedSystemDbs;
    private ShardClientType shardClientType = ShardClientType.SHARDED;
    private String name;
    private String version;
    private List<Integer> versionArray;
    private MongoClient mongoClient;
    private MongoDatabase configDb;
    private Map<String, Shard> shardsMap = new LinkedHashMap<String, Shard>();
    private Map<String, RawBsonDocument> chunksCache = new LinkedHashMap<String, RawBsonDocument>();
    private Map<String, Shard> tertiaryShardsMap = new LinkedHashMap<String, Shard>();
    private ConnectionString connectionString;
    private MongoClientSettings mongoClientSettings;
    private ConnectionString csrsConnectionString;
    private MongoClientSettings csrsMongoClientSettings;
    private MongoClient csrsMongoClient;
    private List<Mongos> mongosList = new ArrayList<Mongos>();
    private Map<String, MongoClient> mongosMongoClients = new TreeMap<String, MongoClient>();
    private Map<String, Document> collectionsMap = new TreeMap<String, Document>();
    private Map<String, MongoClient> shardMongoClients = new TreeMap<String, MongoClient>();
    private List<String> srvHosts;
    private Collection<String> shardIdFilter;
    private boolean patternedUri;
    private boolean manualShardHosts;
    private boolean mongos;
    private String connectionStringPattern;
    private String rsPattern;
    private String csrsUri;
    private String[] rsStringsManual;

    static {
        countPipeline.add(Document.parse((String)"{ $group: { _id: null, count: { $sum: 1 } } }"));
        countPipeline.add(Document.parse((String)"{ $project: { _id: 0, count: 1 } }"));
        excludedSystemDbs = new HashSet<String>(Arrays.asList("system", "local", "config", "admin"));
    }

    public ShardClient(String name, String clusterUri, Collection<String> shardIdFilter) {
        this.patternedUri = clusterUri.contains("%s");
        if (this.patternedUri) {
            this.connectionStringPattern = clusterUri;
            String csrsUri = String.format(clusterUri, "config", 0, 0);
            logger.debug(String.valueOf(name) + " csrsUri from pattern: " + csrsUri);
            this.connectionString = new ConnectionString(csrsUri);
        } else {
            this.connectionString = new ConnectionString(clusterUri);
        }
        this.name = name;
        this.shardIdFilter = shardIdFilter;
        logger.debug(String.format("%s client, uri: %s", name, MaskUtil.maskConnectionString(this.connectionString)));
    }

    public ShardClient(String name, String clusterUri) {
        this(name, clusterUri, null);
    }

    public void init() {
        boolean bl = this.manualShardHosts = this.rsStringsManual != null && this.rsStringsManual.length > 0;
        if (this.csrsUri != null) {
            logger.debug(String.valueOf(this.name) + " csrsUri: " + this.csrsUri);
            this.csrsConnectionString = new ConnectionString(this.csrsUri);
            this.csrsMongoClientSettings = MongoClientSettings.builder().applyConnectionString(this.csrsConnectionString).uuidRepresentation(UuidRepresentation.STANDARD).build();
            this.csrsMongoClient = MongoClients.create((MongoClientSettings)this.csrsMongoClientSettings);
        }
        this.mongoClientSettings = MongoClientSettings.builder().applyConnectionString(this.connectionString).uuidRepresentation(UuidRepresentation.STANDARD).build();
        this.mongoClient = MongoClients.create((MongoClientSettings)this.mongoClientSettings);
        CodecRegistry pojoCodecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
        try {
            Document dbgridResult = this.adminCommand(new Document("isdbgrid", (Object)1));
            Integer dbgrid = dbgridResult.getInteger((Object)"isdbgrid");
            this.mongos = dbgrid.equals(1);
        }
        catch (MongoException dbgridResult) {
            // empty catch block
        }
        this.configDb = this.mongoClient.getDatabase("config").withCodecRegistry(pojoCodecRegistry);
        this.populateShardList();
        Document destBuildInfo = this.adminCommand(new Document("buildinfo", (Object)1));
        this.version = destBuildInfo.getString((Object)"version");
        this.versionArray = (List)destBuildInfo.get((Object)"versionArray");
        logger.debug(String.format("%s : MongoDB version: %s, mongos: %s", this.name, this.version, this.mongos));
        this.populateMongosList();
    }

    private void populateShardList() {
        MongoCollection shardsColl = this.configDb.getCollection("shards", Shard.class);
        FindIterable shards = shardsColl.find().sort(Sorts.ascending((String[])new String[]{"_id"}));
        for (Shard sh : shards) {
            if (!this.patternedUri && !this.manualShardHosts) {
                logger.debug(String.format("%s: populateShardList shard: %s", this.name, sh.getHost()));
            }
            String rsName = StringUtils.substringBefore((String)sh.getHost(), (String)"/");
            sh.setRsName(rsName);
            if (this.shardIdFilter == null) {
                this.shardsMap.put(sh.getId(), sh);
                continue;
            }
            if (!this.shardIdFilter.contains(sh.getId())) continue;
            this.shardsMap.put(sh.getId(), sh);
        }
        if (this.patternedUri) {
            int shardCount = this.shardsMap.size();
            this.tertiaryShardsMap.putAll(this.shardsMap);
            this.shardsMap.clear();
            int shardNum = 0;
            while (shardNum < shardCount) {
                String hostBasePre = StringUtils.substringAfter((String)this.connectionStringPattern, (String)"mongodb://");
                String hostBase = StringUtils.substringBefore((String)hostBasePre, (String)"/");
                if (hostBase.contains("@")) {
                    hostBase = StringUtils.substringAfter((String)hostBase, (String)"@");
                }
                String host0 = String.format(hostBase, "shard", shardNum, 0);
                String host1 = String.format(hostBase, "shard", shardNum, 1);
                String rsName = String.format(this.rsPattern, "shard", shardNum);
                Shard sh = new Shard();
                sh.setId(rsName);
                sh.setRsName(rsName);
                sh.setHost(String.format("%s/%s,%s", rsName, host0, host1));
                this.shardsMap.put(sh.getId(), sh);
                logger.debug(String.format("%s: populateShardList formatted shard name: %s", this.name, sh.getHost()));
                ++shardNum;
            }
        } else if (this.manualShardHosts) {
            this.shardsMap.clear();
            String[] stringArray = this.rsStringsManual;
            int n = this.rsStringsManual.length;
            int n2 = 0;
            while (n2 < n) {
                String rsString = stringArray[n2];
                if (!rsString.contains("/")) {
                    throw new IllegalArgumentException(String.format("Invalid format for %sRsManual, expecting rsName/host1:port,host2:port,host3:port", this.name));
                }
                String rsName = StringUtils.substringBefore((String)rsString, (String)"/");
                Shard sh = new Shard();
                sh.setId(rsName);
                sh.setRsName(rsName);
                sh.setHost(String.format("%s/%s", rsName, StringUtils.substringAfter((String)rsString, (String)"/")));
                this.shardsMap.put(sh.getId(), sh);
                logger.debug("{}: populateShardList added manual shard connection: {}", (Object)this.name, (Object)sh.getHost());
                ++n2;
            }
        }
        logger.debug(String.valueOf(this.name) + ": populateShardList complete, " + this.shardsMap.size() + " shards added");
    }

    private void populateMongosList() {
        if (this.patternedUri) {
            logger.debug("populateMongosList() skipping, patternedUri");
            return;
        }
        if (this.connectionString.isSrvProtocol()) {
            DefaultDnsResolver resolver = new DefaultDnsResolver();
            this.srvHosts = resolver.resolveHostFromSrvRecords((String)this.connectionString.getHosts().get(0));
            for (String hostPort : this.srvHosts) {
                logger.debug("populateMongosList() mongos srvHost: " + hostPort);
                String host = StringUtils.substringBefore((String)hostPort, (String)":");
                Integer port = Integer.parseInt(StringUtils.substringAfter((String)hostPort, (String)":"));
                MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();
                settingsBuilder.applyToClusterSettings(builder -> {
                    ClusterSettings.Builder builder2 = builder.hosts(Arrays.asList(new ServerAddress(host, port.intValue())));
                });
                if (this.connectionString.getSslEnabled() != null) {
                    settingsBuilder.applyToSslSettings(builder -> {
                        SslSettings.Builder builder2 = builder.enabled(this.connectionString.getSslEnabled().booleanValue());
                    });
                }
                if (this.connectionString.getCredential() != null) {
                    settingsBuilder.credential(this.connectionString.getCredential());
                }
                settingsBuilder.uuidRepresentation(UuidRepresentation.STANDARD);
                MongoClientSettings settings = settingsBuilder.build();
                MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);
                this.mongosMongoClients.put(hostPort, mongoClient);
            }
        } else {
            MongoCollection mongosColl = this.configDb.getCollection("mongos", Mongos.class);
            int limit = 100;
            if (this.name.equals("source")) {
                limit = 5;
            }
            mongosColl.find().sort(Sorts.ascending((String[])new String[]{"ping"})).limit(limit).into(this.mongosList);
            for (Mongos mongos : this.mongosList) {
                String hostPort = mongos.getId();
                String host = StringUtils.substringBefore((String)hostPort, (String)":");
                Integer port = Integer.parseInt(StringUtils.substringAfter((String)hostPort, (String)":"));
                MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();
                settingsBuilder.applyToClusterSettings(builder -> {
                    ClusterSettings.Builder builder2 = builder.hosts(Arrays.asList(new ServerAddress(host, port.intValue())));
                });
                if (this.connectionString.getSslEnabled() != null) {
                    settingsBuilder.applyToSslSettings(builder -> {
                        SslSettings.Builder builder2 = builder.enabled(this.connectionString.getSslEnabled().booleanValue());
                    });
                }
                if (this.connectionString.getCredential() != null) {
                    settingsBuilder.credential(this.connectionString.getCredential());
                }
                settingsBuilder.uuidRepresentation(UuidRepresentation.STANDARD);
                MongoClientSettings settings = settingsBuilder.build();
                MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);
                this.mongosMongoClients.put(mongos.getId(), mongoClient);
            }
        }
        logger.debug(String.valueOf(this.name) + " populateMongosList complete, " + this.mongosMongoClients.size() + " mongosMongoClients added");
    }

    public void populateCollectionsMap(Set<String> namespaces) {
        if (!this.collectionsMap.isEmpty()) {
            return;
        }
        logger.debug("Starting populateCollectionsMap()");
        MongoCollection shardsColl = this.configDb.getCollection("collections");
        Bson filter = null;
        filter = namespaces == null || namespaces.isEmpty() ? Filters.eq((String)"dropped", (Object)false) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"dropped", (Object)false), Filters.in((String)"_id", namespaces)});
        FindIterable colls = shardsColl.find(filter).sort(Sorts.ascending((String[])new String[]{"_id"}));
        for (Document c : colls) {
            String id = (String)c.get((Object)"_id");
            this.collectionsMap.put(id, c);
        }
        logger.debug(String.format("%s Finished populateCollectionsMap(), %s collections loaded from config server", this.name, this.collectionsMap.size()));
    }

    public void populateCollectionsMap() {
        this.populateCollectionsMap(null);
    }

    public void populateShardMongoClients() {
        if (this.shardMongoClients.size() > 0) {
            logger.debug("populateShardMongoClients already complete, skipping");
        }
        for (Shard shard : this.shardsMap.values()) {
            String shardHost = shard.getHost();
            String seeds = StringUtils.substringAfter((String)shardHost, (String)"/");
            logger.debug(String.valueOf(this.name) + " " + shard.getId() + " populateShardMongoClients() seeds: " + seeds);
            String[] seedHosts = seeds.split(",");
            ArrayList<ServerAddress> serverAddressList = new ArrayList<ServerAddress>();
            String[] stringArray = seedHosts;
            int n = seedHosts.length;
            int n2 = 0;
            while (n2 < n) {
                String seed = stringArray[n2];
                String host = StringUtils.substringBefore((String)seed, (String)":");
                Integer port = Integer.parseInt(StringUtils.substringAfter((String)seed, (String)":"));
                serverAddressList.add(new ServerAddress(host, port.intValue()));
                ++n2;
            }
            MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();
            settingsBuilder.applyToClusterSettings(builder -> {
                ClusterSettings.Builder builder2 = builder.hosts(serverAddressList);
            });
            if (this.connectionString.getSslEnabled() != null) {
                settingsBuilder.applyToSslSettings(builder -> {
                    SslSettings.Builder builder2 = builder.enabled(this.connectionString.getSslEnabled().booleanValue());
                });
            }
            if (this.connectionString.getCredential() != null) {
                settingsBuilder.credential(this.connectionString.getCredential());
            }
            if (this.connectionString.getApplicationName() != null) {
                settingsBuilder.applicationName(this.connectionString.getApplicationName());
            }
            settingsBuilder.uuidRepresentation(UuidRepresentation.STANDARD);
            MongoClientSettings settings = settingsBuilder.build();
            MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);
            Document isMasterResult = mongoClient.getDatabase("admin").runCommand((Bson)new Document("isMaster", (Object)1));
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.name) + " isMaster complete, cluster: " + mongoClient.getClusterDescription());
            }
            this.shardMongoClients.put(shard.getId(), mongoClient);
        }
    }

    public Document getLatestOplogEntry(String shardId) {
        MongoClient client = this.shardMongoClients.get(shardId);
        MongoCollection coll = client.getDatabase("local").getCollection("oplog.rs");
        Document doc = (Document)coll.find(Filters.ne((String)"op", (Object)"n")).sort(Filters.eq((String)"$natural", (Object)-1)).first();
        return doc;
    }

    public BsonTimestamp getLatestOplogTimestamp(String shardId) {
        return this.getLatestOplogTimestamp(shardId, null);
    }

    public BsonTimestamp getLatestOplogTimestamp(String shardId, Bson query) {
        MongoClient client = this.shardMongoClients.get(shardId);
        MongoCollection coll = client.getDatabase("local").getCollection("oplog.rs");
        Document doc = null;
        doc = query != null ? (Document)coll.find(query).comment("getLatestOplogTimestamp").projection(Projections.include((String[])new String[]{"ts"})).sort(Filters.eq((String)"$natural", (Object)-1)).first() : (Document)coll.find().comment("getLatestOplogTimestamp").projection(Projections.include((String[])new String[]{"ts"})).sort(Filters.eq((String)"$natural", (Object)-1)).first();
        BsonTimestamp ts = (BsonTimestamp)doc.get((Object)"ts");
        return ts;
    }

    public ShardTimestamp populateLatestOplogTimestamp(String shardId, String startingTs) {
        Bson query = null;
        if (startingTs != null) {
            if (startingTs.contains(",")) {
                String[] tsParts = startingTs.split(",");
                int seconds = Integer.parseInt(tsParts[0]);
                int increment = Integer.parseInt(tsParts[1]);
                query = Filters.gt((String)"ts", (Object)new BsonTimestamp(seconds, increment));
            } else {
                throw new IllegalArgumentException("Error parsing timestamp no comma found, expected format ts,increment");
            }
        }
        BsonTimestamp ts = this.getLatestOplogTimestamp(shardId, query);
        ShardTimestamp st = new ShardTimestamp(shardId, ts);
        this.getShardsMap().get(shardId).setSyncStartTimestamp(st);
        return st;
    }

    public void dropDatabase(String dbName) {
        for (Map.Entry<String, MongoClient> entry : this.shardMongoClients.entrySet()) {
            logger.debug(String.valueOf(this.name) + " dropping " + dbName + " on " + entry.getKey());
            entry.getValue().getDatabase(dbName).drop();
        }
    }

    public void dropDatabases(List<String> databasesList) {
        for (Map.Entry<String, MongoClient> entry : this.shardMongoClients.entrySet()) {
            for (String dbName : databasesList) {
                if (dbName.equals("admin")) continue;
                logger.debug(String.valueOf(this.name) + " dropping " + dbName + " on " + entry.getKey());
                entry.getValue().getDatabase(dbName).drop();
            }
        }
    }

    private void dropForce(String dbName) {
        DeleteResult r = this.mongoClient.getDatabase("config").getCollection("collections").deleteMany(Filters.regex((String)"_id", (String)("^" + dbName + "\\.")));
        logger.debug(String.format("Force deleted %s config.collections documents", r.getDeletedCount()));
        r = this.mongoClient.getDatabase("config").getCollection("chunks").deleteMany(Filters.regex((String)"ns", (String)("^" + dbName + "\\.")));
        logger.debug(String.format("Force deleted %s config.chunks documents", r.getDeletedCount()));
    }

    public void dropDatabasesAndConfigMetadata(List<String> databasesList) {
        for (String dbName : databasesList) {
            if (dbName.equals("admin")) continue;
            logger.debug(String.valueOf(this.name) + " dropping " + dbName);
            try {
                this.mongoClient.getDatabase(dbName).drop();
            }
            catch (MongoCommandException mce) {
                logger.warn("Drop failed, brute forcing.", (Throwable)mce);
                this.dropForce(dbName);
            }
        }
    }

    public static Number estimatedDocumentCount(MongoDatabase db, MongoCollection<RawBsonDocument> collection) {
        return collection.estimatedDocumentCount();
    }

    public static Number countDocuments(MongoDatabase db, MongoCollection<RawBsonDocument> collection) {
        return collection.countDocuments();
    }

    public Number getCollectionCount(MongoDatabase db, MongoCollection<RawBsonDocument> collection) {
        try {
            BsonDocument result = (BsonDocument)collection.aggregate(countPipeline).first();
            Long count = null;
            if (result != null) {
                count = result.get((Object)"count").asNumber().longValue();
            }
            return count;
        }
        catch (MongoCommandException mce) {
            logger.error(String.valueOf(this.name) + " getCollectionCount error");
            throw mce;
        }
    }

    public Number getFastCollectionCount(MongoDatabase db, String collectionName) {
        return db.getCollection(collectionName).estimatedDocumentCount();
    }

    public Number getCollectionCount(String dbName, String collectionName) {
        MongoDatabase db = this.mongoClient.getDatabase(dbName);
        return this.getCollectionCount(db, (MongoCollection<RawBsonDocument>)db.getCollection(collectionName, RawBsonDocument.class));
    }

    public Number getCollectionCount(MongoDatabase db, String collectionName) {
        return this.getCollectionCount(db, (MongoCollection<RawBsonDocument>)db.getCollection(collectionName, RawBsonDocument.class));
    }

    public MongoCollection<Document> getShardsCollection() {
        return this.configDb.getCollection("shards");
    }

    public MongoCollection<Document> getTagsCollection() {
        return this.configDb.getCollection("tags");
    }

    public MongoCollection<Document> getChunksCollection() {
        return this.configDb.getCollection("chunks");
    }

    public MongoCollection<RawBsonDocument> getChunksCollectionRaw() {
        return this.configDb.getCollection("chunks", RawBsonDocument.class);
    }

    public MongoCollection<RawBsonDocument> getChunksCollectionRawPrivileged() {
        if (this.csrsMongoClient != null) {
            MongoDatabase configDb = this.csrsMongoClient.getDatabase("config");
            return configDb.getCollection("chunks", RawBsonDocument.class);
        }
        return this.getChunksCollectionRaw();
    }

    public MongoCollection<Document> getDatabasesCollection() {
        return this.configDb.getCollection("databases");
    }

    public Document createDatabase(String databaseName) {
        logger.debug(String.valueOf(this.name) + " createDatabase " + databaseName);
        String tmpName = "tmp_ShardConfigSync_" + System.currentTimeMillis();
        this.mongoClient.getDatabase(databaseName).createCollection(tmpName);
        Document dbMeta = null;
        while (dbMeta == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("createDatabase() querying for config.databases entry");
            dbMeta = (Document)this.getDatabasesCollection().find((Bson)new Document("_id", (Object)databaseName)).first();
        }
        this.mongoClient.getDatabase(databaseName).getCollection(tmpName).drop();
        return dbMeta;
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.mongoClient.listDatabaseNames();
    }

    public MongoIterable<String> listCollectionNames(String databaseName) {
        return this.mongoClient.getDatabase(databaseName).listCollectionNames();
    }

    public void flushRouterConfig() {
        Document flushRouterConfig = new Document("flushRouterConfig", (Object)true);
        try {
            logger.debug(String.format("flushRouterConfig for mongos", new Object[0]));
            this.mongoClient.getDatabase("admin").runCommand((Bson)flushRouterConfig);
        }
        catch (MongoTimeoutException timeout) {
            logger.debug("Timeout connecting", (Throwable)timeout);
        }
    }

    public void stopBalancer() {
        if (this.versionArray.get(0) == 2 || this.versionArray.get(0) == 3 && this.versionArray.get(1) <= 2) {
            Document balancerId = new Document("_id", (Object)"balancer");
            Document setStopped = new Document("$set", (Object)new Document("stopped", (Object)true));
            UpdateOptions updateOptions = new UpdateOptions().upsert(true);
            this.configDb.getCollection("settings").updateOne((Bson)balancerId, (Bson)setStopped, updateOptions);
        } else {
            this.adminCommand(new Document("balancerStop", (Object)1));
        }
    }

    public Document adminCommand(Document command) {
        return this.mongoClient.getDatabase("admin").runCommand((Bson)command);
    }

    public String getVersion() {
        return this.version;
    }

    public List<Integer> getVersionArray() {
        return this.versionArray;
    }

    public boolean isVersion36OrLater() {
        return this.versionArray.get(0) >= 4 || this.versionArray.get(0) == 3 && this.versionArray.get(1) == 6;
    }

    public Map<String, Shard> getShardsMap() {
        return this.shardsMap;
    }

    public Map<String, Document> getCollectionsMap() {
        return this.collectionsMap;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoCollection<Document> getCollection(String nsStr) {
        return this.getCollection(new Namespace(nsStr));
    }

    public MongoCollection<Document> getCollection(Namespace ns) {
        return this.mongoClient.getDatabase(ns.getDatabaseName()).getCollection(ns.getCollectionName());
    }

    public Document enableSharding(String dbName) {
        Document enableSharding = new Document("enableSharding", (Object)dbName);
        return this.adminCommand(enableSharding);
    }

    public Document shardCollection(Namespace ns, Document shardKey) {
        Document shardCommand = new Document("shardCollection", (Object)ns.getNamespace());
        shardCommand.append("key", (Object)shardKey);
        return this.adminCommand(shardCommand);
    }

    public MongoCollection<BsonDocument> getCollectionRaw(Namespace ns) {
        return this.mongoClient.getDatabase(ns.getDatabaseName()).getCollection(ns.getCollectionName(), BsonDocument.class);
    }

    public MongoDatabase getConfigDb() {
        return this.configDb;
    }

    public Collection<MongoClient> getMongosMongoClients() {
        return this.mongosMongoClients.values();
    }

    public MongoClient getShardMongoClient(String shardId) {
        return this.shardMongoClients.get(shardId);
    }

    public Map<String, MongoClient> getShardMongoClients() {
        return this.shardMongoClients;
    }

    public void checkAutosplit() {
        logger.debug(String.format("checkAutosplit() for %s mongos routers", this.mongosMongoClients.size()));
        for (Map.Entry<String, MongoClient> entry : this.mongosMongoClients.entrySet()) {
            MongoClient client = entry.getValue();
            Document getCmdLine = new Document("getCmdLineOpts", (Object)true);
            Boolean autoSplit = null;
            try {
                Document result = this.adminCommand(getCmdLine);
                Document parsed = (Document)result.get((Object)"parsed");
                Document sharding = (Document)parsed.get((Object)"sharding");
                if (sharding != null) {
                    sharding.getBoolean((Object)"autoSplit");
                }
                if (autoSplit != null && !autoSplit.booleanValue()) {
                    logger.debug("autoSplit disabled for " + entry.getKey());
                    continue;
                }
                logger.warn("autoSplit NOT disabled for " + entry.getKey());
            }
            catch (MongoTimeoutException timeout) {
                logger.debug("Timeout connecting", (Throwable)timeout);
            }
        }
    }

    public void disableAutosplit() {
        MongoDatabase configDb = this.mongoClient.getDatabase("config");
        MongoCollection settings = configDb.getCollection("settings", RawBsonDocument.class);
        Document update = new Document("$set", (Object)new Document("enabled", (Object)false));
        settings.updateOne(Filters.eq((String)"_id", (Object)"autosplit"), (Bson)update);
    }

    public void compareCollectionUuids() {
        logger.debug(String.format("%s - Starting compareCollectionUuids", this.name));
        this.populateShardMongoClients();
        ArrayList dbNames = new ArrayList();
        this.listDatabaseNames().into(dbNames);
        TreeMap collectionUuidMappings = new TreeMap();
        for (Map.Entry<String, MongoClient> entry : this.getShardMongoClients().entrySet()) {
            MongoClient client = entry.getValue();
            String shardName = entry.getKey();
            for (String databaseName : client.listDatabaseNames()) {
                MongoDatabase db = client.getDatabase(databaseName);
                if (databaseName.equals("admin") || databaseName.equals("config") || databaseName.contentEquals("local")) continue;
                for (Document collectionInfo : db.listCollections()) {
                    String collectionName = (String)collectionInfo.get((Object)"name");
                    if (collectionName.endsWith(".create")) continue;
                    Namespace ns = new Namespace(databaseName, collectionName);
                    Document info = (Document)collectionInfo.get((Object)"info");
                    UUID uuid = (UUID)info.get((Object)"uuid");
                    TreeMap uuidMapping = (TreeMap)collectionUuidMappings.get(ns);
                    if (uuidMapping == null) {
                        uuidMapping = new TreeMap();
                    }
                    collectionUuidMappings.put(ns, uuidMapping);
                    ArrayList<String> shardNames = (ArrayList<String>)uuidMapping.get(uuid);
                    if (shardNames == null) {
                        shardNames = new ArrayList<String>();
                    }
                    uuidMapping.put(uuid, shardNames);
                    shardNames.add(shardName);
                }
            }
        }
        int successCount = 0;
        int failureCount = 0;
        for (Map.Entry mappingEntry : collectionUuidMappings.entrySet()) {
            Namespace ns = (Namespace)mappingEntry.getKey();
            Map uuidMappings = (Map)mappingEntry.getValue();
            if (uuidMappings.size() == 1) {
                ++successCount;
                logger.debug(String.format("%s ==> %s", ns, uuidMappings));
                continue;
            }
            ++failureCount;
            logger.error(String.format("%s ==> %s", ns, uuidMappings));
        }
        if (failureCount == 0 && successCount > 0) {
            logger.debug(String.format("%s - compareCollectionUuids complete: successCount: %s, failureCount: %s", this.name, successCount, failureCount));
        } else {
            logger.error(String.format("%s - compareCollectionUuids complete: successCount: %s, failureCount: %s", this.name, successCount, failureCount));
        }
    }

    public void extendTtls(String shardName, Namespace ns, Set<IndexSpec> sourceSpecs) {
        MongoClient client = this.getShardMongoClient(shardName);
        MongoDatabase db = client.getDatabase(ns.getDatabaseName());
        MongoCollection c = db.getCollection(ns.getCollectionName());
        ArrayList indexes = new ArrayList();
        for (IndexSpec indexSpec : sourceSpecs) {
            Document indexInfo = (Document)indexSpec.getSourceSpec().decode((Codec)this.codec);
            indexInfo.remove((Object)"v");
            Number expireAfterSeconds = (Number)indexInfo.get((Object)"expireAfterSeconds");
            if (expireAfterSeconds == null) continue;
            logger.debug("ix: " + indexSpec);
            indexInfo.put("expireAfterSeconds", (Object)1576800000);
            logger.debug(String.format("Extending TTL for %s %s from %s to %s", ns, indexInfo.get((Object)"name"), expireAfterSeconds, indexInfo.get((Object)"expireAfterSeconds")));
            Document collMod = new Document("collMod", (Object)ns.getCollectionName());
            collMod.append("index", (Object)indexInfo);
            logger.debug(String.format("%s collMod: %s", ns, collMod));
            try {
                Document result = db.runCommand((Bson)collMod);
                logger.debug(String.format("%s collMod result: %s", ns, result));
            }
            catch (MongoCommandException mce) {
                logger.error(String.format("%s createIndexes failed: %s", ns, mce.getMessage()));
            }
        }
    }

    public void createIndexes(String shardName, Namespace ns, Set<IndexSpec> sourceSpecs, boolean extendTtl) {
        MongoClient client = this.getShardMongoClient(shardName);
        MongoDatabase db = client.getDatabase(ns.getDatabaseName());
        MongoCollection c = db.getCollection(ns.getCollectionName());
        Document createIndexes = new Document("createIndexes", (Object)ns.getCollectionName());
        ArrayList<Document> indexes = new ArrayList<Document>();
        createIndexes.append("indexes", indexes);
        for (IndexSpec indexSpec : sourceSpecs) {
            logger.debug("ix: " + indexSpec);
            Document indexInfo = (Document)indexSpec.getSourceSpec().decode((Codec)this.codec);
            indexInfo.remove((Object)"v");
            indexInfo.append("background", (Object)true);
            Number expireAfterSeconds = (Number)indexInfo.get((Object)"expireAfterSeconds");
            if (expireAfterSeconds != null && extendTtl) {
                if (expireAfterSeconds.equals(0)) {
                    logger.warn(String.format("Skip extending TTL for %s %s - expireAfterSeconds is 0 (wall clock exp.)", ns, indexInfo.get((Object)"name")));
                } else {
                    indexInfo.put("expireAfterSeconds", (Object)1576800000);
                    logger.debug(String.format("Extending TTL for %s %s from %s to %s", ns, indexInfo.get((Object)"name"), expireAfterSeconds, indexInfo.get((Object)"expireAfterSeconds")));
                }
            }
            indexes.add(indexInfo);
        }
        if (!indexes.isEmpty()) {
            try {
                IndexSpec indexSpec;
                indexSpec = db.runCommand((Bson)createIndexes);
            }
            catch (MongoCommandException mce) {
                logger.error(String.format("%s createIndexes failed: %s", ns, mce.getMessage()));
            }
        }
    }

    public void findOrphans(boolean doMove) {
        logger.debug("Starting findOrphans");
        MongoCollection<RawBsonDocument> sourceChunksColl = this.getChunksCollectionRaw();
        FindIterable sourceChunks = sourceChunksColl.find().noCursorTimeout(true).sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        String lastNs = null;
        int currentCount = 0;
        for (String string : this.shardsMap.keySet()) {
        }
        for (RawBsonDocument sourceChunk : sourceChunks) {
            String sourceNs = sourceChunk.getString((Object)"ns").getValue();
            if (!sourceNs.equals(lastNs)) {
                if (currentCount > 0) {
                    logger.debug(String.format("findOrphans - %s - complete, queried %s chunks", lastNs, currentCount));
                    currentCount = 0;
                }
                logger.debug(String.format("findOrphans - %s - starting", sourceNs));
            } else if (currentCount > 0 && currentCount % 10 == 0) {
                logger.debug(String.format("findOrphans - %s - currentCount: %s chunks", sourceNs, currentCount));
            }
            RawBsonDocument sourceMin = (RawBsonDocument)sourceChunk.get((Object)"min");
            RawBsonDocument sourceMax = (RawBsonDocument)sourceChunk.get((Object)"max");
            String sourceShard = sourceChunk.getString((Object)"shard").getValue();
            ++currentCount;
            lastNs = sourceNs;
        }
    }

    public static String getIdFromChunk(BsonDocument sourceChunk) {
        RawBsonDocument sourceMin = (RawBsonDocument)sourceChunk.get((Object)"min");
        String minHash = sourceMin.toJson();
        RawBsonDocument sourceMax = (RawBsonDocument)sourceChunk.get((Object)"max");
        String maxHash = sourceMax.toJson();
        String ns = sourceChunk.getString((Object)"ns").getValue();
        return String.format("%s_%s_%s", ns, minHash, maxHash);
    }

    public Map<String, RawBsonDocument> loadChunksCache(Document chunkQuery) {
        MongoCollection<RawBsonDocument> chunksColl = this.getChunksCollectionRaw();
        FindIterable sourceChunks = chunksColl.find((Bson)chunkQuery).sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        int count = 0;
        for (RawBsonDocument chunk : sourceChunks) {
            String chunkId = ShardClient.getIdFromChunk((BsonDocument)chunk);
            this.chunksCache.put(chunkId, chunk);
            ++count;
        }
        logger.debug("{}: loaded {} chunks into chunksCache", (Object)this.name, (Object)count);
        return this.chunksCache;
    }

    public boolean checkChunkExists(BsonDocument chunk) {
        String ns = chunk.getString((Object)"ns").getValue();
        Document query = new Document("ns", (Object)ns);
        query.append("min", (Object)chunk.get((Object)"min"));
        query.append("max", (Object)chunk.get((Object)"max"));
        long count = this.getChunksCollectionRaw().countDocuments((Bson)query);
        return count > 0L;
    }

    public void createChunk(BsonDocument chunk, boolean checkExists, boolean logErrors) {
        boolean chunkExists;
        block5: {
            boolean chunkExists2;
            MongoCollection<RawBsonDocument> destChunksColl = this.getChunksCollectionRaw();
            String ns = chunk.getString((Object)"ns").getValue();
            if (checkExists && (chunkExists2 = this.checkChunkExists(chunk))) {
                return;
            }
            BsonDocument max = (BsonDocument)chunk.get((Object)"max");
            for (Object next : max.values()) {
                if (!(next instanceof MaxKey) && !(next instanceof BsonMaxKey)) continue;
                return;
            }
            Document splitCommand = new Document("split", (Object)ns);
            splitCommand.put("middle", (Object)max);
            try {
                this.adminCommand(splitCommand);
            }
            catch (MongoCommandException mce) {
                if (!logErrors) break block5;
                logger.error("command error for namespace {}, message: {}", (Object)ns, (Object)mce.getMessage());
            }
        }
        if (checkExists && !(chunkExists = this.checkChunkExists(chunk))) {
            logger.warn("Chunk create failed: " + chunk);
        }
    }

    public boolean moveChunk(RawBsonDocument chunk, String moveToShard, boolean ignoreMissing) {
        RawBsonDocument min = (RawBsonDocument)chunk.get((Object)"min");
        RawBsonDocument max = (RawBsonDocument)chunk.get((Object)"max");
        String ns = chunk.getString((Object)"ns").getValue();
        return this.moveChunk(ns, min, max, moveToShard, ignoreMissing);
    }

    public boolean moveChunk(String namespace, RawBsonDocument min, RawBsonDocument max, String moveToShard, boolean ignoreMissing) {
        Document moveChunkCmd = new Document("moveChunk", (Object)namespace);
        moveChunkCmd.append("bounds", Arrays.asList(min, max));
        moveChunkCmd.append("to", (Object)moveToShard);
        try {
            this.adminCommand(moveChunkCmd);
        }
        catch (MongoCommandException mce) {
            if (!ignoreMissing) {
                logger.warn(String.format("moveChunk error ns: %s, message: %s", namespace, mce.getMessage()));
            }
            return false;
        }
        return true;
    }

    public List<Document> splitVector(Namespace ns, Document collectionMeta) {
        Document splitVectorCmd = new Document("splitVector", (Object)ns.getNamespace());
        Document keyPattern = (Document)collectionMeta.get((Object)"key");
        splitVectorCmd.append("keyPattern", (Object)keyPattern);
        splitVectorCmd.append("maxChunkSizeBytes", (Object)0x40000000);
        MongoDatabase dbTop = this.mongoClient.getDatabase(ns.getDatabaseName());
        Document stats = dbTop.runCommand((Bson)new Document("collStats", (Object)ns.getCollectionName()));
        Long size = ((Number)stats.get((Object)"size")).longValue();
        int shardCount = this.shardsMap.size();
        long splitSize = size / (long)shardCount / 10L;
        if (splitSize >= 16793599L) {
            splitSize = 16793599L;
        } else if (splitSize < 0x100000L) {
            splitSize = 0x200000L;
        }
        logger.debug("{}: size: {}, splitSize: {}", new Object[]{ns, size, splitSize});
        splitVectorCmd.append("maxChunkSizeBytes", (Object)splitSize);
        Document splits = null;
        List splitKeys = null;
        ArrayList<Document> splitKeysAll = new ArrayList<Document>();
        for (Map.Entry<String, MongoClient> entry : this.shardMongoClients.entrySet()) {
            Integer splitCount;
            String shardId;
            block8: {
                MongoClient mongoClient = entry.getValue();
                MongoDatabase db = mongoClient.getDatabase(ns.getDatabaseName());
                shardId = entry.getKey();
                splitCount = null;
                try {
                    splits = db.runCommand((Bson)splitVectorCmd);
                    splitKeys = (List)splits.get((Object)"splitKeys");
                    splitKeysAll.addAll(splitKeys);
                    splitCount = splitKeys.size();
                }
                catch (MongoCommandException mce) {
                    if (mce.getCode() == 13) {
                        logger.error("splitVector failed: {}, note this cannot be run on an Atlas source", (Object)mce.getMessage());
                    }
                    if (mce.getMessage().contains("couldn't find index over splitting key")) {
                        long count = db.getCollection(ns.getCollectionName()).estimatedDocumentCount();
                        logger.warn("shard {} splitVector failed for ns {}, index {} does not exist. estimated doc count: {}", new Object[]{shardId, ns.getNamespace(), keyPattern, count});
                        db.getCollection(ns.getCollectionName()).createIndex((Bson)keyPattern, new IndexOptions().background(true));
                    }
                    if (mce.getMessage().contains("ns not found")) break block8;
                    logger.error("splitVector unexpected error for ns {}, message: {}", (Object)ns, (Object)mce.getMessage());
                }
            }
            logger.debug("{}: shard: {}, ns: {}, key: {}, splitCount: {}", new Object[]{this.name, shardId, ns.getNamespace(), keyPattern, splitCount});
        }
        return splitKeysAll;
    }

    public Map<Namespace, List<Document>> splitVector() {
        TreeMap<Namespace, List<Document>> splitPoints = new TreeMap<Namespace, List<Document>>();
        for (Document sourceColl : this.getCollectionsMap().values()) {
            String nsStr = (String)sourceColl.get((Object)"_id");
            Namespace ns = new Namespace(nsStr);
            if (excludedSystemDbs.contains(ns.getDatabaseName())) continue;
            Document splitVectorCmd = new Document("splitVector", (Object)nsStr);
            Document keyPattern = (Document)sourceColl.get((Object)"key");
            splitVectorCmd.append("keyPattern", (Object)keyPattern);
            splitVectorCmd.append("maxChunkSizeBytes", (Object)0x40000000);
            Document splits = null;
            List splitKeys = null;
            ArrayList splitKeysAll = new ArrayList();
            for (Map.Entry<String, MongoClient> entry : this.shardMongoClients.entrySet()) {
                MongoClient mongoClient = entry.getValue();
                String shardId = entry.getKey();
                MongoDatabase db = mongoClient.getDatabase(ns.getDatabaseName());
                Integer splitCount = null;
                try {
                    splits = db.runCommand((Bson)splitVectorCmd);
                    splitKeys = (List)splits.get((Object)"splitKeys");
                    splitKeysAll.addAll(splitKeys);
                    splitCount = splitKeys.size();
                }
                catch (MongoCommandException mce) {
                    if (mce.getCode() == 13) {
                        logger.error("splitVector failed: {}, note this cannot be run on an Atlas source", (Object)mce.getMessage());
                    }
                    if (mce.getMessage().contains("couldn't find index over splitting key")) {
                        long count = db.getCollection(ns.getCollectionName()).estimatedDocumentCount();
                        logger.warn("shard {} splitVector failed for ns {}, index {} does not exist. estimated doc count: {}", new Object[]{shardId, nsStr, keyPattern, count});
                        db.getCollection(ns.getCollectionName()).createIndex((Bson)keyPattern, new IndexOptions().background(true));
                    }
                    logger.error("splitVector unexpected error", (Throwable)mce);
                }
                logger.debug("{}: shard: {}, ns: {}, key: {}, splitCount: {}", new Object[]{this.name, shardId, nsStr, keyPattern, splitCount});
            }
            splitPoints.put(ns, splitKeysAll);
        }
        return splitPoints;
    }

    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    public String getName() {
        return this.name;
    }

    public String getRsPattern() {
        return this.rsPattern;
    }

    public void setRsPattern(String rsPattern) {
        this.rsPattern = rsPattern;
    }

    public Map<String, Shard> getTertiaryShardsMap() {
        return this.tertiaryShardsMap;
    }

    public void setCsrsUri(String csrsUri) {
        this.csrsUri = csrsUri;
    }

    public boolean isMongos() {
        return this.mongos;
    }

    public ShardClientType getShardClientType() {
        return this.shardClientType;
    }

    public void setShardClientType(ShardClientType shardClientType) {
        this.shardClientType = shardClientType;
    }

    public String[] getRsStringsManual() {
        return this.rsStringsManual;
    }

    public void setRsStringsManual(String[] rsStringsManual) {
        this.rsStringsManual = rsStringsManual;
    }

    public static enum ShardClientType {
        SHARDED,
        REPLICA_SET;

    }
}

