/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.shardsync;

import com.google.common.collect.Sets;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.model.IndexSpec;
import com.mongodb.model.Namespace;
import com.mongodb.model.Shard;
import com.mongodb.model.ShardCollection;
import com.mongodb.model.ShardTimestamp;
import com.mongodb.mongomirror.MongoMirrorRunner;
import com.mongodb.mongomirror.model.MongoMirrorStatus;
import com.mongodb.mongomirror.model.MongoMirrorStatusInitialSync;
import com.mongodb.mongomirror.model.MongoMirrorStatusOplogSync;
import com.mongodb.shardsync.CleanupOrphaned;
import com.mongodb.shardsync.ShardClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.lang3.StringUtils;
import org.bson.BSONException;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.UuidCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="shardSync", mixinStandardHelpOptions=true, version={"shardSync 1.0"})
public class ShardConfigSync
implements Callable<Integer> {
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmm_ss");
    private static Logger logger = LoggerFactory.getLogger(ShardConfigSync.class);
    private static final int BATCH_SIZE = 512;
    public static final int SECONDS_IN_YEAR = 31536000;
    private static final Document LOCALE_SIMPLE = new Document("locale", (Object)"simple");
    private String sourceClusterUri;
    private String destClusterUri;
    private String sourceClusterPattern;
    private String destClusterPattern;
    private String sourceRsPattern;
    private String destRsPattern;
    private String[] sourceRsManual;
    private String[] destRsManual;
    private String destCsrsUri;
    private boolean dropDestDbs;
    private boolean dropDestDbsAndConfigMetadata;
    private boolean nonPrivilegedMode = true;
    private boolean doChunkCounts;
    private boolean preserveUUIDs;
    private String compressors;
    private String oplogBasePath;
    private String bookmarkFilePrefix;
    private boolean reverseSync;
    private boolean skipBuildIndexes;
    private Integer collStatsThreshold;
    private boolean dryRun;
    private boolean shardToRs;
    private ShardClient sourceShardClient;
    private ShardClient destShardClient;
    private Map<String, String> sourceToDestShardMap = new HashMap<String, String>();
    private Map<String, String> destToSourceShardMap = new HashMap<String, String>();
    private Map<String, String> altSourceToDestShardMap = new HashMap<String, String>();
    private Map<String, Document> sourceDbInfoMap = new TreeMap<String, Document>();
    private Map<String, Document> destDbInfoMap = new TreeMap<String, Document>();
    private boolean filtered = false;
    private Set<Namespace> includeNamespaces = new HashSet<Namespace>();
    private Set<String> includeDatabases = new HashSet<String>();
    private Map<String, Set<String>> nsToShardsCompletionMap;
    private Set<String> includeDatabasesAll = new HashSet<String>();
    private String[] shardMap;
    private File mongomirrorBinary;
    private long sleepMillis;
    private String numParallelCollections;
    private int mongoMirrorStartPort = 9001;
    private String writeConcern;
    private Long cleanupOrphansSleepMillis;
    private String destVersion;
    private List<Integer> destVersionArray;
    private boolean sslAllowInvalidHostnames;
    private boolean sslAllowInvalidCertificates;
    private boolean skipFlushRouterConfig;
    CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new UuidCodecProvider(UuidRepresentation.STANDARD), PojoCodecProvider.builder().automatic(true).build()})});
    DocumentCodec documentCodec = new DocumentCodec(this.registry);

    public ShardConfigSync() {
        logger.debug("ShardConfigSync starting");
    }

    @Override
    public Integer call() throws Exception {
        return 0;
    }

    public void initializeShardMappings() {
        String dest;
        logger.debug("Start initializeShardMappings()");
        String source = this.sourceClusterUri == null ? this.sourceClusterPattern : this.sourceClusterUri;
        String string = dest = this.destClusterUri == null ? this.destClusterPattern : this.destClusterUri;
        if (this.shardMap != null) {
            logger.debug("Custom n:m shard mapping");
            String[] stringArray = this.shardMap;
            int n = this.shardMap.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                String[] mappings = mapping.split("\\|");
                logger.debug(String.valueOf(mappings[0]) + " ==> " + mappings[1]);
                this.sourceToDestShardMap.put(mappings[0], mappings[1]);
                ++n2;
            }
            this.sourceShardClient = new ShardClient("source", source, this.sourceToDestShardMap.keySet());
            this.destShardClient = new ShardClient("dest", dest, this.sourceToDestShardMap.values());
            this.sourceShardClient.setRsPattern(this.sourceRsPattern);
            this.destShardClient.setRsPattern(this.destRsPattern);
            this.sourceShardClient.setRsStringsManual(this.sourceRsManual);
            this.destShardClient.setRsStringsManual(this.destRsManual);
            this.destShardClient.setCsrsUri(this.destCsrsUri);
            this.sourceShardClient.init();
            this.destShardClient.init();
        } else {
            logger.debug("Default 1:1 shard mapping");
            this.sourceShardClient = new ShardClient("source", source, null);
            this.destShardClient = new ShardClient("dest", dest, null);
            this.sourceShardClient.setRsPattern(this.sourceRsPattern);
            this.destShardClient.setRsPattern(this.destRsPattern);
            this.sourceShardClient.setRsStringsManual(this.sourceRsManual);
            this.destShardClient.setRsStringsManual(this.destRsManual);
            this.destShardClient.setCsrsUri(this.destCsrsUri);
            this.sourceShardClient.init();
            this.destShardClient.init();
            this.checkDestShardClientIsMongos();
            logger.debug("Source shard count: " + this.sourceShardClient.getShardsMap().size());
            int index = 0;
            Map<String, Shard> sourceTertiaryMap = this.sourceShardClient.getTertiaryShardsMap();
            Map<String, Shard> sourceShardsMap = this.sourceShardClient.getShardsMap();
            ArrayList<Shard> destList = new ArrayList<Shard>(this.destShardClient.getShardsMap().values());
            if (this.shardMap == null && sourceShardsMap.size() != destList.size() && !this.shardToRs) {
                throw new IllegalArgumentException(String.format("disparate shard counts requires shardMap to be defined, sourceShardCount: %s, destShardCount: %s", sourceShardsMap.size(), destList.size()));
            }
            if (!this.shardToRs) {
                Shard destShard;
                for (Shard sourceShard : sourceShardsMap.values()) {
                    destShard = (Shard)destList.get(index);
                    if (destShard != null) {
                        logger.debug(String.valueOf(sourceShard.getId()) + " ==> " + destShard.getId());
                        this.sourceToDestShardMap.put(sourceShard.getId(), destShard.getId());
                    }
                    ++index;
                }
                index = 0;
                for (Shard sourceShard : sourceTertiaryMap.values()) {
                    destShard = (Shard)destList.get(index);
                    if (destShard != null) {
                        logger.debug("altMapping: " + sourceShard.getId() + " ==> " + destShard.getId());
                        this.altSourceToDestShardMap.put(sourceShard.getId(), destShard.getId());
                    }
                    ++index;
                }
            }
        }
        this.destToSourceShardMap = MapUtils.invertMap(this.sourceToDestShardMap);
        if (this.sourceClusterPattern == null && !this.sourceShardClient.isMongos()) {
            throw new IllegalArgumentException("source connection must be to a mongos router");
        }
        this.checkDestShardClientIsMongos();
    }

    private void checkDestShardClientIsMongos() {
        if (this.destRsPattern != null) {
            return;
        }
        if (!this.destShardClient.isMongos() && !this.shardToRs) {
            throw new IllegalArgumentException("dest connection must be to a mongos router unless using shardToRs");
        }
    }

    public void shardCollections() {
        logger.debug("Starting shardCollections");
        this.sourceShardClient.populateCollectionsMap();
        this.enableDestinationSharding();
        this.shardDestinationCollections();
    }

    private boolean filterCheck(String nsStr) {
        Namespace ns = new Namespace(nsStr);
        return this.filterCheck(ns);
    }

    private boolean filterCheck(Namespace ns) {
        if (this.filtered && !this.includeNamespaces.contains(ns) && !this.includeDatabases.contains(ns.getDatabaseName())) {
            logger.trace("Namespace " + ns + " filtered, skipping");
            return true;
        }
        return ns.getDatabaseName().equals("config") || ns.getDatabaseName().equals("admin");
    }

    private Map<Namespace, Set<IndexSpec>> getIndexSpecs(MongoClient client, Set<String> filterSet) {
        LinkedHashMap<Namespace, Set<IndexSpec>> sourceIndexSpecs = new LinkedHashMap<Namespace, Set<IndexSpec>>();
        for (String dbName : client.listDatabaseNames()) {
            MongoDatabase sourceDb = client.getDatabase(dbName);
            for (String collectionName : sourceDb.listCollectionNames()) {
                Namespace ns = new Namespace(dbName, collectionName);
                if (this.filterCheck(ns) || filterSet != null && !filterSet.contains(ns.getNamespace())) continue;
                HashSet<IndexSpec> indexSpecs = new HashSet<IndexSpec>();
                sourceIndexSpecs.put(ns, indexSpecs);
                MongoCollection collection = sourceDb.getCollection(collectionName, RawBsonDocument.class);
                for (RawBsonDocument sourceSpec : collection.listIndexes(RawBsonDocument.class)) {
                    IndexSpec spec = null;
                    try {
                        spec = IndexSpec.fromDocument(sourceSpec);
                        indexSpecs.add(spec);
                    }
                    catch (BSONException be) {
                        logger.error("Error getting index spec: {}", (Object)sourceSpec);
                    }
                }
            }
        }
        return sourceIndexSpecs;
    }

    public void syncIndexesShards(boolean createMissing, boolean extendTtl) {
        logger.debug(String.format("Starting syncIndexes: extendTtl: %s", extendTtl));
        Map<Namespace, Set<IndexSpec>> sourceIndexSpecs = this.getIndexSpecs(this.sourceShardClient.getMongoClient(), null);
        Map<Namespace, Set<IndexSpec>> destShardIndexSpecs = this.getIndexSpecs(this.destShardClient.getMongoClient(), null);
        for (Map.Entry<Namespace, Set<IndexSpec>> sourceEntry : sourceIndexSpecs.entrySet()) {
            Namespace ns = sourceEntry.getKey();
            Set<IndexSpec> sourceSpecs = sourceEntry.getValue();
            if (!createMissing) continue;
            this.destShardClient.createIndexes(null, ns, sourceSpecs, extendTtl);
        }
    }

    public void migrateMetadata() throws InterruptedException {
        this.migrateMetadata(true, true);
    }

    public void migrateMetadata(boolean enableDestinationSharding, boolean compareAndMove) throws InterruptedException {
        logger.debug(String.format("Starting metadata sync/migration, %s: %s", "nonPrivileged", this.nonPrivilegedMode));
        this.stopBalancers();
        if (enableDestinationSharding) {
            this.enableDestinationSharding();
        }
        this.sourceShardClient.populateCollectionsMap();
        this.shardDestinationCollections();
        if (this.nonPrivilegedMode) {
            this.createDestChunksUsingSplitCommand();
        } else {
            this.createDestChunksUsingInsert();
            this.createShardTagsUsingInsert();
        }
        if (compareAndMove) {
            if (this.nonPrivilegedMode) {
                this.compareAndMoveChunks(true, false);
            } else {
                this.compareAndMoveChunks(true, false);
            }
        }
        if (!this.skipFlushRouterConfig) {
            this.destShardClient.flushRouterConfig();
        }
    }

    private void stopBalancers() {
        logger.debug("stopBalancers started");
        if (this.sourceClusterPattern == null) {
            try {
                this.sourceShardClient.stopBalancer();
            }
            catch (MongoCommandException mce) {
                logger.error("Could not stop balancer on source shard: " + mce.getMessage());
            }
        } else {
            logger.debug("Skipping source balancer stop, patterned uri");
        }
        if (this.destClusterPattern == null) {
            try {
                this.destShardClient.stopBalancer();
            }
            catch (MongoCommandException mce) {
                logger.error("Could not stop balancer on dest shard: " + mce.getMessage());
            }
        } else {
            logger.debug("Skipping dest balancer stop, patterned uri");
        }
        logger.debug("stopBalancers complete");
    }

    private void checkAutosplit() {
        this.sourceShardClient.checkAutosplit();
    }

    public void disableSourceAutosplit() {
        this.sourceShardClient.disableAutosplit();
    }

    private Document getChunkQuery() {
        Document chunkQuery = new Document();
        if (this.includeNamespaces.size() > 0 || this.includeDatabases.size() > 0) {
            ArrayList<String> inList = new ArrayList<String>();
            ArrayList<Object> orList = new ArrayList<Object>();
            chunkQuery.append("$or", orList);
            Document inDoc = new Document("ns", (Object)new Document("$in", inList));
            orList.add(inDoc);
            for (Namespace includeNs : this.includeNamespaces) {
                inList.add(includeNs.getNamespace());
            }
            for (String dbName : this.includeDatabases) {
                orList.add(Filters.regex((String)"ns", (String)("^" + dbName + "\\.")));
            }
        }
        return chunkQuery;
    }

    private boolean updateChunkCompletionStatus(RawBsonDocument chunk, String ns) {
        String sourceShardName = chunk.getString((Object)"shard").getValue();
        String mappedShard = this.getAltMapping(sourceShardName);
        Set<String> shards = this.nsToShardsCompletionMap.get(ns);
        if (shards != null && shards.contains(mappedShard)) {
            shards.remove(mappedShard);
            if (shards.isEmpty()) {
                logger.debug("{} has created 1 chunk for every shard", (Object)ns);
                this.nsToShardsCompletionMap.remove(ns);
                if (this.nsToShardsCompletionMap.isEmpty()) {
                    logger.debug("***** All namespaces have created 1 chunk for every shard", (Object)ns);
                }
            }
        }
        return false;
    }

    private void createDestChunksUsingSplitCommand() {
        this.createDestChunksUsingSplitCommand(null, false);
    }

    private void createDestChunksUsingSplitCommand(String nsFilter, boolean shortCircuit) {
        if (nsFilter == null) {
            logger.debug("createDestChunksUsingSplitCommand started");
        }
        Document chunkQuery = this.getChunkQuery();
        logger.debug("chunkQuery: {}", (Object)chunkQuery);
        if (nsFilter != null) {
            chunkQuery.append("ns", (Object)nsFilter);
        }
        this.nsToShardsCompletionMap = this.getChunksNsToShardsMap(chunkQuery);
        Map<String, RawBsonDocument> sourceChunksCache = this.sourceShardClient.loadChunksCache(chunkQuery);
        this.destShardClient.loadChunksCache(chunkQuery);
        String lastNs = null;
        int currentCount = 0;
        boolean nsComplete = false;
        for (RawBsonDocument chunk : sourceChunksCache.values()) {
            String ns = chunk.getString((Object)"ns").getValue();
            if (this.filterCheck(ns) || shortCircuit && !this.nsToShardsCompletionMap.containsKey(ns)) continue;
            this.destShardClient.createChunk((BsonDocument)chunk, true, true);
            nsComplete = this.updateChunkCompletionStatus(chunk, ns);
            ++currentCount;
            if (!ns.equals(lastNs) && lastNs != null) {
                logger.debug(String.format("%s - created %s chunks", lastNs, currentCount));
                currentCount = 0;
            }
            lastNs = ns;
        }
        logger.debug(String.format("%s - created %s chunks", lastNs, currentCount));
        if (nsFilter == null) {
            logger.debug("createDestChunksUsingSplitCommand complete");
        }
    }

    private void createMergedChunks() {
        logger.debug("createMergedChunks started");
        MongoCollection<RawBsonDocument> sourceChunksColl = this.sourceShardClient.getChunksCollectionRaw();
        Document chunkQuery = this.getChunkQuery();
        FindIterable sourceChunks = sourceChunksColl.find((Bson)chunkQuery).noCursorTimeout(true).sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        String lastNs = null;
        int currentCount = 0;
        for (RawBsonDocument chunk : sourceChunks) {
            String ns = chunk.getString((Object)"ns").getValue();
            if (this.filterCheck(ns)) continue;
            if (!ns.equals(lastNs) && lastNs != null) {
                logger.debug(String.format("%s - created %s chunks", lastNs, ++currentCount));
                currentCount = 0;
            }
            this.destShardClient.createChunk((BsonDocument)chunk, true, true);
            lastNs = ns;
            ++currentCount;
        }
        logger.debug("createDestChunksUsingSplitCommand complete");
    }

    private String getAltMapping(String sourceShardName) {
        if (!this.altSourceToDestShardMap.isEmpty()) {
            String newKey = this.altSourceToDestShardMap.get(sourceShardName);
            return newKey;
        }
        return this.sourceToDestShardMap.get(sourceShardName);
    }

    private String getSourceToDestShardMapping(String sourceShardName) {
        if (!this.altSourceToDestShardMap.isEmpty()) {
            String newKey = this.altSourceToDestShardMap.get(sourceShardName);
            String result = this.destToSourceShardMap.get(newKey);
            return result;
        }
        return this.sourceToDestShardMap.get(sourceShardName);
    }

    private void createShardTagsUsingInsert() {
        logger.debug("createShardTagsUsingInsert started");
        MongoCollection<Document> sourceShardsColl = this.sourceShardClient.getShardsCollection();
        FindIterable sourceShards = sourceShardsColl.find(Filters.exists((String)"tags.0"));
        for (Document shard : sourceShards) {
            String sourceShardName = shard.getString((Object)"_id");
            String mappedShard = this.sourceToDestShardMap.get(sourceShardName);
            List tags = (List)shard.get((Object)"tags");
            for (String tag : tags) {
                Document command = new Document("addShardToZone", (Object)mappedShard).append("zone", (Object)tag);
                logger.debug(String.format("addShardToZone('%s', '%s')", mappedShard, tag));
                this.destShardClient.adminCommand(command);
            }
        }
        MongoCollection<Document> sourceTagsColl = this.sourceShardClient.getTagsCollection();
        FindIterable sourceTags = sourceTagsColl.find().sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        for (Document tag : sourceTags) {
            logger.trace("tag: " + tag);
            String ns = tag.getString((Object)"ns");
            Namespace sourceNs = new Namespace(ns);
            if (this.filterCheck(sourceNs)) continue;
            Document command = new Document("updateZoneKeyRange", (Object)ns);
            command.append("min", tag.get((Object)"min"));
            command.append("max", tag.get((Object)"max"));
            command.append("zone", tag.get((Object)"tag"));
            this.destShardClient.adminCommand(command);
        }
        logger.debug("createShardTagsUsingInsert complete");
    }

    private Map<String, Set<String>> getChunksNsToShardsMap(Document chunkQuery) {
        AggregateIterable results = this.sourceShardClient.getChunksCollection().aggregate(Arrays.asList(Aggregates.match((Bson)chunkQuery), Aggregates.group((Object)"$ns", (BsonField[])new BsonField[]{Accumulators.addToSet((String)"shards", (Object)"$shard")})));
        HashMap<String, Set<String>> nsToShardsMap = new HashMap<String, Set<String>>();
        for (Document result : results) {
            String ns = result.getString((Object)"_id");
            List shards = result.getList((Object)"shards", String.class);
            HashSet<String> mappedShards = new HashSet<String>(shards.size());
            for (String shard : shards) {
                String mappedShard = this.getAltMapping(shard);
                mappedShards.add(mappedShard);
            }
            nsToShardsMap.put(ns, mappedShards);
        }
        nsToShardsMap.remove("config.system.sessions");
        return nsToShardsMap;
    }

    private void createDestChunksUsingInsert() {
        this.createDestChunksUsingSplitCommand(null, true);
        logger.debug("createDestChunksUsingInsert started");
        MongoCollection<RawBsonDocument> sourceChunksColl = this.sourceShardClient.getChunksCollectionRaw();
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        Document chunkQuery = this.getChunkQuery();
        this.destShardClient.loadChunksCache(chunkQuery);
        Map<String, Set<String>> nsToShardsMap = this.getChunksNsToShardsMap(chunkQuery);
        this.destShardClient.populateCollectionsMap();
        Map<String, Document> collectionsMap = this.destShardClient.getCollectionsMap();
        FindIterable sourceChunksIt = sourceChunksColl.find((Bson)chunkQuery).sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        ArrayList sourceChunks = new ArrayList();
        sourceChunksIt.into(sourceChunks);
        String lastNs = null;
        int currentCount = 0;
        int ts = 1;
        for (RawBsonDocument chunk : sourceChunks) {
            String ns = chunk.getString((Object)"ns").getValue();
            Document collectionMeta = collectionsMap.get(ns);
            Namespace sourceNs = new Namespace(ns);
            if (this.filterCheck(sourceNs)) continue;
            String sourceShardName = chunk.getString((Object)"shard").getValue();
            String mappedShard = this.getAltMapping(sourceShardName);
            if (mappedShard == null) {
                throw new IllegalArgumentException(String.format("mappedShard is null, sourceShardName: %s, chunk: %s", sourceShardName, chunk));
            }
            boolean firstChunk = false;
            Set<String> shards = nsToShardsMap.get(ns);
            if (shards.size() > 1 || !shards.contains(mappedShard)) {
                HashSet<String> t1 = new HashSet<String>();
                t1.add(mappedShard);
                Sets.SetView diff = Sets.difference(shards, t1);
                if (!diff.isEmpty()) {
                    String first;
                    firstChunk = true;
                    mappedShard = first = (String)diff.iterator().next();
                    shards.remove(mappedShard);
                }
            }
            if (firstChunk) {
                this.destShardClient.createChunk((BsonDocument)chunk, true, true);
            } else {
                Document newDoc = (Document)chunk.decode((Codec)this.documentCodec);
                newDoc.append("shard", (Object)mappedShard);
                newDoc.append("lastmod", (Object)new BsonTimestamp(ts++, 0));
                newDoc.append("lastmodEpoch", collectionMeta.get((Object)"lastmodEpoch"));
                if (newDoc.containsKey((Object)"history")) {
                    newDoc.remove((Object)"history");
                }
                try {
                    RawBsonDocument rawDoc = new RawBsonDocument((Object)newDoc, (Codec)this.documentCodec);
                    this.destShardClient.getChunksCollectionRaw().replaceOne(Filters.eq((String)"_id", (Object)rawDoc.get((Object)"_id")), (Object)rawDoc, replaceOptions);
                }
                catch (MongoException mce) {
                    logger.error(String.format("command error for namespace %s", ns), (Throwable)mce);
                }
            }
            if (!ns.equals(lastNs) && lastNs != null) {
                logger.debug(String.format("%s - created %s chunks", lastNs, ++currentCount));
                currentCount = 0;
            }
            lastNs = ns;
            ++currentCount;
        }
        logger.debug("createDestChunksUsingInsert complete");
    }

    public void compareChunks() {
        this.compareAndMoveChunks(false, false);
    }

    public void diffChunks(String dbName) {
        HashMap<String, Document> sourceChunkMap = new HashMap<String, Document>();
        MongoCollection<Document> sourceChunksColl = this.sourceShardClient.getChunksCollection();
        FindIterable sourceChunks = sourceChunksColl.find(Filters.regex((String)"ns", (String)("^" + dbName + "\\."))).sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        for (Document sourceChunk : sourceChunks) {
            String id = sourceChunk.getString((Object)"_id");
            sourceChunkMap.put(id, sourceChunk);
        }
        logger.debug("Done reading source chunks, count = " + sourceChunkMap.size());
        logger.debug("Reading destination chunks");
        HashMap<String, Document> destChunkMap = new HashMap<String, Document>();
        MongoCollection<Document> destChunksColl = this.destShardClient.getChunksCollection();
        FindIterable destChunks = destChunksColl.find(Filters.regex((String)"ns", (String)("^" + dbName + "\\."))).sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        for (Document destChunk : destChunks) {
            String id = destChunk.getString((Object)"_id");
            destChunkMap.put(id, destChunk);
            Document sourceChunk = (Document)sourceChunkMap.get(id);
            if (sourceChunk == null) {
                logger.debug("Source chunk not found: " + id);
                continue;
            }
            String sourceShard = sourceChunk.getString((Object)"shard");
            String mappedShard = this.sourceToDestShardMap.get(sourceShard);
            if (mappedShard == null) {
                throw new IllegalArgumentException("No destination shard mapping found for source shard: " + sourceShard);
            }
            String destShard = destChunk.getString((Object)"shard");
            if (destShard.equals(mappedShard)) continue;
            logger.warn("Chunk on wrong shard: " + id);
        }
        logger.debug("Done reading destination chunks, count = " + destChunkMap.size());
    }

    private Map<String, String> readDestinationChunks() {
        logger.debug("Reading destination chunks");
        HashMap<String, String> destChunkMap = new HashMap<String, String>();
        MongoCollection<RawBsonDocument> destChunksColl = this.destShardClient.getChunksCollectionRaw();
        FindIterable destChunks = destChunksColl.find().sort(Sorts.ascending((String[])new String[]{"ns", "min"}));
        for (RawBsonDocument destChunk : destChunks) {
            String id = ShardClient.getIdFromChunk((BsonDocument)destChunk);
            String shard = destChunk.getString((Object)"shard").getValue();
            destChunkMap.put(id, shard);
        }
        logger.debug("Done reading destination chunks, count = " + destChunkMap.size());
        return destChunkMap;
    }

    public void compareAndMoveChunks(boolean doMove, boolean ignoreMissing) {
        Map<String, String> destChunkMap = this.readDestinationChunks();
        MongoCollection<RawBsonDocument> sourceChunksColl = this.sourceShardClient.getChunksCollectionRaw();
        ArrayList sourceChunks = new ArrayList();
        sourceChunksColl.find().sort(Sorts.ascending((String[])new String[]{"ns", "min"})).into(sourceChunks);
        String lastNs = null;
        int currentCount = 0;
        int movedCount = 0;
        int mismatchedCount = 0;
        int matchedCount = 0;
        int missingCount = 0;
        int sourceTotalCount = 0;
        int errorCount = 0;
        for (RawBsonDocument sourceChunk : sourceChunks) {
            ++sourceTotalCount;
            String sourceId = ShardClient.getIdFromChunk((BsonDocument)sourceChunk);
            String sourceNs = sourceChunk.getString((Object)"ns").getValue();
            Namespace sourceNamespace = new Namespace(sourceNs);
            if (this.filterCheck(sourceNamespace)) continue;
            if (!sourceNs.equals(lastNs)) {
                if (currentCount > 0) {
                    logger.debug(String.format("compareAndMoveChunks - %s - complete, compared %s chunks", lastNs, currentCount));
                    currentCount = 0;
                }
                logger.debug(String.format("compareAndMoveChunks - %s - starting", sourceNs));
            } else if (currentCount > 0 && currentCount % 10000 == 0) {
                logger.debug(String.format("compareAndMoveChunks - %s - currentCount: %s chunks", sourceNs, currentCount));
            }
            RawBsonDocument sourceMin = (RawBsonDocument)sourceChunk.get((Object)"min");
            RawBsonDocument sourceMax = (RawBsonDocument)sourceChunk.get((Object)"max");
            String sourceShard = sourceChunk.getString((Object)"shard").getValue();
            String mappedShard = this.getAltMapping(sourceShard);
            if (mappedShard == null) {
                throw new IllegalArgumentException("No destination shard mapping found for source shard: " + sourceShard);
            }
            String destShard = destChunkMap.get(sourceId);
            if (destShard == null && !ignoreMissing) {
                logger.error("Chunk with _id " + sourceId + " not found on destination");
                ++missingCount;
            } else if (doMove && !mappedShard.equals(destShard)) {
                boolean moveSuccess;
                if (doMove && !(moveSuccess = this.destShardClient.moveChunk(sourceNs, sourceMin, sourceMax, mappedShard, ignoreMissing))) {
                    ++errorCount;
                }
                ++movedCount;
            } else if (!doMove) {
                if (!mappedShard.equals(destShard)) {
                    logger.debug(String.format("mismatch: %s ==> %s", destShard, mappedShard));
                    logger.debug("dest chunk is on wrong shard for sourceChunk: " + sourceChunk);
                    ++mismatchedCount;
                }
                ++matchedCount;
            }
            ++currentCount;
            lastNs = sourceNs;
        }
        logger.debug(String.format("compareAndMoveChunks - %s - complete, compared %s chunks", lastNs, currentCount));
        if (doMove) {
            logger.debug(String.format("compareAndMoveChunks complete, sourceCount: %s, destCount: %s", sourceTotalCount, destChunkMap.size()));
        } else {
            logger.debug(String.format("compareAndMoveChunks complete, sourceCount: %s, destCount: %s, mismatchedCount: %s, missingCount: %s", sourceTotalCount, destChunkMap.size(), mismatchedCount, missingCount));
        }
    }

    public void compareShardCounts() {
        logger.debug("Starting compareShardCounts mode");
        Document listDatabases = new Document("listDatabases", (Object)1);
        Document sourceDatabases = this.sourceShardClient.adminCommand(listDatabases);
        Document destDatabases = this.destShardClient.adminCommand(listDatabases);
        List sourceDatabaseInfo = (List)sourceDatabases.get((Object)"databases");
        List destDatabaseInfo = (List)destDatabases.get((Object)"databases");
        this.populateDbMap(sourceDatabaseInfo, this.sourceDbInfoMap);
        this.populateDbMap(destDatabaseInfo, this.destDbInfoMap);
        for (Document sourceInfo : sourceDatabaseInfo) {
            String dbName = sourceInfo.getString((Object)"name");
            if (this.filtered && !this.includeDatabasesAll.contains(dbName) || dbName.equals("config")) {
                logger.debug("Ignore " + dbName + " for compare, filtered");
                continue;
            }
            Document destInfo = this.destDbInfoMap.get(dbName);
            if (destInfo != null) {
                logger.debug(String.format("Found matching database %s", dbName));
                long sourceTotal = 0L;
                long destTotal = 0L;
                int collCount = 0;
                MongoDatabase sourceDb = this.sourceShardClient.getMongoClient().getDatabase(dbName);
                MongoDatabase destDb = this.destShardClient.getMongoClient().getDatabase(dbName);
                MongoIterable sourceCollectionNames = sourceDb.listCollectionNames();
                for (String collectionName : sourceCollectionNames) {
                    if (collectionName.startsWith("system.")) continue;
                    Namespace ns = new Namespace(dbName, collectionName);
                    if (this.filtered && !this.includeNamespaces.contains(ns)) continue;
                    long[] result = this.doCounts(sourceDb, destDb, collectionName);
                    sourceTotal += result[0];
                    destTotal += result[1];
                    ++collCount;
                }
                logger.debug("Database {} - source count sourceTotal: {}, dest count sourceTotal {}", new Object[]{dbName, sourceTotal, destTotal});
                continue;
            }
            logger.warn(String.format("Destination db not found, name: %s", dbName));
        }
    }

    public void cleanupPreviousShards(Set<String> shardNames) {
        logger.debug("Starting cleanupPreviousShards: [{}]", (Object)StringUtils.join(shardNames, (String)", "));
        Set<String> destShardNames = this.destShardClient.getShardsMap().keySet();
        boolean fatal = false;
        for (String shardName : shardNames) {
            if (destShardNames.contains(shardName)) continue;
            logger.error("cleanupPreviousShards shardName {} not found on destination", (Object)shardName);
            fatal = true;
        }
        if (fatal) {
            throw new IllegalArgumentException("cleanupPreviousShards: one or more shard names provided were not found on dest");
        }
        if (destShardNames.size() < 2) {
            throw new IllegalArgumentException("cleanupPreviousShards: 2 or more shards required on destination to use this option");
        }
        this.destShardClient.populateShardMongoClients();
        Document listDatabases = new Document("listDatabases", (Object)1);
        Document destDatabases = this.destShardClient.adminCommand(listDatabases);
        List destDatabaseInfo = (List)destDatabases.get((Object)"databases");
        this.populateDbMap(destDatabaseInfo, this.destDbInfoMap);
        MongoCollection<RawBsonDocument> destChunksColl = this.destShardClient.getChunksCollectionRaw();
        for (Document destInfo : destDatabaseInfo) {
            String dbName = destInfo.getString((Object)"name");
            MongoDatabase destDb = this.destShardClient.getMongoClient().getDatabase(dbName);
            ArrayList destCollectionNames = new ArrayList();
            destDb.listCollectionNames().into(destCollectionNames);
            for (String collectionName : destCollectionNames) {
                Namespace ns;
                if (collectionName.startsWith("system.") || this.filterCheck(ns = new Namespace(dbName, collectionName))) continue;
                for (String shardName : shardNames) {
                    HashSet<String> t1 = new HashSet<String>();
                    t1.add(shardName);
                    Sets.SetView otherShards = Sets.difference(destShardNames, t1);
                    if (!otherShards.isEmpty()) {
                        logger.debug("current shard: {}, otherShards: {}", (Object)shardName, (Object)otherShards);
                    }
                    MongoDatabase db = this.destShardClient.getShardMongoClient(shardName).getDatabase(dbName);
                    RawBsonDocument firstChunk = (RawBsonDocument)destChunksColl.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"ns", (Object)ns.getNamespace()), Filters.eq((String)"shard", (Object)shardName)})).first();
                    if (firstChunk == null) continue;
                    logger.debug("first chunk {}", (Object)firstChunk);
                    logger.debug("dropping {} on shard {}", (Object)ns, (Object)shardName);
                    String otherShard = (String)otherShards.iterator().next();
                    boolean firstMove = this.destShardClient.moveChunk(firstChunk, otherShard, false);
                    if (!firstMove) continue;
                    logger.debug("firstMove done");
                    db.getCollection(collectionName).drop();
                    this.destShardClient.moveChunk(firstChunk, shardName, false);
                }
            }
        }
        logger.debug("Finished cleanupPrevious");
    }

    public void cleanupPreviousAll() {
        logger.debug("Starting cleanupPreviousAll");
        Document listDatabases = new Document("listDatabases", (Object)1);
        Document destDatabases = this.destShardClient.adminCommand(listDatabases);
        List destDatabaseInfo = (List)destDatabases.get((Object)"databases");
        this.populateDbMap(destDatabaseInfo, this.destDbInfoMap);
        Document nullFilter = new Document();
        for (Document destInfo : destDatabaseInfo) {
            String dbName = destInfo.getString((Object)"name");
            MongoDatabase destDb = this.destShardClient.getMongoClient().getDatabase(dbName);
            ArrayList destCollectionNames = new ArrayList();
            destDb.listCollectionNames().into(destCollectionNames);
            for (String collectionName : destCollectionNames) {
                long count;
                Namespace ns;
                if (collectionName.startsWith("system.") || this.filterCheck(ns = new Namespace(dbName, collectionName))) continue;
                DeleteResult deleteResult = null;
                try {
                    deleteResult = destDb.getCollection(collectionName).deleteMany((Bson)nullFilter);
                }
                catch (MongoException me) {
                    logger.error("{}: delete error: {}", (Object)ns, (Object)me.getMessage());
                }
                if (deleteResult == null || (count = deleteResult.getDeletedCount()) <= 0L) continue;
                logger.debug("{}: deleted {} doucments on destination", (Object)ns, (Object)count);
            }
        }
        logger.debug("Finished cleanupPrevious");
    }

    private long[] doCounts(MongoDatabase sourceDb, MongoDatabase destDb, String collectionName) {
        return this.doCounts(sourceDb, destDb, collectionName, null);
    }

    private long[] doCounts(MongoDatabase sourceDb, MongoDatabase destDb, String collectionName, Bson query) {
        long[] result = new long[2];
        Long sourceCount = null;
        Long destCount = null;
        if (query == null) {
            sourceCount = sourceDb.getCollection(collectionName).countDocuments();
            destCount = destDb.getCollection(collectionName).countDocuments();
        } else {
            sourceCount = sourceDb.getCollection(collectionName).countDocuments(query);
            destCount = destDb.getCollection(collectionName).countDocuments(query);
        }
        result[0] = sourceCount;
        result[1] = destCount;
        if (sourceCount.equals(destCount)) {
            logger.debug(String.format("%s.%s count matches: %s", sourceDb.getName(), collectionName, sourceCount));
            return result;
        }
        logger.warn(String.format("%s.%s count MISMATCH - source: %s, dest: %s, query: %s", sourceDb.getName(), collectionName, sourceCount, destCount, query));
        return result;
    }

    public void compareChunkCounts() {
        for (String databaseName : this.sourceShardClient.listDatabaseNames()) {
            MongoDatabase db = this.sourceShardClient.getMongoClient().getDatabase(databaseName);
            if (databaseName.equals("admin") || databaseName.equals("config") || databaseName.contentEquals("local")) continue;
            for (Document collectionInfo : db.listCollections()) {
                String collectionName = (String)collectionInfo.get((Object)"name");
                if (collectionName.endsWith(".create")) continue;
                Namespace ns = new Namespace(databaseName, collectionName);
                if (this.filtered && !this.includeNamespaces.contains(ns)) {
                    logger.debug("compareChunkCounts skipping {}, filtered", (Object)ns);
                    continue;
                }
                this.compareChunkCounts(ns);
            }
        }
    }

    public void compareChunkCounts(Namespace ns) {
        this.destShardClient.populateCollectionsMap();
        Document shardCollection = this.destShardClient.getCollectionsMap().get(ns.getNamespace());
        if (shardCollection == null) {
            logger.warn("Collection {} is not sharded, cannot do chunk compare", (Object)ns);
        } else {
            MongoDatabase sourceDb = this.sourceShardClient.getMongoClient().getDatabase(ns.getDatabaseName());
            MongoDatabase destDb = this.destShardClient.getMongoClient().getDatabase(ns.getDatabaseName());
            Document shardKeysDoc = (Document)shardCollection.get((Object)"key");
            Set shardKeys = shardKeysDoc.keySet();
            MongoCollection<Document> chunksCollection = this.destShardClient.getChunksCollection();
            FindIterable sourceChunks = chunksCollection.find(Filters.eq((String)"ns", (Object)ns.getNamespace())).sort(Sorts.ascending((String[])new String[]{"min"}));
            for (Document sourceChunk : sourceChunks) {
                String id = sourceChunk.getString((Object)"_id");
                Document min = (Document)sourceChunk.get((Object)"min");
                Document max = (Document)sourceChunk.get((Object)"max");
                Bson chunkQuery = null;
                if (shardKeys.size() > 1) {
                    ArrayList<Bson> filters = new ArrayList<Bson>(shardKeys.size());
                    for (String key : shardKeys) {
                        filters.add(Filters.and((Bson[])new Bson[]{Filters.gte((String)key, (Object)min.get((Object)key)), Filters.lt((String)key, (Object)max.get((Object)key))}));
                    }
                    chunkQuery = Filters.and(filters);
                } else {
                    String key = (String)shardKeys.iterator().next();
                    chunkQuery = Filters.and((Bson[])new Bson[]{Filters.gte((String)key, (Object)min.get((Object)key)), Filters.lt((String)key, (Object)max.get((Object)key))});
                }
                long[] lArray = this.doCounts(sourceDb, destDb, ns.getCollectionName(), chunkQuery);
            }
        }
    }

    public void compareCollectionUuids() {
        this.destShardClient.compareCollectionUuids();
    }

    private void populateDbMap(List<Document> dbInfoList, Map<String, Document> databaseMap) {
        for (Document dbInfo : dbInfoList) {
            databaseMap.put(dbInfo.getString((Object)"name"), dbInfo);
        }
    }

    public void shardDestinationCollections() {
        this.shardDestinationCollectionsUsingShardCommand();
    }

    private void shardDestinationCollectionsUsingInsert() {
        logger.debug("shardDestinationCollectionsUsingInsert(), privileged mode");
        MongoCollection destColls = this.destShardClient.getConfigDb().getCollection("collections", RawBsonDocument.class);
        ReplaceOptions options = new ReplaceOptions().upsert(true);
        for (Document sourceColl : this.sourceShardClient.getCollectionsMap().values()) {
            String nsStr = (String)sourceColl.get((Object)"_id");
            Namespace ns = new Namespace(nsStr);
            if (this.filterCheck(ns)) continue;
            RawBsonDocument rawDoc = new RawBsonDocument((Object)sourceColl, (Codec)this.documentCodec);
            destColls.replaceOne((Bson)new Document("_id", (Object)nsStr), (Object)rawDoc, options);
        }
        logger.debug("shardDestinationCollectionsUsingInsert() complete");
    }

    private void shardDestinationCollectionsUsingShardCommand() {
        logger.debug("shardDestinationCollectionsUsingShardCommand(), non-privileged mode");
        for (Document sourceColl : this.sourceShardClient.getCollectionsMap().values()) {
            String nsStr = (String)sourceColl.get((Object)"_id");
            Namespace ns = new Namespace(nsStr);
            if (this.filterCheck(ns)) continue;
            this.shardCollection(sourceColl);
            if (!((Boolean)sourceColl.get((Object)"noBalance", (Object)false)).booleanValue()) continue;
            logger.warn(String.format("Balancing is disabled for %s, this is not possible in Atlas", nsStr));
        }
        logger.debug("shardDestinationCollectionsUsingShardCommand() complete");
    }

    private Document shardCollection(ShardCollection sourceColl) {
        Document shardCommand = new Document("shardCollection", (Object)sourceColl.getId());
        shardCommand.append("key", (Object)sourceColl.getKey());
        shardCommand.append("unique", (Object)sourceColl.isUnique());
        if (sourceColl.getDefaultCollation() != null) {
            shardCommand.append("collation", (Object)LOCALE_SIMPLE);
        }
        Document result = null;
        try {
            result = this.destShardClient.adminCommand(shardCommand);
        }
        catch (MongoCommandException mce) {
            if (mce.getCode() == 20) {
                logger.debug(String.format("Sharding already enabled for %s", sourceColl.getId()));
            }
            throw mce;
        }
        return result;
    }

    private Document shardCollection(Document sourceColl) {
        Document shardCommand = new Document("shardCollection", sourceColl.get((Object)"_id"));
        Document key = (Document)sourceColl.get((Object)"key");
        shardCommand.append("key", (Object)key);
        shardCommand.append("unique", sourceColl.get((Object)"unique"));
        Object key1 = key.values().iterator().next();
        if ("hashed".equals(key1)) {
            shardCommand.append("numInitialChunks", (Object)1);
        }
        Document result = null;
        try {
            result = this.destShardClient.adminCommand(shardCommand);
        }
        catch (MongoCommandException mce) {
            if (mce.getCode() == 20) {
                logger.debug(String.format("Sharding already enabled for %s", sourceColl.get((Object)"_id")));
            }
            logger.error(String.format("Error sharding collection %s", sourceColl.get((Object)"_id")));
        }
        return result;
    }

    public void diffShardedCollections(boolean sync) {
        logger.debug("diffShardedCollections()");
        this.sourceShardClient.populateCollectionsMap();
        this.destShardClient.populateCollectionsMap();
        for (Document sourceColl : this.sourceShardClient.getCollectionsMap().values()) {
            String nsStr = (String)sourceColl.get((Object)"_id");
            Namespace ns = new Namespace(nsStr);
            if (this.filterCheck(ns)) continue;
            Document destCollection = this.destShardClient.getCollectionsMap().get(sourceColl.get((Object)"_id"));
            if (destCollection == null) {
                logger.debug("Destination collection not found: " + sourceColl.get((Object)"_id") + " sourceKey:" + sourceColl.get((Object)"key"));
                if (!sync) continue;
                try {
                    Document result = this.shardCollection(sourceColl);
                    logger.debug("Sharded: " + result);
                }
                catch (MongoCommandException mce) {
                    logger.error("Error sharding", (Throwable)mce);
                }
                continue;
            }
            if (sourceColl.get((Object)"key").equals(destCollection.get((Object)"key"))) {
                logger.debug("Shard key match for " + sourceColl);
                continue;
            }
            logger.warn("Shard key MISMATCH for " + sourceColl + " sourceKey:" + sourceColl.get((Object)"key") + " destKey:" + destCollection.get((Object)"key"));
        }
    }

    public void enableDestinationSharding() {
        this.sourceShardClient.populateShardMongoClients();
        logger.debug("enableDestinationSharding()");
        MongoCollection databasesColl = this.sourceShardClient.getConfigDb().getCollection("databases");
        FindIterable databases = databasesColl.find();
        ArrayList databasesList = new ArrayList();
        databases.into(databasesList);
        for (Document database : databasesList) {
            String databaseName = database.getString((Object)"_id");
            if (databaseName.equals("admin") || databaseName.equals("system") || databaseName.equals("local") || databaseName.contains("$")) continue;
            String primary = database.getString((Object)"primary");
            String xx = this.sourceToDestShardMap.get(primary);
            String mappedPrimary = this.getAltMapping(primary);
            logger.debug("database: " + databaseName + ", primary: " + primary + ", mappedPrimary: " + mappedPrimary);
            if (mappedPrimary == null) {
                logger.warn("Shard mapping not found for shard " + primary);
            }
            if (this.filtered && !this.includeDatabasesAll.contains(databaseName)) {
                logger.trace("Database " + databaseName + " filtered, not sharding on destination");
                continue;
            }
            Document dest = (Document)this.destShardClient.getConfigDb().getCollection("databases").find((Bson)new Document("_id", (Object)databaseName)).first();
            if (database.getBoolean((Object)"partitioned", true)) {
                logger.debug(String.format("enableSharding: %s", databaseName));
                try {
                    this.destShardClient.adminCommand(new Document("enableSharding", (Object)databaseName));
                }
                catch (MongoCommandException mce) {
                    if (mce.getCode() == 23 && mce.getErrorMessage().contains("sharding already enabled")) {
                        logger.debug("Sharding already enabled: " + databaseName);
                    }
                    throw mce;
                }
            }
            String zz = this.destToSourceShardMap.get(mappedPrimary);
            MongoClient primaryClient = this.sourceShardClient.getShardMongoClient(zz);
            ArrayList primaryDatabasesList = new ArrayList();
            primaryClient.listDatabaseNames().into(primaryDatabasesList);
            if (!primaryDatabasesList.contains(databaseName)) {
                logger.debug("Database: " + databaseName + " does not exist on source shard, skipping");
                continue;
            }
            dest = this.destShardClient.createDatabase(databaseName);
            logger.debug("dest db: " + dest);
            String destPrimary = dest.getString((Object)"primary");
            if (mappedPrimary.equals(destPrimary)) {
                logger.debug("Primary shard already matches for database: " + databaseName);
                continue;
            }
            logger.debug("movePrimary for database: " + databaseName + " from " + destPrimary + " to " + mappedPrimary);
            try {
                this.destShardClient.adminCommand(new Document("movePrimary", (Object)databaseName).append("to", (Object)mappedPrimary));
            }
            catch (MongoCommandException mce) {
                logger.warn("movePrimary for database: " + databaseName + " failed. Maybe it doesn't exist?");
            }
        }
        logger.debug("enableDestinationSharding() complete");
    }

    public void dropDestinationDatabases() {
        logger.debug("dropDestinationDatabases()");
        this.destShardClient.populateShardMongoClients();
        MongoCollection<Document> databasesColl = this.sourceShardClient.getDatabasesCollection();
        FindIterable databases = databasesColl.find();
        ArrayList<String> databasesList = new ArrayList<String>();
        for (Document database : databases) {
            String databaseName = database.getString((Object)"_id");
            if (this.filtered && !this.includeDatabases.contains(databaseName)) {
                logger.trace("Database " + databaseName + " filtered, not dropping on destination");
                continue;
            }
            databasesList.add(databaseName);
        }
        this.destShardClient.dropDatabases(databasesList);
        logger.debug("dropDestinationDatabases() complete");
    }

    public void dropDestinationDatabasesAndConfigMetadata() {
        logger.debug("dropDestinationDatabasesAndConfigMetadata()");
        this.destShardClient.populateShardMongoClients();
        MongoCollection<Document> databasesColl = this.sourceShardClient.getDatabasesCollection();
        FindIterable databases = databasesColl.find();
        ArrayList<String> databasesList = new ArrayList<String>();
        for (Document database : databases) {
            String databaseName = database.getString((Object)"_id");
            if (this.filtered && !this.includeDatabases.contains(databaseName)) {
                logger.trace("Database " + databaseName + " filtered, not dropping on destination");
                continue;
            }
            databasesList.add(databaseName);
        }
        this.destShardClient.dropDatabasesAndConfigMetadata(databasesList);
        logger.debug("dropDestinationDatabasesAndConfigMetadata() complete");
    }

    public void cleanupOrphans() {
        logger.debug("cleanupOrphans()");
        this.sourceShardClient.populateCollectionsMap();
        this.sourceShardClient.populateShardMongoClients();
        CleanupOrphaned cleaner = new CleanupOrphaned(this.sourceShardClient, this.includeNamespaces);
        cleaner.cleanupOrphans(this.cleanupOrphansSleepMillis);
    }

    public void cleanupOrphansDest() {
        logger.debug("cleanupOrphansDest()");
        this.destShardClient.populateCollectionsMap();
        this.destShardClient.populateShardMongoClients();
        CleanupOrphaned cleaner = new CleanupOrphaned(this.destShardClient, this.includeNamespaces);
        cleaner.cleanupOrphans(this.cleanupOrphansSleepMillis);
    }

    public String getSourceClusterUri() {
        return this.sourceClusterUri;
    }

    public void setSourceClusterUri(String sourceClusterUri) {
        this.sourceClusterUri = sourceClusterUri;
    }

    public String getDestClusterUri() {
        return this.destClusterUri;
    }

    public void setDestClusterUri(String destClusterUri) {
        this.destClusterUri = destClusterUri;
    }

    public boolean isDropDestDbs() {
        return this.dropDestDbs;
    }

    public void setDropDestDbs(boolean dropDestinationCollectionsIfExisting) {
        this.dropDestDbs = dropDestinationCollectionsIfExisting;
    }

    public void setDoChunkCounts(boolean doChunkCounts) {
        this.doChunkCounts = doChunkCounts;
    }

    public void setNamespaceFilters(String[] namespaceFilterList) {
        if (namespaceFilterList == null) {
            return;
        }
        this.filtered = true;
        String[] stringArray = namespaceFilterList;
        int n = namespaceFilterList.length;
        int n2 = 0;
        while (n2 < n) {
            String nsStr = stringArray[n2];
            if (nsStr.contains(".")) {
                Namespace ns = new Namespace(nsStr);
                this.includeNamespaces.add(ns);
                this.includeDatabasesAll.add(ns.getDatabaseName());
            } else {
                this.includeDatabases.add(nsStr);
                this.includeDatabasesAll.add(nsStr);
            }
            ++n2;
        }
    }

    public void setShardMappings(String[] shardMap) {
        this.shardMap = shardMap;
    }

    public void shardToRs() throws ExecuteException, IOException {
        logger.debug("shardToRs() starting");
        ArrayList<MongoMirrorRunner> mongomirrors = new ArrayList<MongoMirrorRunner>(this.sourceShardClient.getShardsMap().size());
        int httpStatusPort = this.mongoMirrorStartPort;
        for (Shard source : this.sourceShardClient.getShardsMap().values()) {
            logger.debug("sourceShard: " + source.getId());
            MongoMirrorRunner mongomirror = new MongoMirrorRunner(source.getId());
            mongomirrors.add(mongomirror);
            mongomirror.setSourceHost(source.getHost());
            MongoCredential sourceCredentials = this.sourceShardClient.getConnectionString().getCredential();
            if (sourceCredentials != null) {
                mongomirror.setSourceUsername(sourceCredentials.getUserName());
                mongomirror.setSourcePassword(new String(sourceCredentials.getPassword()));
                mongomirror.setSourceAuthenticationDatabase(sourceCredentials.getSource());
            }
            if (this.sourceShardClient.getConnectionString().getSslEnabled() != null) {
                mongomirror.setSourceSsl(this.sourceShardClient.getConnectionString().getSslEnabled());
            }
            ClusterDescription cd = this.destShardClient.getMongoClient().getClusterDescription();
            ServerDescription s1 = (ServerDescription)cd.getServerDescriptions().get(0);
            String setName = s1.getSetName();
            ConnectionString cs = this.destShardClient.getConnectionString();
            String host = (String)this.destShardClient.getConnectionString().getHosts().get(0);
            mongomirror.setDestinationHost(String.valueOf(setName) + "/" + host);
            MongoCredential destCredentials = this.destShardClient.getConnectionString().getCredential();
            if (destCredentials != null) {
                mongomirror.setDestinationUsername(destCredentials.getUserName());
                mongomirror.setDestinationPassword(new String(destCredentials.getPassword()));
                mongomirror.setDestinationAuthenticationDatabase(destCredentials.getSource());
            }
            if (this.destShardClient.getConnectionString().getSslEnabled() == null || this.destShardClient.getConnectionString().getSslEnabled().equals(Boolean.FALSE)) {
                mongomirror.setDestinationNoSSL(true);
            }
            for (Namespace ns : this.includeNamespaces) {
                mongomirror.addIncludeNamespace(ns);
            }
            for (String dbName : this.includeDatabases) {
                mongomirror.addIncludeDatabase(dbName);
            }
            mongomirror.setMongomirrorBinary(this.mongomirrorBinary);
            String dateStr = this.formatter.format(LocalDateTime.now());
            mongomirror.setBookmarkFile(String.valueOf(source.getId()) + ".timestamp");
            mongomirror.setNumParallelCollections(this.numParallelCollections);
            mongomirror.setHttpStatusPort(httpStatusPort++);
            mongomirror.execute(this.dryRun);
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.pollMongomirrorStatus(mongomirrors);
    }

    public void mongomirrorTailFromLatestOplogTs(String startingTs) throws IOException {
        logger.debug("Starting mongomirrorTailFromTs, startingTs: {}", (Object)startingTs);
        this.sourceShardClient.populateShardMongoClients();
        Collection<Shard> shards = this.sourceShardClient.getShardsMap().values();
        for (Shard shard : shards) {
            ShardTimestamp st = this.sourceShardClient.populateLatestOplogTimestamp(shard.getId(), startingTs);
            logger.debug(st.toString());
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(String.valueOf(shard.getId()) + ".timestamp")));
                writer.write(shard.getRsName());
                writer.newLine();
                writer.write(String.valueOf(st.getTimestamp().getValue()));
                writer.close();
            }
            catch (IOException e) {
                logger.error(String.format("Error writing timestamp file for shard %s", shard.getId()), (Throwable)e);
                throw e;
            }
        }
        this.mongomirror();
    }

    public void mongomirrorTailFromTs(String ts) throws IOException {
        String[] tsParts = ts.split(",");
        int seconds = Integer.parseInt(tsParts[0]);
        int increment = Integer.parseInt(tsParts[1]);
        BsonTimestamp bsonTs = new BsonTimestamp(seconds, increment);
        this.mongomirrorTailFromTs(bsonTs);
    }

    public void mongomirrorTailFromNow() throws IOException {
        long now = System.currentTimeMillis();
        long nowSeconds = now / 1000L;
        BsonTimestamp nowBson = new BsonTimestamp((int)nowSeconds, 1);
        logger.debug(String.format("Starting mongomirrorTailFromTs, now: %s, nowSeconds: %s, nowBson: %s", now, nowSeconds, nowBson));
        this.mongomirrorTailFromTs(nowBson);
    }

    private void mongomirrorTailFromTs(BsonTimestamp nowBson) throws IOException {
        Collection<Shard> shards = this.sourceShardClient.getShardsMap().values();
        logger.debug("shardCount: " + shards.size());
        for (Shard shard : shards) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(String.valueOf(shard.getId()) + ".timestamp")));
                writer.write(shard.getRsName());
                writer.newLine();
                writer.write(String.valueOf(nowBson.getValue()));
                writer.close();
            }
            catch (IOException e) {
                logger.error(String.format("Error writing timestamp file for shard %s", shard.getId()), (Throwable)e);
                throw e;
            }
        }
        this.mongomirror();
    }

    public void mongomirror() throws ExecuteException, IOException {
        this.destShardClient.populateShardMongoClients();
        ArrayList<MongoMirrorRunner> mongomirrors = new ArrayList<MongoMirrorRunner>(this.sourceShardClient.getShardsMap().size());
        int httpStatusPort = this.mongoMirrorStartPort;
        for (Shard source : this.sourceShardClient.getShardsMap().values()) {
            MongoMirrorRunner mongomirror = new MongoMirrorRunner(source.getId());
            mongomirrors.add(mongomirror);
            mongomirror.setSourceHost(source.getHost());
            MongoCredential sourceCredentials = this.sourceShardClient.getConnectionString().getCredential();
            if (sourceCredentials != null) {
                mongomirror.setSourceUsername(sourceCredentials.getUserName());
                mongomirror.setSourcePassword(new String(sourceCredentials.getPassword()));
                mongomirror.setSourceAuthenticationDatabase(sourceCredentials.getSource());
            }
            if (this.sourceShardClient.getConnectionString().getSslEnabled() != null) {
                mongomirror.setSourceSsl(this.sourceShardClient.getConnectionString().getSslEnabled());
            }
            ClusterDescription cd = this.destShardClient.getMongoClient().getClusterDescription();
            String destShardId = this.sourceToDestShardMap.get(source.getId());
            Shard dest = this.destShardClient.getShardsMap().get(destShardId);
            String host = dest.getHost();
            logger.debug(String.format("Creating MongoMirrorRunner for %s ==> %s", source.getId(), dest.getId()));
            mongomirror.setDestinationHost(host);
            MongoCredential destCredentials = this.destShardClient.getConnectionString().getCredential();
            if (destCredentials != null) {
                mongomirror.setDestinationUsername(destCredentials.getUserName());
                mongomirror.setDestinationPassword(new String(destCredentials.getPassword()));
                mongomirror.setDestinationAuthenticationDatabase(destCredentials.getSource());
            }
            if (this.destShardClient.getConnectionString().getSslEnabled() == null || this.destShardClient.getConnectionString().getSslEnabled().equals(Boolean.FALSE)) {
                mongomirror.setDestinationNoSSL(true);
            }
            for (Namespace ns : this.includeNamespaces) {
                mongomirror.addIncludeNamespace(ns);
            }
            for (String dbName : this.includeDatabases) {
                mongomirror.addIncludeDatabase(dbName);
            }
            mongomirror.setMongomirrorBinary(this.mongomirrorBinary);
            mongomirror.setBookmarkFile(String.valueOf(source.getId()) + ".timestamp");
            mongomirror.setNumParallelCollections(this.numParallelCollections);
            mongomirror.setWriteConcern(this.writeConcern);
            mongomirror.setHttpStatusPort(httpStatusPort++);
            logger.debug("here: skipBuildIndexes=" + this.skipBuildIndexes);
            if (this.skipBuildIndexes) {
                mongomirror.setSkipBuildIndexes(this.skipBuildIndexes);
            }
            if (this.compressors != null) {
                mongomirror.setCompressors(this.compressors);
            }
            if (this.oplogBasePath != null) {
                mongomirror.setOplogPath(String.format("%s/%s", this.oplogBasePath, source.getId()));
            }
            if (this.collStatsThreshold != null) {
                mongomirror.setCollStatsThreshold(this.collStatsThreshold);
            }
            mongomirror.execute(this.dryRun);
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.pollMongomirrorStatus(mongomirrors);
    }

    public void pollMongomirrorStatus(List<MongoMirrorRunner> mongomirrors) {
        if (this.dryRun) {
            return;
        }
        block2: while (true) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Iterator<MongoMirrorRunner> iterator = mongomirrors.iterator();
            while (true) {
                MongoMirrorStatus st;
                if (!iterator.hasNext()) continue block2;
                MongoMirrorRunner mongomirror = iterator.next();
                MongoMirrorStatus status = mongomirror.checkStatus();
                if (status == null) continue;
                if (status.getErrorMessage() != null) {
                    logger.error(String.format("%s - mongomirror error %s", mongomirror.getId(), status.getErrorMessage()));
                    continue;
                }
                if (status.isInitialSync()) {
                    st = (MongoMirrorStatusInitialSync)status;
                    if (((MongoMirrorStatusInitialSync)st).isCopyingIndexes()) {
                        logger.debug(String.format("%-15s - %-18s %-22s", mongomirror.getId(), status.getStage(), status.getPhase()));
                        continue;
                    }
                    double cs = ((MongoMirrorStatusInitialSync)st).getCompletionPercent();
                    logger.debug(String.format("%-15s - %-18s %-22s %6.2f%% complete", mongomirror.getId(), status.getStage(), status.getPhase(), cs));
                    continue;
                }
                if (status.isOplogSync()) {
                    st = (MongoMirrorStatusOplogSync)status;
                    logger.debug(String.format("%-15s - %-18s %-22s %s lag from source", mongomirror.getId(), status.getStage(), status.getPhase(), ((MongoMirrorStatusOplogSync)st).getLagPretty()));
                    continue;
                }
                logger.debug(String.format("%-15s - %-18s %-22s", mongomirror.getId(), status.getStage(), status.getPhase()));
            }
            break;
        }
    }

    public void setMongomirrorBinary(String binaryPath) {
        if (binaryPath != null) {
            this.mongomirrorBinary = new File(binaryPath);
        }
    }

    public void setSleepMillis(String optionValue) {
        if (optionValue != null) {
            this.sleepMillis = Long.parseLong(optionValue);
        }
    }

    public void setNumParallelCollections(String numParallelCollections) {
        this.numParallelCollections = numParallelCollections;
    }

    public void setNonPrivilegedMode(boolean nonPrivilegedMode) {
        this.nonPrivilegedMode = nonPrivilegedMode;
    }

    public void flushRouterConfig() {
        this.destShardClient.flushRouterConfig();
    }

    public void setDropDestDbsAndConfigMetadata(boolean dropDestinationConfigMetadata) {
        this.dropDestDbsAndConfigMetadata = dropDestinationConfigMetadata;
    }

    public void setSslAllowInvalidHostnames(boolean sslAllowInvalidHostnames) {
        this.sslAllowInvalidHostnames = sslAllowInvalidHostnames;
    }

    public void setSslAllowInvalidCertificates(boolean sslAllowInvalidCertificates) {
        this.sslAllowInvalidCertificates = sslAllowInvalidCertificates;
    }

    public void setPreserveUUIDs(boolean preserveUUIDs) {
        this.preserveUUIDs = preserveUUIDs;
    }

    public void setCompressors(String compressors) {
        this.compressors = compressors;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setCleanupOrphansSleepMillis(String sleepMillisString) {
        if (sleepMillisString != null) {
            this.cleanupOrphansSleepMillis = Long.parseLong(sleepMillisString);
        }
    }

    public void setMongoMirrorStartPort(int mongoMirrorStartPort) {
        this.mongoMirrorStartPort = mongoMirrorStartPort;
    }

    public void setOplogBasePath(String oplogBasePath) {
        this.oplogBasePath = oplogBasePath;
    }

    public void setBookmarkFilePrefix(String bookmarkFilePrefix) {
        this.bookmarkFilePrefix = bookmarkFilePrefix;
    }

    public void setReverseSync(boolean reverseSync) {
        this.reverseSync = reverseSync;
    }

    public void setSkipBuildIndexes(boolean skipBuildIndexes) {
        this.skipBuildIndexes = skipBuildIndexes;
    }

    public boolean isSkipFlushRouterConfig() {
        return this.skipFlushRouterConfig;
    }

    public void setSkipFlushRouterConfig(boolean skipFlushRouterConfig) {
        this.skipFlushRouterConfig = skipFlushRouterConfig;
    }

    public String getSourceClusterPattern() {
        return this.sourceClusterPattern;
    }

    public void setSourceClusterPattern(String sourceClusterPattern) {
        this.sourceClusterPattern = sourceClusterPattern;
    }

    public String getDestClusterPattern() {
        return this.destClusterPattern;
    }

    public void setDestClusterPattern(String destClusterPattern) {
        this.destClusterPattern = destClusterPattern;
    }

    public String getSourceRsPattern() {
        return this.sourceRsPattern;
    }

    public void setSourceRsPattern(String sourceRsPattern) {
        this.sourceRsPattern = sourceRsPattern;
    }

    public String getDestRsPattern() {
        return this.destRsPattern;
    }

    public void setDestRsPattern(String destRsPattern) {
        this.destRsPattern = destRsPattern;
    }

    public int getCollStatsThreshold() {
        return this.collStatsThreshold;
    }

    public void setCollStatsThreshold(int collStatsThreshold) {
        this.collStatsThreshold = collStatsThreshold;
    }

    public void setDestCsrsUri(String destCsrsUri) {
        this.destCsrsUri = destCsrsUri;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isShardToRs() {
        return this.shardToRs;
    }

    public void setShardToRs(boolean shardToRs) {
        this.shardToRs = shardToRs;
    }

    public String[] getSourceRsManual() {
        return this.sourceRsManual;
    }

    public void setSourceRsManual(String[] sourceRsManual) {
        this.sourceRsManual = sourceRsManual;
    }

    public String[] getDestRsManual() {
        return this.destRsManual;
    }

    public void setDestRsManual(String[] destRsManual) {
        this.destRsManual = destRsManual;
    }
}

