/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.shardsync;

import com.mongodb.shardsync.ShardConfigSync;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardConfigSyncApp {
    private static Logger logger = LoggerFactory.getLogger(ShardConfigSyncApp.class);
    private static Options options;
    private static CommandLine line;
    private static final String SOURCE_URI = "source";
    private static final String DEST_URI = "dest";
    private static final String SOURCE_URI_PATTERN = "sourceUriPattern";
    private static final String DEST_URI_PATTERN = "destUriPattern";
    private static final String DEST_CSRS_URI = "destCsrs";
    private static final String SOURCE_RS_PATTERN = "sourceRsPattern";
    private static final String DEST_RS_PATTERN = "destRsPattern";
    private static final String SOURCE_RS_MANUAL = "sourceRsManual";
    private static final String DEST_RS_MANUAL = "destRsManual";
    private static final String MONGOMIRROR_BINARY = "mongomirrorBinary";
    private static final String DROP_DEST_DBS = "dropDestDbs";
    private static final String DROP_DEST_DBS_AND_CONFIG_METADATA = "dropDestDbsAndConfigMeta";
    public static final String NON_PRIVILEGED = "nonPrivileged";
    private static final String PRESERVE_UUIDS = "preserveUUIDs";
    private static final String SKIP_BUILD_INDEXES = "skipBuildIndexes";
    private static final String COMPRESSORS = "compressors";
    private static final String COLL_STATS_THRESHOLD = "collStatsThreshold";
    private static final String COLL_COUNTS = "compareCounts";
    private static final String CHUNK_COUNTS = "chunkCounts";
    private static final String FLUSH_ROUTER = "flushRouter";
    private static final String SYNC_METADATA = "syncMetadata";
    private static final String COMPARE_CHUNKS = "compareChunks";
    private static final String COMPARE_COLLECTION_UUIDS = "compareCollectionUuids";
    private static final String DISABLE_SOURCE_AUTOSPLIT = "disableSourceAutosplit";
    private static final String MONGOMIRROR_START_PORT = "mongoMirrorStartPort";
    private static final String OPLOG_BASE_PATH = "oplogBasePath";
    private static final String BOOKMARK_FILE_PREFIX = "bookmarkFilePrefix";
    private static final String SKIP_FLUSH_ROUTER_CONFIG = "skipFlushRouterConfig";
    private static final String COMPARE_AND_MOVE_CHUNKS = "compareAndMoveChunks";
    private static final String MONGO_MIRROR = "mongomirror";
    private static final String DRY_RUN = "dryRun";
    private static final String TAIL_FROM_TS = "tailFromTs";
    private static final String TAIL_FROM_NOW = "tailFromNow";
    private static final String TAIL_FROM_LATEST_OPLOG_TS = "tailFromLatestOplogTs";
    private static final String SHARD_COLLECTIONS = "shardCollections";
    private static final String CREATE_CHUNKS = "createChunks";
    private static final String CLEANUP_ORPHANS = "cleanupOrphans";
    private static final String CLEANUP_ORPHANS_SLEEP = "cleanupOrphansSleep";
    private static final String CLEANUP_ORPHANS_DEST = "cleanupOrphansDest";
    private static final String SYNC_INDEXES = "syncIndexes";
    private static final String COMPARE_INDEXES = "compareIndexes";
    private static final String EXTEND_TTL = "extendTtl";
    private static final String CLEANUP_PREVIOUS_ALL = "cleanupPreviousAll";
    private static final String CLEANUP_PREVIOUS_SHARDS = "cleanupPreviousShards";
    private static final String SSL_ALLOW_INVALID_HOSTNAMES = "sslAllowInvalidHostnames";
    private static final String SSL_ALLOW_INVALID_CERTS = "sslAllowInvalidCertificates";
    private static final String SHARD_MAP = "shardMap";

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"Configuration properties file");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"config");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"Source cluster connection uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)SOURCE_URI);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"Destination cluster connection uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)DEST_URI);
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"Drop destination databases, but preserve config metadata");
        OptionBuilder.withLongOpt((String)DROP_DEST_DBS);
        options.addOption(OptionBuilder.create((String)DROP_DEST_DBS));
        OptionBuilder.withArgName((String)"Drop destination databases AND config metadata (collections, databases, chunks)");
        OptionBuilder.withLongOpt((String)DROP_DEST_DBS_AND_CONFIG_METADATA);
        options.addOption(OptionBuilder.create((String)DROP_DEST_DBS_AND_CONFIG_METADATA));
        OptionBuilder.withArgName((String)"Non-privileged mode, create chunks using splitChunk");
        OptionBuilder.withLongOpt((String)NON_PRIVILEGED);
        options.addOption(OptionBuilder.create((String)NON_PRIVILEGED));
        OptionBuilder.withArgName((String)"Compare counts only (do not sync/migrate)");
        OptionBuilder.withLongOpt((String)COLL_COUNTS);
        options.addOption(OptionBuilder.create((String)COLL_COUNTS));
        OptionBuilder.withArgName((String)"Show chunk counts when collection counts differ");
        OptionBuilder.withLongOpt((String)CHUNK_COUNTS);
        options.addOption(OptionBuilder.create((String)CHUNK_COUNTS));
        OptionBuilder.withArgName((String)"Flush router config on all mongos (do not sync/migrate)");
        OptionBuilder.withLongOpt((String)FLUSH_ROUTER);
        options.addOption(OptionBuilder.create((String)FLUSH_ROUTER));
        OptionBuilder.withArgName((String)"Compare all shard chunks (do not sync/migrate)");
        OptionBuilder.withLongOpt((String)COMPARE_CHUNKS);
        options.addOption(OptionBuilder.create((String)COMPARE_CHUNKS));
        OptionBuilder.withArgName((String)"Compare all shard chunks, move any misplaced chunks");
        OptionBuilder.withLongOpt((String)COMPARE_AND_MOVE_CHUNKS);
        options.addOption(OptionBuilder.create((String)COMPARE_AND_MOVE_CHUNKS));
        OptionBuilder.withArgName((String)"Compare all collection UUIDs");
        OptionBuilder.withLongOpt((String)COMPARE_COLLECTION_UUIDS);
        options.addOption(OptionBuilder.create((String)COMPARE_COLLECTION_UUIDS));
        OptionBuilder.withArgName((String)"Cleanup (remove) destination data on all shards");
        OptionBuilder.withLongOpt((String)CLEANUP_PREVIOUS_ALL);
        options.addOption(OptionBuilder.create((String)CLEANUP_PREVIOUS_ALL));
        OptionBuilder.withArgName((String)"Cleanup (remove) destination data on specified shards");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)CLEANUP_PREVIOUS_SHARDS);
        options.addOption(OptionBuilder.create((String)CLEANUP_PREVIOUS_SHARDS));
        OptionBuilder.withArgName((String)"Synchronize shard metadata");
        OptionBuilder.withLongOpt((String)SYNC_METADATA);
        options.addOption(OptionBuilder.create((String)SYNC_METADATA));
        OptionBuilder.withArgName((String)"Shard mapping");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)SHARD_MAP);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"Disable autosplit on source cluster");
        OptionBuilder.withLongOpt((String)DISABLE_SOURCE_AUTOSPLIT);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"Cleanup source orphans");
        OptionBuilder.withLongOpt((String)CLEANUP_ORPHANS);
        options.addOption(OptionBuilder.create((String)CLEANUP_ORPHANS));
        OptionBuilder.withArgName((String)"Cleanup destination orphans");
        OptionBuilder.withLongOpt((String)CLEANUP_ORPHANS_DEST);
        options.addOption(OptionBuilder.create((String)CLEANUP_ORPHANS_DEST));
        OptionBuilder.withArgName((String)"cleanup orphans sleep millis");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)CLEANUP_ORPHANS_SLEEP);
        options.addOption(OptionBuilder.create((String)CLEANUP_ORPHANS_SLEEP));
        OptionBuilder.withArgName((String)"Shard destination collections");
        OptionBuilder.withLongOpt((String)SHARD_COLLECTIONS);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"Create destination chunks only");
        OptionBuilder.withLongOpt((String)CREATE_CHUNKS);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"Copy indexes from source to dest");
        OptionBuilder.withLongOpt((String)SYNC_INDEXES);
        options.addOption(OptionBuilder.create((String)SYNC_INDEXES));
        OptionBuilder.withArgName((String)"Compare indexes from source to dest");
        OptionBuilder.withLongOpt((String)COMPARE_INDEXES);
        options.addOption(OptionBuilder.create((String)COMPARE_INDEXES));
        OptionBuilder.withArgName((String)"Extend TTL expiration (use with syncIndexes)");
        OptionBuilder.withLongOpt((String)EXTEND_TTL);
        options.addOption(OptionBuilder.create((String)EXTEND_TTL));
        OptionBuilder.withArgName((String)"Skip the flushRouterConfig step");
        OptionBuilder.withLongOpt((String)SKIP_FLUSH_ROUTER_CONFIG);
        options.addOption(OptionBuilder.create((String)SKIP_FLUSH_ROUTER_CONFIG));
        OptionBuilder.withArgName((String)"ssl allow invalid hostnames");
        OptionBuilder.withLongOpt((String)SSL_ALLOW_INVALID_HOSTNAMES);
        options.addOption(OptionBuilder.create((String)SSL_ALLOW_INVALID_HOSTNAMES));
        OptionBuilder.withArgName((String)"ssl allow invalid certificates");
        OptionBuilder.withLongOpt((String)SSL_ALLOW_INVALID_CERTS);
        options.addOption(OptionBuilder.create((String)SSL_ALLOW_INVALID_CERTS));
        OptionBuilder.withArgName((String)"Execute mongomirror(s)");
        OptionBuilder.withLongOpt((String)MONGO_MIRROR);
        options.addOption(OptionBuilder.create((String)MONGO_MIRROR));
        OptionBuilder.withArgName((String)"Dry run only");
        OptionBuilder.withLongOpt((String)DRY_RUN);
        options.addOption(OptionBuilder.create((String)DRY_RUN));
        OptionBuilder.withArgName((String)"mongomirror tail only starting at current ts");
        OptionBuilder.withLongOpt((String)TAIL_FROM_NOW);
        options.addOption(OptionBuilder.create((String)TAIL_FROM_NOW));
        OptionBuilder.withArgName((String)"mongomirror tail only starting from latest oplog ts");
        OptionBuilder.withLongOpt((String)TAIL_FROM_LATEST_OPLOG_TS);
        options.addOption(OptionBuilder.create((String)TAIL_FROM_LATEST_OPLOG_TS));
        OptionBuilder.withArgName((String)"mongomirror tail only from specificed oplog ts (ts,increment format)");
        OptionBuilder.withLongOpt((String)TAIL_FROM_TS);
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)TAIL_FROM_TS));
        OptionBuilder.withArgName((String)"mongomirror namespace filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"filter");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"full path to mongomirror binary");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)MONGOMIRROR_BINARY);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"mongomirror preserve dest UUIDs (not supported for Atlas dest)");
        OptionBuilder.withLongOpt((String)PRESERVE_UUIDS);
        options.addOption(OptionBuilder.create((String)PRESERVE_UUIDS));
        OptionBuilder.withArgName((String)"skip build indexes");
        OptionBuilder.withLongOpt((String)SKIP_BUILD_INDEXES);
        options.addOption(OptionBuilder.create((String)SKIP_BUILD_INDEXES));
        OptionBuilder.withArgName((String)"mongomirror compressors");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)COMPRESSORS);
        options.addOption(OptionBuilder.create((String)COMPRESSORS));
        OptionBuilder.withArgName((String)"mongomirror collStatsThreshold");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)COLL_STATS_THRESHOLD);
        options.addOption(OptionBuilder.create((String)COLL_STATS_THRESHOLD));
        OptionBuilder.withArgName((String)"mongomirror http status starting port (default 9001)");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)MONGOMIRROR_START_PORT);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"mongomirror numParallelCollections");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"numParallelCollections");
        options.addOption(OptionBuilder.create((String)"y"));
        OptionBuilder.withArgName((String)"mongomirror writeConcern");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"writeConcern");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withArgName((String)"mongomirror oplogPath base path");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)OPLOG_BASE_PATH);
        options.addOption(OptionBuilder.create((String)OPLOG_BASE_PATH));
        OptionBuilder.withArgName((String)"mongomirror bookmark filename prefix");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)BOOKMARK_FILE_PREFIX);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"Sleep millis");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"sleepMillis");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"x"));
        OptionBuilder.withArgName((String)"Diff chunks");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"diffChunks");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withArgName((String)"shardToRs");
        OptionBuilder.withLongOpt((String)"shardToRs");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withArgName((String)"diffShardKeys [sync|diff]");
        OptionBuilder.withLongOpt((String)"diffShardKeys");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"k"));
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                ShardConfigSyncApp.printHelpAndExit();
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            ShardConfigSyncApp.printHelpAndExit();
        }
        catch (Exception e) {
            e.printStackTrace();
            ShardConfigSyncApp.printHelpAndExit();
        }
        return line;
    }

    private static void printHelpAndExit() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("shardSync", options);
        System.exit(-1);
    }

    private static Configuration readProperties() {
        Configurations configs = new Configurations();
        PropertiesConfiguration defaultConfig = new PropertiesConfiguration();
        File propsFile = null;
        if (line.hasOption("c")) {
            propsFile = new File(line.getOptionValue("c"));
        } else {
            propsFile = new File("shard-sync.properties");
            if (!propsFile.exists()) {
                logger.warn("Default config file shard-sync.properties not found, using command line options only");
                return defaultConfig;
            }
        }
        try {
            PropertiesConfiguration config = configs.properties(propsFile);
            return config;
        }
        catch (ConfigurationException e) {
            logger.error("Error loading properties file: " + propsFile, (Throwable)e);
            return defaultConfig;
        }
    }

    public static void main(String[] args) throws Exception {
        String shardMaps;
        CommandLine line = ShardConfigSyncApp.initializeAndParseCommandLineOptions(args);
        Configuration config = ShardConfigSyncApp.readProperties();
        ShardConfigSync sync = new ShardConfigSync();
        sync.setSourceClusterUri(line.getOptionValue("s", config.getString(SOURCE_URI)));
        sync.setDestClusterUri(line.getOptionValue("d", config.getString(DEST_URI)));
        sync.setSourceClusterPattern(config.getString(SOURCE_URI_PATTERN));
        sync.setDestClusterPattern(config.getString(DEST_URI_PATTERN));
        sync.setSourceRsManual(config.getStringArray(SOURCE_RS_MANUAL));
        sync.setDestRsManual(config.getStringArray(DEST_RS_MANUAL));
        sync.setDestCsrsUri(config.getString(DEST_CSRS_URI));
        sync.setSourceRsPattern(config.getString(SOURCE_RS_PATTERN));
        sync.setDestRsPattern(config.getString(DEST_RS_PATTERN));
        if (sync.getSourceClusterUri() == null && sync.getSourceClusterPattern() == null || sync.getDestClusterUri() == null && sync.getDestClusterPattern() == null) {
            System.out.println(String.format("%s/%s and/or %s/%s options required", SOURCE_URI, DEST_URI, SOURCE_URI_PATTERN, DEST_URI_PATTERN));
            ShardConfigSyncApp.printHelpAndExit();
        }
        if ((shardMaps = config.getString(SHARD_MAP)) != null) {
            sync.setShardMappings(shardMaps.split(","));
        } else {
            sync.setShardMappings(line.getOptionValues("m"));
        }
        sync.setNamespaceFilters(line.getOptionValues("f"));
        boolean nonPrivilegedMode = line.hasOption(NON_PRIVILEGED) || config.getBoolean(NON_PRIVILEGED, false);
        sync.setNonPrivilegedMode(nonPrivilegedMode);
        sync.setSkipBuildIndexes(line.hasOption(SKIP_BUILD_INDEXES));
        sync.setDropDestDbs(line.hasOption(DROP_DEST_DBS));
        sync.setDropDestDbsAndConfigMetadata(line.hasOption(DROP_DEST_DBS_AND_CONFIG_METADATA));
        sync.setSleepMillis(line.getOptionValue("x"));
        sync.setNumParallelCollections(line.getOptionValue("y"));
        sync.setWriteConcern(line.getOptionValue("w"));
        sync.setDryRun(line.hasOption(DRY_RUN));
        sync.setSslAllowInvalidCertificates(line.hasOption(SSL_ALLOW_INVALID_CERTS));
        sync.setSslAllowInvalidHostnames(line.hasOption(SSL_ALLOW_INVALID_HOSTNAMES));
        if (line.hasOption(SKIP_FLUSH_ROUTER_CONFIG) || config.getBoolean(SKIP_FLUSH_ROUTER_CONFIG, false)) {
            sync.setSkipFlushRouterConfig(true);
        }
        if (line.hasOption("r")) {
            sync.setShardToRs(true);
        }
        sync.initializeShardMappings();
        boolean actionFound = false;
        if (line.hasOption(COLL_COUNTS)) {
            actionFound = true;
            sync.compareShardCounts();
        } else if (line.hasOption(CHUNK_COUNTS)) {
            actionFound = true;
            sync.compareChunkCounts();
        } else if (line.hasOption(FLUSH_ROUTER)) {
            actionFound = true;
            sync.flushRouterConfig();
        } else if (line.hasOption(DISABLE_SOURCE_AUTOSPLIT)) {
            actionFound = true;
            sync.disableSourceAutosplit();
        } else if (line.hasOption(COMPARE_CHUNKS)) {
            actionFound = true;
            sync.compareChunks();
        } else if (line.hasOption(COMPARE_AND_MOVE_CHUNKS)) {
            actionFound = true;
            if (nonPrivilegedMode) {
                sync.compareAndMoveChunks(true, false);
            } else {
                sync.compareAndMoveChunks(true, false);
            }
        } else if (line.hasOption(COMPARE_COLLECTION_UUIDS)) {
            actionFound = true;
            sync.compareCollectionUuids();
        } else if (line.hasOption(SYNC_METADATA)) {
            actionFound = true;
            sync.migrateMetadata();
        } else if (line.hasOption(SHARD_COLLECTIONS)) {
            actionFound = true;
            sync.shardCollections();
        } else if (line.hasOption(CREATE_CHUNKS)) {
            actionFound = true;
            sync.migrateMetadata(false, false);
        } else if (line.hasOption(SYNC_INDEXES)) {
            actionFound = true;
            boolean extendTtl = line.hasOption(EXTEND_TTL);
            sync.syncIndexesShards(true, extendTtl);
        } else if (line.hasOption(COMPARE_INDEXES)) {
            actionFound = true;
            boolean extendTtl = line.hasOption(EXTEND_TTL);
            sync.syncIndexesShards(false, extendTtl);
        } else if (line.hasOption("z")) {
            actionFound = true;
            sync.diffChunks(line.getOptionValue("z"));
        } else if (line.hasOption("k")) {
            String opt = line.getOptionValue("k");
            boolean doSync = opt.equals("sync");
            actionFound = true;
            sync.diffShardedCollections(doSync);
        } else if (line.hasOption(CLEANUP_ORPHANS)) {
            actionFound = true;
            sync.setCleanupOrphansSleepMillis(line.getOptionValue(CLEANUP_ORPHANS_SLEEP));
            sync.cleanupOrphans();
        } else if (line.hasOption(CLEANUP_ORPHANS_DEST)) {
            actionFound = true;
            sync.cleanupOrphansDest();
        } else if (line.hasOption(DROP_DEST_DBS)) {
            actionFound = true;
            sync.dropDestinationDatabases();
        } else if (line.hasOption(DROP_DEST_DBS_AND_CONFIG_METADATA)) {
            actionFound = true;
            sync.dropDestinationDatabasesAndConfigMetadata();
        } else if (line.hasOption(CLEANUP_PREVIOUS_ALL)) {
            actionFound = true;
            sync.cleanupPreviousAll();
        } else if (line.hasOption(CLEANUP_PREVIOUS_SHARDS)) {
            actionFound = true;
            String[] shardNames = line.getOptionValues(CLEANUP_PREVIOUS_SHARDS);
            HashSet<String> shardNamesSet = new HashSet<String>();
            shardNamesSet.addAll(Arrays.asList(shardNames));
            sync.cleanupPreviousShards(shardNamesSet);
        }
        if (line.hasOption(MONGO_MIRROR) && !line.hasOption("r")) {
            actionFound = true;
            String mongoMirrorPath = line.getOptionValue("p", config.getString(MONGOMIRROR_BINARY));
            boolean skipBuildIndexes = line.hasOption(SKIP_BUILD_INDEXES);
            boolean preserveUUIDs = line.hasOption(PRESERVE_UUIDS);
            if (line.hasOption(COLL_STATS_THRESHOLD)) {
                Integer collStatsThreshold = Integer.parseInt(line.getOptionValue(COLL_STATS_THRESHOLD));
                sync.setCollStatsThreshold(collStatsThreshold);
            } else if (config.getProperty(COLL_STATS_THRESHOLD) != null) {
                sync.setCollStatsThreshold(config.getInt(COLL_STATS_THRESHOLD));
            }
            if (line.hasOption(COMPRESSORS)) {
                sync.setCompressors(line.getOptionValue(COMPRESSORS));
            }
            if (line.hasOption(MONGOMIRROR_START_PORT)) {
                Integer startPort = Integer.parseInt(line.getOptionValue(MONGOMIRROR_START_PORT));
                sync.setMongoMirrorStartPort(startPort);
            }
            sync.setOplogBasePath(line.getOptionValue(OPLOG_BASE_PATH));
            sync.setBookmarkFilePrefix(line.getOptionValue(BOOKMARK_FILE_PREFIX));
            if (mongoMirrorPath == null) {
                System.out.println("mongomirrorPath required");
                ShardConfigSyncApp.printHelpAndExit();
            }
            sync.setMongomirrorBinary(mongoMirrorPath);
            sync.setDropDestDbs(line.hasOption(DROP_DEST_DBS));
            sync.setPreserveUUIDs(preserveUUIDs);
            sync.setSkipBuildIndexes(skipBuildIndexes);
            if (line.hasOption(TAIL_FROM_NOW)) {
                sync.mongomirrorTailFromNow();
            } else if (line.hasOption(TAIL_FROM_LATEST_OPLOG_TS)) {
                sync.mongomirrorTailFromLatestOplogTs(null);
            } else if (line.hasOption(TAIL_FROM_TS)) {
                sync.mongomirrorTailFromTs(line.getOptionValue(TAIL_FROM_TS));
            } else {
                sync.mongomirror();
            }
        }
        if (line.hasOption("r") && line.hasOption(MONGO_MIRROR)) {
            logger.debug("shardToRs");
            actionFound = true;
            String mongoMirrorPath = line.getOptionValue("p", config.getString(MONGOMIRROR_BINARY));
            sync.setMongomirrorBinary(mongoMirrorPath);
            sync.setDropDestDbs(line.hasOption(DROP_DEST_DBS));
            sync.shardToRs();
        }
        if (!actionFound) {
            System.out.println("Missing action");
            ShardConfigSyncApp.printHelpAndExit();
        }
    }
}

