/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.stats;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="currentOpAnalyzer", mixinStandardHelpOptions=true, version={"schemaAnalyzer 0.1"})
public class CurrentOpAnalyzer
implements Callable<Integer> {
    private static Logger logger = LoggerFactory.getLogger(CurrentOpAnalyzer.class);
    @CommandLine.Option(names={"--uri"}, description={"mongodb uri connection string"}, required=true)
    private String uri;
    MongoClient mongoClient;

    private void connect() {
        ConnectionString connectionString = new ConnectionString(this.uri);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        this.mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    private void analyze() throws IOException {
        MongoDatabase db = this.mongoClient.getDatabase("admin");
        ArrayList<Document> pipeline = new ArrayList<Document>(1);
        pipeline.add(new Document("$currentOp", (Object)new Document()));
        AggregateIterable it = null;
        int i = 0;
        while (i < 1000) {
            it = db.aggregate(pipeline);
            for (Document result : it) {
                Document meta = (Document)result.get((Object)"clientMetadata");
                if (meta == null) continue;
                Document driver = (Document)meta.get((Object)"driver");
                System.out.println(driver.hashCode());
            }
            ++i;
        }
    }

    @Override
    public Integer call() throws Exception {
        this.connect();
        this.analyze();
        return 0;
    }

    public static void main(String ... args) {
        int exitCode = new CommandLine((Object)new CurrentOpAnalyzer()).execute(args);
        System.exit(exitCode);
    }
}

