/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.stats;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsUtil {
    private static Logger logger = LoggerFactory.getLogger(StatsUtil.class);
    private String mongoUri;
    private String database;
    private String collection;
    private String groupField;
    DescriptiveStatistics sizeStats = new DescriptiveStatistics();
    private Map<BsonValue, DescriptiveStatistics> statsMap = new TreeMap<BsonValue, DescriptiveStatistics>();
    private MongoClient client;

    public void setMongoUri(String mongoUri) {
        this.mongoUri = mongoUri;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    public void init() {
        ConnectionString connectionString = new ConnectionString(this.mongoUri);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        this.client = MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    public void getIndexes() {
        for (Document index : this.client.getDatabase(this.database).getCollection(this.collection).listIndexes()) {
            logger.debug("existing index: " + index);
            Document document = (Document)index.get((Object)"key");
        }
    }

    public void stats() {
        MongoDatabase db = this.client.getDatabase(this.database);
        MongoCollection mongoCollection = db.getCollection(this.collection, RawBsonDocument.class);
        this.getIndexes();
        FindIterable findIterable = mongoCollection.find();
        findIterable.noCursorTimeout(true);
        for (RawBsonDocument doc : findIterable) {
            DescriptiveStatistics value;
            int size = doc.getByteBuffer().remaining();
            this.sizeStats.addValue((double)size);
            BsonValue groupKey = StatsUtil.getNested(this.groupField, (BsonDocument)doc);
            if (groupKey == null) {
                groupKey = new BsonString("null");
            }
            if ((value = this.statsMap.get(groupKey)) == null) {
                value = new DescriptiveStatistics();
                this.statsMap.put(groupKey, value);
            }
            value.addValue((double)size);
        }
        System.out.println(String.format("%20s %6s %6s %6s %10s", "Value", "Avg", "Max", "p95", "Total"));
        System.out.println(String.format("%20s %6s %6s %6s %10s", StatsUtil.header(20), StatsUtil.header(6), StatsUtil.header(6), StatsUtil.header(6), StatsUtil.header(10)));
        for (Map.Entry<BsonValue, DescriptiveStatistics> entry : this.statsMap.entrySet()) {
            StatsUtil.printStats(entry.getKey().asString().getValue(), entry.getValue());
        }
    }

    private static String header(int n) {
        return new String(new char[n]).replace("\u0000", "=");
    }

    private static BsonValue getNested(String key, BsonDocument doc) {
        String[] keys = key.split("\\.");
        BsonValue current = null;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            current = current != null ? ((BsonDocument)current).get((Object)k) : doc.get((Object)k);
            ++n2;
        }
        return current;
    }

    private static void printStats(String key, DescriptiveStatistics sizeStats) {
        double avg = sizeStats.getMean();
        double max = sizeStats.getMax();
        double p95 = sizeStats.getPercentile(95.0);
        double total = sizeStats.getSum();
        System.out.println(String.format("%20s %6.0f %6.0f %6.0f %10.0f", key, avg, max, p95, total));
    }
}

