/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.stats;

import com.mongodb.stats.StatsUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class StatsUtilApp {
    private static Options options;
    private static final String COLL_COUNTS = "compareCounts";
    private static final String CHUNK_COUNTS = "chunkCounts";
    private static final String COMPARE_IDS = "compareIds";

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"MongoDB connection uri");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"uri");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)"Database name");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"database");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"Collection name");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"collection");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"Group field");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"field");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"f"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                StatsUtilApp.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            StatsUtilApp.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            StatsUtilApp.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("statsUtil", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = StatsUtilApp.initializeAndParseCommandLineOptions(args);
        StatsUtil sync = new StatsUtil();
        sync.setMongoUri(line.getOptionValue("u"));
        sync.setDatabase(line.getOptionValue("d"));
        sync.setCollection(line.getOptionValue("c"));
        sync.setGroupField(line.getOptionValue("f"));
        sync.init();
        sync.stats();
    }
}

