/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.util.FileChannelWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AtomicFileWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger(AtomicFileWriter.class.getName());
    private static boolean DISABLE_FORCED_FLUSH = false;
    private final Writer core;
    private final Path tmpPath;
    private final Path destPath;

    public AtomicFileWriter(File f) throws IOException {
        this(AtomicFileWriter.toPath(f), StandardCharsets.UTF_8);
    }

    public AtomicFileWriter(Path tsFilePath) throws IOException {
        this(tsFilePath, StandardCharsets.UTF_8);
    }

    private static Path toPath(File file) throws IOException {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public AtomicFileWriter(Path destinationPath, Charset charset) throws IOException {
        this(destinationPath, charset, false, true);
    }

    private AtomicFileWriter(Path destinationPath, Charset charset, boolean integrityOnFlush, boolean integrityOnClose) throws IOException {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this.destPath = destinationPath;
        Path dir = this.destPath.getParent();
        if (dir != null && Files.exists(dir, new LinkOption[0]) && !Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException(dir + " exists and is neither a directory nor a symlink to a directory");
        }
        if (dir != null && Files.isSymbolicLink(dir)) {
            LOGGER.log(Level.CONFIG, "{0} is a symlink to a directory", dir);
        } else {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        try {
            this.tmpPath = File.createTempFile("atomic", "tmp", dir.toFile()).toPath();
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temporary file in " + dir, e);
        }
        if (DISABLE_FORCED_FLUSH) {
            integrityOnFlush = false;
            integrityOnClose = false;
        }
        this.core = new FileChannelWriter(this.tmpPath, charset, integrityOnFlush, integrityOnClose, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    }

    @Override
    public void write(int c) throws IOException {
        this.core.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.core.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.core.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.core.flush();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    public void abort() throws IOException {
        this.closeAndDeleteTempFile();
    }

    public void commit() throws IOException {
        this.close();
        try {
            Files.move(this.tmpPath, this.destPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException moveFailed) {
            if (moveFailed instanceof AtomicMoveNotSupportedException) {
                LOGGER.log(Level.WARNING, "Atomic move not supported. falling back to non-atomic move.", moveFailed);
            } else {
                LOGGER.log(Level.WARNING, "Unable to move atomically, falling back to non-atomic move.", moveFailed);
            }
            if (this.destPath.toFile().exists()) {
                LOGGER.log(Level.INFO, "The target file {0} was already existing", this.destPath);
            }
            try {
                Files.move(this.tmpPath, this.destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException replaceFailed) {
                replaceFailed.addSuppressed(moveFailed);
                LOGGER.log(Level.WARNING, "Unable to move {0} to {1}. Attempting to delete {0} and abandoning.", new Path[]{this.tmpPath, this.destPath});
                try {
                    Files.deleteIfExists(this.tmpPath);
                }
                catch (IOException deleteFailed) {
                    replaceFailed.addSuppressed(deleteFailed);
                    LOGGER.log(Level.WARNING, "Unable to delete {0}, good bye then!", this.tmpPath);
                    throw replaceFailed;
                }
                throw replaceFailed;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.closeAndDeleteTempFile();
    }

    private void closeAndDeleteTempFile() throws IOException {
        try {
            this.close();
        }
        finally {
            Files.deleteIfExists(this.tmpPath);
        }
    }

    @Deprecated
    public File getTemporaryFile() {
        return this.tmpPath.toFile();
    }

    public Path getTemporaryPath() {
        return this.tmpPath;
    }
}

